/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import java.io.OutputStream;

public final class MemoryOutputStream
extends OutputStream {
    private byte[] buffer;
    private int count;

    public MemoryOutputStream() {
        this(512);
    }

    public MemoryOutputStream(int size) {
        this.buffer = new byte[size];
    }

    public void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buffer.length) {
            byte[] newbuffer = new byte[this.buffer.length << 1];
            System.arraycopy(this.buffer, 0, newbuffer, 0, this.count);
            this.buffer = newbuffer;
        }
        this.buffer[this.count] = (byte)b;
        this.count = newcount;
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buffer.length) {
            int max = this.buffer.length << 1;
            if (max < newcount) {
                max = newcount << 1;
            }
            byte[] newbuffer = new byte[max];
            System.arraycopy(this.buffer, 0, newbuffer, 0, this.count);
            this.buffer = newbuffer;
        }
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count = newcount;
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }
}

