/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import java.io.InputStream;

public final class MemoryInputStream
extends InputStream {
    byte[] buffer;
    int pos;
    int lastIndex;

    public MemoryInputStream() {
    }

    public MemoryInputStream(byte[] buffer) {
        this.buffer = buffer;
        this.pos = 0;
        this.lastIndex = buffer.length;
    }

    public MemoryInputStream(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.pos = offset;
        this.lastIndex = offset + length;
    }

    public void set(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.pos = offset;
        this.lastIndex = offset + length;
    }

    public int read() {
        return this.pos < this.lastIndex ? this.buffer[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] b, int off, int len) {
        if (this.pos >= this.lastIndex) {
            return -1;
        }
        if (this.pos + len > this.lastIndex) {
            len = this.lastIndex - this.pos;
        }
        System.arraycopy(this.buffer, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public long skip(long n) {
        if ((long)this.pos + n > (long)this.lastIndex) {
            n = this.lastIndex - this.pos;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    public int available() {
        return this.lastIndex - this.pos;
    }
}

