/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class MemoryBuffer {
    public static final int BUFFER_LENGTH_DEFAULT = 1024;
    public static final int BUFFER_LENGTH_MAX = 8096;
    private int wpos = 0;
    private int rpos = 0;
    private byte[] buffer = new byte[1024];
    private OutputStream out = new OutputStream(){

        public void write(byte[] b, int off, int len) {
            MemoryBuffer.this.requireSize(MemoryBuffer.this.wpos + len);
            System.arraycopy(b, off, MemoryBuffer.this.buffer, MemoryBuffer.this.wpos, len);
            MemoryBuffer.this.wpos += len;
        }

        public void write(int b) {
            MemoryBuffer.this.requireSize(MemoryBuffer.this.wpos + 1);
            ((MemoryBuffer)MemoryBuffer.this).buffer[((MemoryBuffer)MemoryBuffer.this).wpos++] = (byte)b;
        }
    };
    private InputStream in = new InputStream(){

        public int read() throws IOException {
            if (MemoryBuffer.this.rpos + 1 > MemoryBuffer.this.wpos) {
                return -1;
            }
            return MemoryBuffer.this.buffer[MemoryBuffer.this.rpos++] & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int stop = Math.min(MemoryBuffer.this.rpos + len, MemoryBuffer.this.wpos);
            int direct = stop - MemoryBuffer.this.rpos;
            System.arraycopy(MemoryBuffer.this.buffer, MemoryBuffer.this.rpos, b, off, direct);
            MemoryBuffer.this.rpos = stop;
            return direct;
        }
    };

    private void requireSize(int size) {
        if (size > this.buffer.length) {
            int newSize = Math.max(size, this.buffer.length * 2);
            byte[] newBuffer = new byte[newSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.wpos);
            this.buffer = newBuffer;
        }
    }

    public int size() {
        return this.wpos;
    }

    public void reset() {
        this.wpos = 0;
        this.rpos = 0;
    }

    public void releaseMemory() {
        this.reset();
        if (this.buffer.length > 8096) {
            this.buffer = new byte[1024];
        }
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }
}

