/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import uka.transport.BasicIO;
import uka.transport.BinaryOutputStream;
import uka.transport.Index;
import uka.transport.MarshalAdapter;
import uka.transport.Replaceable;
import uka.transport.TransportConstants;
import uka.transport.Transportable;
import uka.transport.WireHashtable;

public class MarshalStream
extends BinaryOutputStream
implements ObjectOutput,
TransportConstants {
    protected Bridge oout;
    protected boolean oout_init = false;
    protected boolean oout_used = false;
    protected boolean postProcess;
    protected WireHashtable wireObjectTable;
    protected final WireHashtable wireClassTable;
    boolean enableReplace = false;
    boolean versionSet = false;
    int version;
    private DataOutputStream lazy_dout = null;

    public MarshalStream(OutputStream out) throws IOException {
        this(out, new WireHashtable(), new WireHashtable());
    }

    protected MarshalStream(OutputStream out, WireHashtable wireObjectTable, WireHashtable wireClassTable) throws IOException {
        super(out);
        this.wireObjectTable = wireObjectTable;
        this.wireClassTable = wireClassTable;
    }

    public WireHashtable setObjectSpace(WireHashtable wireObjectTable) {
        WireHashtable oldWireObjectTable = this.wireObjectTable;
        this.wireObjectTable = wireObjectTable;
        return oldWireObjectTable;
    }

    public void symmetricReset() throws IOException {
        this.wireObjectTable.reset();
        if (this.oout_used) {
            this.oout.reset();
            this.oout.writeObject(null);
            this.oout.flush();
            this.oout_used = false;
        }
    }

    public void symmetricResetType() throws IOException {
        this.wireObjectTable.reset();
        this.wireClassTable.reset();
        if (this.oout_used) {
            this.oout.reset();
            this.oout.writeObject(null);
            this.oout.flush();
            this.oout_used = false;
        }
    }

    public final void writeObject(Object obj) throws IOException {
        Object replacement;
        Object replacement2;
        if (obj == null) {
            if (this.bufcnt + 1 > 2048) {
                this.drain();
            }
            this.buf[this.bufcnt++] = 3;
            return;
        }
        int objhandle = this.wireObjectTable.findWireOffset(obj);
        if (objhandle >= 0) {
            if (this.bufcnt + 5 > 2048) {
                this.drain();
            }
            this.buf[this.bufcnt++] = 4;
            this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, objhandle);
            return;
        }
        if (obj instanceof Replaceable && (replacement2 = ((Replaceable)obj).writeReplace()) != obj) {
            if (replacement2 == null) {
                if (this.bufcnt + 1 > 2048) {
                    this.drain();
                }
                this.buf[this.bufcnt++] = 3;
                return;
            }
            int objhandle2 = this.wireObjectTable.findWireOffset(replacement2);
            if (objhandle2 >= 0) {
                if (this.bufcnt + 5 > 2048) {
                    this.drain();
                }
                this.buf[this.bufcnt++] = 4;
                this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, objhandle2);
                return;
            }
            obj = replacement2;
        }
        boolean replaced = false;
        if (!(obj instanceof Serializable) && this.enableReplace && !replaced && (replacement = this.replaceObject(obj)) != obj) {
            if (replacement == null) {
                if (this.bufcnt + 1 > 2048) {
                    this.drain();
                }
                this.buf[this.bufcnt++] = 3;
                return;
            }
            int objhandle3 = this.wireObjectTable.findWireOffset(replacement);
            if (objhandle3 >= 0) {
                if (this.bufcnt + 5 > 2048) {
                    this.drain();
                }
                this.buf[this.bufcnt++] = 4;
                this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, objhandle3);
                return;
            }
            obj = replacement;
            replaced = true;
        }
        Class<?> objClass = obj.getClass();
        if (obj instanceof Transportable) {
            Object replacement3;
            if (this.enableReplace && !replaced && (replacement3 = this.replaceObject(obj)) != obj) {
                if (replacement3 == null) {
                    if (this.bufcnt + 1 > 2048) {
                        this.drain();
                    }
                    this.buf[this.bufcnt++] = 3;
                    return;
                }
                int objhandle4 = this.wireObjectTable.findWireOffset(replacement3);
                if (objhandle4 >= 0) {
                    if (this.bufcnt + 5 > 2048) {
                        this.drain();
                    }
                    this.buf[this.bufcnt++] = 4;
                    this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, objhandle4);
                    return;
                }
                obj = replacement3;
                replaced = true;
            }
            objClass = obj.getClass();
            this.writeDescriptor((byte)5, objClass);
            this.wireObjectTable.assignWireOffset(obj);
            ((Transportable)obj).marshal(this);
            return;
        }
        if (objClass.isArray()) {
            Object replacement4;
            if (this.enableReplace && !replaced && (replacement4 = this.replaceObject(obj)) != obj) {
                if (replacement4 == null) {
                    if (this.bufcnt + 1 > 2048) {
                        this.drain();
                    }
                    this.buf[this.bufcnt++] = 3;
                    return;
                }
                int objhandle5 = this.wireObjectTable.findWireOffset(replacement4);
                if (objhandle5 >= 0) {
                    if (this.bufcnt + 5 > 2048) {
                        this.drain();
                    }
                    this.buf[this.bufcnt++] = 4;
                    this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, objhandle5);
                    return;
                }
                obj = replacement4;
                replaced = true;
            }
            objClass = obj.getClass();
            this.writeDescriptor((byte)6, objClass);
            this.wireObjectTable.assignWireOffset(obj);
            this.writeArray(objClass, obj);
            return;
        }
        MarshalAdapter adapter = MarshalAdapter.getAdapter(objClass);
        if (adapter != null) {
            if (this.bufcnt + 1 > 2048) {
                this.drain();
            }
            this.buf[this.bufcnt++] = (byte)adapter.getTypeConstant();
            this.wireObjectTable.assignWireOffset(obj);
            adapter.marshal(this, obj);
            return;
        }
        if (this.bufcnt + 1 > 2048) {
            this.drain();
        }
        this.buf[this.bufcnt++] = 7;
        if (!this.oout_init) {
            this.oout = new Bridge();
            if (this.versionSet) {
                this.oout.useProtocolVersion(this.version);
            }
            this.oout_init = true;
        }
        this.postProcess = false;
        int first = this.wireObjectTable.getNextWireOffset();
        this.oout_used = true;
        this.oout.writeObject(obj);
        this.postProcess = true;
        int last = this.wireObjectTable.getNextWireOffset();
        for (int id = first; id < last; ++id) {
            this.oout.writeObject(this.wireObjectTable.getObject(id));
        }
        this.oout.flush();
    }

    private void writeDescriptor(byte objDescr, Class objClass) throws IOException {
        int handle = this.wireClassTable.findWireOffset(objClass);
        if (handle >= 0) {
            if (this.bufcnt + 6 > 2048) {
                this.drain();
            }
            byte[] buf = this.buf;
            int bufcnt = this.bufcnt;
            buf[bufcnt++] = objDescr;
            buf[bufcnt++] = 4;
            this.bufcnt = bufcnt = BasicIO.insert(buf, bufcnt, handle);
        } else {
            if (this.bufcnt + 2 > 2048) {
                this.drain();
            }
            byte[] buf = this.buf;
            int bufcnt = this.bufcnt;
            buf[bufcnt++] = objDescr;
            buf[bufcnt++] = 8;
            this.bufcnt = bufcnt;
            this.writeChars(objClass.getName());
            this.wireClassTable.assignWireOffset(objClass);
        }
    }

    private void writeArray(Class objClass, Object obj) throws IOException {
        Class<?> componentClass = objClass.getComponentType();
        if (componentClass.isPrimitive()) {
            if (componentClass == Byte.TYPE) {
                byte[] array = (byte[])obj;
                int length = array.length;
                if (this.bufcnt + 4 > 2048) {
                    this.drain();
                }
                this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, length);
                if (length <= 2048) {
                    if (this.bufcnt + length * 1 > 2048) {
                        this.drain();
                    }
                    this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.writeHugeByteArray(array, 0, length);
                }
                return;
            }
            if (componentClass == Integer.TYPE) {
                int[] array = (int[])obj;
                int length = array.length;
                if (this.bufcnt + 4 > 2048) {
                    this.drain();
                }
                this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, length);
                if (length <= 512) {
                    if (this.bufcnt + length * 4 > 2048) {
                        this.drain();
                    }
                    this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.writeHugeIntArray(array, 0, length);
                }
                return;
            }
            if (componentClass == Character.TYPE) {
                char[] array = (char[])obj;
                int length = array.length;
                if (this.bufcnt + 4 > 2048) {
                    this.drain();
                }
                this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, length);
                if (length <= 1024) {
                    if (this.bufcnt + length * 2 > 2048) {
                        this.drain();
                    }
                    this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.writeHugeCharArray(array, 0, length);
                }
                return;
            }
            if (componentClass == Float.TYPE) {
                float[] array = (float[])obj;
                int length = array.length;
                if (this.bufcnt + 4 > 2048) {
                    this.drain();
                }
                this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, length);
                if (length <= 512) {
                    if (this.bufcnt + length * 4 > 2048) {
                        this.drain();
                    }
                    this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.writeHugeFloatArray(array, 0, length);
                }
                return;
            }
            if (componentClass == Long.TYPE) {
                long[] array = (long[])obj;
                int length = array.length;
                if (this.bufcnt + 4 > 2048) {
                    this.drain();
                }
                this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, length);
                if (length <= 256) {
                    if (this.bufcnt + length * 8 > 2048) {
                        this.drain();
                    }
                    this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.writeHugeLongArray(array, 0, length);
                }
                return;
            }
            if (componentClass == Double.TYPE) {
                double[] array = (double[])obj;
                int length = array.length;
                if (this.bufcnt + 4 > 2048) {
                    this.drain();
                }
                this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, length);
                if (length <= 256) {
                    if (this.bufcnt + length * 8 > 2048) {
                        this.drain();
                    }
                    this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.writeHugeDoubleArray(array, 0, length);
                }
                return;
            }
            if (componentClass == Short.TYPE) {
                short[] array = (short[])obj;
                int length = array.length;
                if (this.bufcnt + 4 > 2048) {
                    this.drain();
                }
                this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, length);
                if (length <= 1024) {
                    if (this.bufcnt + length * 2 > 2048) {
                        this.drain();
                    }
                    this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.writeHugeShortArray(array, 0, length);
                }
                return;
            }
            if (componentClass == Boolean.TYPE) {
                boolean[] array = (boolean[])obj;
                int length = array.length;
                if (this.bufcnt + 4 > 2048) {
                    this.drain();
                }
                this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, length);
                if (length <= 2048) {
                    if (this.bufcnt + length * 1 > 2048) {
                        this.drain();
                    }
                    this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.writeHugeBooleanArray(array, 0, length);
                }
                return;
            }
            throw new IOException("unknown array type '" + objClass.getName() + "'");
        }
        Object[] array = (Object[])obj;
        int length = array.length;
        if (this.bufcnt + 4 > 2048) {
            this.drain();
        }
        this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, length);
        for (int n = 0; n < length; ++n) {
            this.writeObject(array[n]);
        }
    }

    protected boolean enableReplaceObject(boolean enable) throws SecurityException {
        boolean previous = this.enableReplace;
        this.enableReplace = enable;
        return previous;
    }

    public void useProtocolVersion(int version) throws IOException {
        if (!this.oout_init) {
            this.versionSet = true;
            this.version = version;
        } else {
            this.oout.useProtocolVersion(version);
        }
    }

    protected void annotateClass(Class cl) throws IOException {
    }

    protected Object replaceObject(Object obj) throws IOException {
        return obj;
    }

    protected void writeStreamHeader() throws IOException {
        if (this.bufcnt + 4 > 2048) {
            this.drain();
        }
        byte[] buf = this.buf;
        int bufcnt = this.bufcnt;
        buf[bufcnt++] = 85;
        buf[bufcnt++] = 75;
        buf[bufcnt++] = 65;
        buf[bufcnt++] = 1;
        this.bufcnt = bufcnt;
    }

    private DataOutputStream getDataOutputStream() {
        if (this.lazy_dout == null) {
            this.lazy_dout = new DataOutputStream(this);
        }
        return this.lazy_dout;
    }

    public void writeBytes(String data) throws IOException {
        this.getDataOutputStream().writeBytes(data);
    }

    public void writeUTF(String data) throws IOException {
        this.getDataOutputStream().writeUTF(data);
    }

    public class Bridge
    extends ObjectOutputStream {
        public Bridge() throws IOException {
            super(MarshalStream.this);
            this.enableReplaceObject(true);
        }

        public MarshalStream getParent() {
            return MarshalStream.this;
        }

        protected Object replaceObject(Object orig) throws IOException {
            int id;
            if (MarshalStream.this.postProcess) {
                return orig;
            }
            if (MarshalStream.this.enableReplace) {
                orig = MarshalStream.this.replaceObject(orig);
            }
            if ((id = MarshalStream.this.wireObjectTable.findWireOffset(orig)) >= 0) {
                return new Index(id);
            }
            id = MarshalStream.this.wireObjectTable.assignWireOffset(orig);
            return orig;
        }

        protected void annotateClass(Class cl) throws IOException {
            MarshalStream.this.annotateClass(cl);
        }
    }
}

