/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import java.io.IOException;
import uka.transport.BasicIO;
import uka.transport.MarshalStream;
import uka.transport.UnmarshalStream;

public class MarshalContext {
    private MarshalStream snd;
    private int sndPos;
    private byte[] sndBuffer;
    private boolean objectsSent;
    private UnmarshalStream rcv;
    private int rcvPos;
    private byte[] rcvBuffer;
    private boolean objectsReceived;

    public MarshalContext(MarshalStream snd, UnmarshalStream rcv) {
        this.snd = snd;
        this.rcv = rcv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.snd.close();
        }
        finally {
            this.rcv.close();
        }
    }

    public final void openSendPrimitive(int primLength) throws IOException {
        this.snd.reserve(primLength);
        this.sndBuffer = this.snd.getBuffer();
        this.sndPos = this.snd.getPosition();
    }

    public final void closeSendPrimitive(int primLength) throws IOException {
        this.snd.deliver(primLength);
        this.sndBuffer = null;
    }

    public final void sendObject(Object value) throws IOException {
        this.snd.writeObject(value);
        if (value != null) {
            this.objectsSent = true;
        }
    }

    public final void openReceivePrimitive(int primLength) throws IOException {
        this.rcv.request(primLength);
        this.rcvBuffer = this.rcv.getBuffer();
        this.rcvPos = this.rcv.getPosition();
    }

    public final void closeReceivePrimitive(int primLength) throws IOException {
        this.rcv.accept(primLength);
    }

    public final Object receiveObject() throws IOException, ClassNotFoundException {
        Object result = this.rcv.readObject();
        if (result != null) {
            this.objectsReceived = true;
        }
        return result;
    }

    public final void sendSingleBoolean(boolean value) throws IOException {
        this.snd.writeBoolean(value);
    }

    public final boolean receiveSingleBoolean() throws IOException {
        boolean result = this.rcv.readBoolean();
        return result;
    }

    public final void sendBoolean(boolean value) {
        this.sndPos = BasicIO.insert(this.sndBuffer, this.sndPos, value);
    }

    public final boolean receiveBoolean() {
        boolean result = BasicIO.extractBoolean(this.rcvBuffer, this.rcvPos);
        ++this.rcvPos;
        return result;
    }

    public final void sendSingleByte(byte value) throws IOException {
        this.snd.writeByte(value);
    }

    public final byte receiveSingleByte() throws IOException {
        byte result = this.rcv.readByte();
        return result;
    }

    public final void sendByte(byte value) {
        this.sndPos = BasicIO.insert(this.sndBuffer, this.sndPos, value);
    }

    public final byte receiveByte() {
        byte result = BasicIO.extractByte(this.rcvBuffer, this.rcvPos);
        ++this.rcvPos;
        return result;
    }

    public final void sendSingleChar(char value) throws IOException {
        this.snd.writeChar(value);
    }

    public final char receiveSingleChar() throws IOException {
        char result = this.rcv.readChar();
        return result;
    }

    public final void sendChar(char value) {
        this.sndPos = BasicIO.insert(this.sndBuffer, this.sndPos, value);
    }

    public final char receiveChar() {
        char result = BasicIO.extractChar(this.rcvBuffer, this.rcvPos);
        this.rcvPos += 2;
        return result;
    }

    public final void sendSingleShort(short value) throws IOException {
        this.snd.writeShort(value);
    }

    public final short receiveSingleShort() throws IOException {
        short result = this.rcv.readShort();
        return result;
    }

    public final void sendShort(short value) {
        this.sndPos = BasicIO.insert(this.sndBuffer, this.sndPos, value);
    }

    public final short receiveShort() {
        short result = BasicIO.extractShort(this.rcvBuffer, this.rcvPos);
        this.rcvPos += 2;
        return result;
    }

    public final void sendSingleInt(int value) throws IOException {
        this.snd.writeInt(value);
    }

    public final int receiveSingleInt() throws IOException {
        int result = this.rcv.readInt();
        return result;
    }

    public final void sendInt(int value) {
        this.sndPos = BasicIO.insert(this.sndBuffer, this.sndPos, value);
    }

    public final int receiveInt() {
        int result = BasicIO.extractInt(this.rcvBuffer, this.rcvPos);
        this.rcvPos += 4;
        return result;
    }

    public final void sendSingleLong(long value) throws IOException {
        this.snd.writeLong(value);
    }

    public final long receiveSingleLong() throws IOException {
        long result = this.rcv.readLong();
        return result;
    }

    public final void sendLong(long value) {
        this.sndPos = BasicIO.insert(this.sndBuffer, this.sndPos, value);
    }

    public final long receiveLong() {
        long result = BasicIO.extractLong(this.rcvBuffer, this.rcvPos);
        this.rcvPos += 8;
        return result;
    }

    public final void sendSingleFloat(float value) throws IOException {
        this.snd.writeFloat(value);
    }

    public final float receiveSingleFloat() throws IOException {
        float result = this.rcv.readFloat();
        return result;
    }

    public final void sendFloat(float value) {
        this.sndPos = BasicIO.insert(this.sndBuffer, this.sndPos, value);
    }

    public final float receiveFloat() {
        float result = BasicIO.extractFloat(this.rcvBuffer, this.rcvPos);
        this.rcvPos += 4;
        return result;
    }

    public final void sendSingleDouble(double value) throws IOException {
        this.snd.writeDouble(value);
    }

    public final double receiveSingleDouble() throws IOException {
        double result = this.rcv.readDouble();
        return result;
    }

    public final void sendDouble(double value) {
        this.sndPos = BasicIO.insert(this.sndBuffer, this.sndPos, value);
    }

    public final double receiveDouble() {
        double result = BasicIO.extractDouble(this.rcvBuffer, this.rcvPos);
        this.rcvPos += 8;
        return result;
    }

    public final void flush() throws IOException {
        this.snd.flush();
    }

    public final void resetSend() throws IOException {
        this.snd.symmetricReset();
        this.objectsSent = false;
    }

    public final boolean areObjectsSent() {
        return this.objectsSent;
    }

    public final void resetReceive() throws IOException {
        this.rcv.symmetricReset();
        this.objectsReceived = false;
    }

    public final boolean areObjectsReceived() {
        return this.objectsReceived;
    }
}

