/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import java.io.IOException;
import java.util.HashMap;
import uka.transport.BasicIO;
import uka.transport.MarshalStream;
import uka.transport.TransportConstants;
import uka.transport.UnmarshalStream;

public abstract class MarshalAdapter
implements TransportConstants {
    private final Class type;
    private final int typeConstant;
    private static final MarshalAdapter[] tc2adapter = new MarshalAdapter[256];
    private static final HashMap type2adapter = new HashMap();

    private MarshalAdapter(int typeConstant, Class type) {
        if (typeConstant < 10) {
            throw new IllegalArgumentException("type constants smaller than 10 are not available");
        }
        if (typeConstant > 255) {
            throw new IllegalArgumentException("type constants greater than 255 are not available");
        }
        this.typeConstant = typeConstant;
        this.type = type;
        MarshalAdapter.register(this);
    }

    public final int getTypeConstant() {
        return this.typeConstant;
    }

    public final Class getType() {
        return this.type;
    }

    public abstract void marshal(MarshalStream var1, Object var2) throws IOException;

    public abstract Object unmarshal(UnmarshalStream var1) throws ClassNotFoundException, IOException;

    public static final MarshalAdapter getAdapter(int typeConstant) {
        return tc2adapter[typeConstant];
    }

    public static final MarshalAdapter getAdapter(Class type) {
        return (MarshalAdapter)type2adapter.get(type);
    }

    private static final void register(MarshalAdapter adapter) {
        int tc = adapter.getTypeConstant();
        if (tc2adapter[tc] != null) {
            throw new IllegalArgumentException("type constant " + tc + " already registered: " + tc2adapter[tc].getType());
        }
        Class type = adapter.getType();
        if (type2adapter.get(type) != null) {
            throw new IllegalArgumentException("type " + type + " already registered");
        }
        MarshalAdapter.tc2adapter[tc] = adapter;
        type2adapter.put(type, adapter);
    }

    static {
        new MarshalAdapter(10, String.class){

            public void marshal(MarshalStream s, Object obj) throws IOException {
                s.writeChars((String)obj);
            }

            public Object unmarshal(UnmarshalStream s) throws IOException {
                String obj = s.readChars();
                s.wireObjectTable.add(obj);
                return obj;
            }
        };
        new MarshalAdapter(11, Boolean.class){

            public void marshal(MarshalStream s, Object obj) throws IOException {
                s.reserve(1);
                s.bufcnt = BasicIO.insert(s.buf, s.bufcnt, (Boolean)obj);
            }

            public Object unmarshal(UnmarshalStream s) throws IOException {
                s.request(1);
                boolean value = BasicIO.extractBoolean(s.buf, s.bufcnt);
                s.accept(1);
                Boolean obj = new Boolean(value);
                s.wireObjectTable.add(obj);
                return obj;
            }
        };
        new MarshalAdapter(12, Byte.class){

            public void marshal(MarshalStream s, Object obj) throws IOException {
                s.reserve(1);
                s.bufcnt = BasicIO.insert(s.buf, s.bufcnt, (Byte)obj);
            }

            public Object unmarshal(UnmarshalStream s) throws IOException {
                s.request(1);
                byte value = BasicIO.extractByte(s.buf, s.bufcnt);
                s.accept(1);
                Byte obj = new Byte(value);
                s.wireObjectTable.add(obj);
                return obj;
            }
        };
        new MarshalAdapter(13, Character.class){

            public void marshal(MarshalStream s, Object obj) throws IOException {
                s.reserve(2);
                s.bufcnt = BasicIO.insert(s.buf, s.bufcnt, ((Character)obj).charValue());
            }

            public Object unmarshal(UnmarshalStream s) throws IOException {
                s.request(2);
                char value = BasicIO.extractChar(s.buf, s.bufcnt);
                s.accept(2);
                Character obj = new Character(value);
                s.wireObjectTable.add(obj);
                return obj;
            }
        };
        new MarshalAdapter(14, Short.class){

            public void marshal(MarshalStream s, Object obj) throws IOException {
                s.reserve(2);
                s.bufcnt = BasicIO.insert(s.buf, s.bufcnt, (Short)obj);
            }

            public Object unmarshal(UnmarshalStream s) throws IOException {
                s.request(2);
                short value = BasicIO.extractShort(s.buf, s.bufcnt);
                s.accept(2);
                Short obj = new Short(value);
                s.wireObjectTable.add(obj);
                return obj;
            }
        };
        new MarshalAdapter(15, Integer.class){

            public void marshal(MarshalStream s, Object obj) throws IOException {
                s.reserve(4);
                s.bufcnt = BasicIO.insert(s.buf, s.bufcnt, (Integer)obj);
            }

            public Object unmarshal(UnmarshalStream s) throws IOException {
                s.request(4);
                int value = BasicIO.extractInt(s.buf, s.bufcnt);
                s.accept(4);
                Integer obj = new Integer(value);
                s.wireObjectTable.add(obj);
                return obj;
            }
        };
        new MarshalAdapter(16, Float.class){

            public void marshal(MarshalStream s, Object obj) throws IOException {
                s.reserve(4);
                s.bufcnt = BasicIO.insert(s.buf, s.bufcnt, ((Float)obj).floatValue());
            }

            public Object unmarshal(UnmarshalStream s) throws IOException {
                s.request(4);
                float value = BasicIO.extractFloat(s.buf, s.bufcnt);
                s.accept(4);
                Float obj = new Float(value);
                s.wireObjectTable.add(obj);
                return obj;
            }
        };
        new MarshalAdapter(17, Long.class){

            public void marshal(MarshalStream s, Object obj) throws IOException {
                s.reserve(8);
                s.bufcnt = BasicIO.insert(s.buf, s.bufcnt, (Long)obj);
            }

            public Object unmarshal(UnmarshalStream s) throws IOException {
                s.request(8);
                long value = BasicIO.extractLong(s.buf, s.bufcnt);
                s.accept(8);
                Long obj = new Long(value);
                s.wireObjectTable.add(obj);
                return obj;
            }
        };
        new MarshalAdapter(18, Double.class){

            public void marshal(MarshalStream s, Object obj) throws IOException {
                s.reserve(8);
                s.bufcnt = BasicIO.insert(s.buf, s.bufcnt, (Double)obj);
            }

            public Object unmarshal(UnmarshalStream s) throws IOException {
                s.request(8);
                double value = BasicIO.extractDouble(s.buf, s.bufcnt);
                s.accept(8);
                Double obj = new Double(value);
                s.wireObjectTable.add(obj);
                return obj;
            }
        };
    }
}

