/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import uka.lang.Immutable;
import uka.transport.Index;
import uka.transport.MemoryBuffer;
import uka.transport.Transportable;
import uka.transport.WireHashtable;
import uka.util.EnlargingArray;

public class DeepClone
implements Serializable {
    final WireHashtable idTable;
    final EnlargingArray copyList;
    transient boolean streamUsed = false;
    transient MemoryBuffer buffer;
    transient CopyMarshalStream out;
    transient CopyUnmarshalStream in;
    int firstDefaultWireOffset;
    boolean postProcess;

    public DeepClone() {
        this(new WireHashtable(), new EnlargingArray());
    }

    public DeepClone(WireHashtable idTable, EnlargingArray copyList) {
        this.idTable = idTable;
        this.copyList = copyList;
    }

    public void reset() {
        if (this.streamUsed) {
            try {
                this.out.reset();
                this.out.writeObject(null);
                this.in.readObject();
            }
            catch (IOException ex) {
                throw new RuntimeException("assert: object clone: " + ex);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("assert: object clone: " + ex);
            }
            this.buffer.releaseMemory();
            this.streamUsed = false;
        }
        this.idTable.reset();
        this.copyList.clear();
    }

    public final int add(Object orig, Object copy) {
        int id = this.idTable.assignWireOffset(orig);
        this.copyList.set(id, copy);
        return id;
    }

    public final byte[] doDeepClone(byte[] orig) throws CloneNotSupportedException {
        if (orig == null) {
            return null;
        }
        int id = this.idTable.findWireOffset(orig);
        if (id >= 0) {
            return (byte[])this.copyList.get(id);
        }
        byte[] copy = (byte[])orig.clone();
        this.add(orig, copy);
        return copy;
    }

    public final short[] doDeepClone(short[] orig) throws CloneNotSupportedException {
        if (orig == null) {
            return null;
        }
        int id = this.idTable.findWireOffset(orig);
        if (id >= 0) {
            return (short[])this.copyList.get(id);
        }
        short[] copy = (short[])orig.clone();
        this.add(orig, copy);
        return copy;
    }

    public final char[] doDeepClone(char[] orig) throws CloneNotSupportedException {
        if (orig == null) {
            return null;
        }
        int id = this.idTable.findWireOffset(orig);
        if (id >= 0) {
            return (char[])this.copyList.get(id);
        }
        char[] copy = (char[])orig.clone();
        this.add(orig, copy);
        return copy;
    }

    public final int[] doDeepClone(int[] orig) throws CloneNotSupportedException {
        if (orig == null) {
            return null;
        }
        int id = this.idTable.findWireOffset(orig);
        if (id >= 0) {
            return (int[])this.copyList.get(id);
        }
        int[] copy = (int[])orig.clone();
        this.add(orig, copy);
        return copy;
    }

    public final long[] doDeepClone(long[] orig) throws CloneNotSupportedException {
        if (orig == null) {
            return null;
        }
        int id = this.idTable.findWireOffset(orig);
        if (id >= 0) {
            return (long[])this.copyList.get(id);
        }
        long[] copy = (long[])orig.clone();
        this.add(orig, copy);
        return copy;
    }

    public final float[] doDeepClone(float[] orig) throws CloneNotSupportedException {
        if (orig == null) {
            return null;
        }
        int id = this.idTable.findWireOffset(orig);
        if (id >= 0) {
            return (float[])this.copyList.get(id);
        }
        float[] copy = (float[])orig.clone();
        this.add(orig, copy);
        return copy;
    }

    public final double[] doDeepClone(double[] orig) throws CloneNotSupportedException {
        if (orig == null) {
            return null;
        }
        int id = this.idTable.findWireOffset(orig);
        if (id >= 0) {
            return (double[])this.copyList.get(id);
        }
        double[] copy = (double[])orig.clone();
        this.add(orig, copy);
        return copy;
    }

    public final boolean[] doDeepClone(boolean[] orig) throws CloneNotSupportedException {
        if (orig == null) {
            return null;
        }
        int id = this.idTable.findWireOffset(orig);
        if (id >= 0) {
            return (boolean[])this.copyList.get(id);
        }
        boolean[] copy = (boolean[])orig.clone();
        this.add(orig, copy);
        return copy;
    }

    public final Object[] doDeepClone(Object[] orig) throws CloneNotSupportedException {
        if (orig == null) {
            return null;
        }
        int id = this.idTable.findWireOffset(orig);
        if (id >= 0) {
            return (Object[])this.copyList.get(id);
        }
        Class<?> component = orig.getClass().getComponentType();
        return this.doDeepClone(orig, component);
    }

    public final Object[] doDeepClone(Object[] orig, Class component) throws CloneNotSupportedException {
        int length = orig.length;
        Object[] copy = (Object[])Array.newInstance(component, length);
        this.add(orig, copy);
        for (int n = 0; n < length; ++n) {
            copy[n] = this.doDeepClone(orig[n]);
        }
        return copy;
    }

    public final Object doDeepClone(Object orig) throws CloneNotSupportedException {
        if (orig == null) {
            return null;
        }
        int id = this.idTable.findWireOffset(orig);
        if (id >= 0) {
            return this.copyList.get(id);
        }
        if (this.preserveReference(orig)) {
            return orig;
        }
        if (orig instanceof Transportable) {
            return ((Transportable)orig).deepClone(this);
        }
        if (orig.getClass().isArray()) {
            Class<?> component = orig.getClass().getComponentType();
            if (component.isPrimitive()) {
                if (component == Byte.TYPE) {
                    return this.doDeepClone((byte[])orig);
                }
                if (component == Integer.TYPE) {
                    return this.doDeepClone((int[])orig);
                }
                if (component == Character.TYPE) {
                    return this.doDeepClone((char[])orig);
                }
                if (component == Long.TYPE) {
                    return this.doDeepClone((long[])orig);
                }
                if (component == Float.TYPE) {
                    return this.doDeepClone((float[])orig);
                }
                if (component == Double.TYPE) {
                    return this.doDeepClone((double[])orig);
                }
                if (component == Short.TYPE) {
                    return this.doDeepClone((short[])orig);
                }
                if (component == Boolean.TYPE) {
                    return this.doDeepClone((boolean[])orig);
                }
                throw new RuntimeException("assert: unknown type: " + component.getName());
            }
            return this.doDeepClone((Object[])orig, component);
        }
        return this.cloneByMarshal(orig);
    }

    private Object cloneByMarshal(Object orig) throws CloneNotSupportedException {
        Object copy;
        try {
            if (this.out == null) {
                try {
                    this.buffer = new MemoryBuffer();
                    this.out = new CopyMarshalStream(this.buffer.getOutputStream());
                    this.in = new CopyUnmarshalStream(this.buffer.getInputStream());
                }
                catch (IOException ex) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"creation of copy streams failed"))).initCause(ex));
                }
            }
            this.postProcess = false;
            this.firstDefaultWireOffset = this.idTable.getNextWireOffset();
            this.out.writeObject(orig);
            this.out.flush();
            try {
                int id;
                copy = this.in.readObject();
                this.postProcess = true;
                int last = this.idTable.getNextWireOffset();
                for (id = this.firstDefaultWireOffset; id < last; ++id) {
                    this.out.writeObject(this.copyList.get(id));
                }
                this.out.flush();
                for (id = this.firstDefaultWireOffset; id < last; ++id) {
                    Object subcopy = this.in.readObject();
                    this.copyList.set(id, subcopy);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("assert: object clone: " + ex);
            }
        }
        catch (IOException ex) {
            throw new CloneNotSupportedException(ex.toString());
        }
        this.buffer.reset();
        this.streamUsed = true;
        return copy;
    }

    protected boolean preserveReference(Object orig) {
        return orig instanceof String || orig instanceof Immutable || orig instanceof Byte || orig instanceof Short || orig instanceof Character || orig instanceof Integer || orig instanceof Long || orig instanceof Float || orig instanceof Double;
    }

    protected Object replaceObject(Object obj) throws IOException {
        return obj;
    }

    final class CopyUnmarshalStream
    extends ObjectInputStream {
        public CopyUnmarshalStream(InputStream inputstream) throws IOException {
            super(inputstream);
            this.enableResolveObject(true);
        }

        protected void readStreamHeader() throws IOException {
        }

        protected Object resolveObject(Object copy) throws IOException {
            if (copy instanceof Index) {
                int id = ((Index)copy).get();
                return DeepClone.this.copyList.get(id);
            }
            return copy;
        }
    }

    final class CopyMarshalStream
    extends ObjectOutputStream {
        public CopyMarshalStream(OutputStream outputstream) throws IOException {
            super(outputstream);
            this.enableReplaceObject(true);
        }

        protected void writeStreamHeader() throws IOException {
        }

        protected Object replaceObject(Object orig) throws IOException {
            if (DeepClone.this.postProcess) {
                return orig;
            }
            int id = DeepClone.this.idTable.findWireOffset(orig = DeepClone.this.replaceObject(orig));
            if (id >= 0) {
                return new Index(id);
            }
            if (DeepClone.this.preserveReference(orig)) {
                id = DeepClone.this.add(orig, orig);
                return new Index(id);
            }
            id = DeepClone.this.idTable.assignWireOffset(orig);
            DeepClone.this.copyList.set(id, orig);
            return orig;
        }
    }
}

