/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import java.io.IOException;
import java.io.OutputStream;
import uka.transport.BasicIO;
import uka.transport.TransportConstants;

public class BinaryWriter
implements TransportConstants {
    protected OutputStream out;
    protected int bufcnt = 0;
    protected byte[] buf;

    public BinaryWriter(OutputStream out) {
        this.out = out;
        this.buf = new byte[2048];
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len <= 2048) {
            if (this.bufcnt + len > 2048) {
                this.drain();
            }
            System.arraycopy(b, off, this.buf, this.bufcnt, len);
            this.bufcnt += len;
        } else {
            this.writeHugeByteArray(b, off, len);
        }
    }

    protected void writeHugeByteArray(byte[] array, int offset, int length) throws IOException {
        this.drain();
        this.out.write(array, offset, length);
    }

    protected void writeHugeIntArray(int[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int direct = stop - offset;
            if (direct > 512) {
                direct = 512;
            }
            if (this.bufcnt + direct > 2048) {
                this.drain();
            }
            this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    protected void writeHugeCharArray(char[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int direct = stop - offset;
            if (direct > 1024) {
                direct = 1024;
            }
            if (this.bufcnt + direct > 2048) {
                this.drain();
            }
            this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    protected void writeHugeFloatArray(float[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int direct = stop - offset;
            if (direct > 512) {
                direct = 512;
            }
            if (this.bufcnt + direct > 2048) {
                this.drain();
            }
            this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    protected void writeHugeLongArray(long[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int direct = stop - offset;
            if (direct > 256) {
                direct = 256;
            }
            if (this.bufcnt + direct > 2048) {
                this.drain();
            }
            this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    protected void writeHugeDoubleArray(double[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int direct = stop - offset;
            if (direct > 256) {
                direct = 256;
            }
            if (this.bufcnt + direct > 2048) {
                this.drain();
            }
            this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    protected void writeHugeShortArray(short[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int direct = stop - offset;
            if (direct > 1024) {
                direct = 1024;
            }
            if (this.bufcnt + direct > 2048) {
                this.drain();
            }
            this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    protected void writeHugeBooleanArray(boolean[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int direct = stop - offset;
            if (direct > 2048) {
                direct = 2048;
            }
            if (this.bufcnt + direct > 2048) {
                this.drain();
            }
            this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    public void write(int data) throws IOException {
        if (this.bufcnt >= 2048) {
            this.drain();
        }
        this.buf[this.bufcnt++] = (byte)data;
    }

    public final void writeBoolean(boolean data) throws IOException {
        if (this.bufcnt + 1 > 2048) {
            this.drain();
        }
        this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, data);
    }

    public final void writeByte(int data) throws IOException {
        if (this.bufcnt + 1 > 2048) {
            this.drain();
        }
        this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, (byte)data);
    }

    public final void writeShort(int data) throws IOException {
        if (this.bufcnt + 2 > 2048) {
            this.drain();
        }
        this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, (short)data);
    }

    public final void writeChar(int data) throws IOException {
        if (this.bufcnt + 2 > 2048) {
            this.drain();
        }
        this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, (char)data);
    }

    public final void writeInt(int data) throws IOException {
        if (this.bufcnt + 4 > 2048) {
            this.drain();
        }
        this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, data);
    }

    public final void writeLong(long data) throws IOException {
        if (this.bufcnt + 8 > 2048) {
            this.drain();
        }
        this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, data);
    }

    public final void writeFloat(float data) throws IOException {
        if (this.bufcnt + 4 > 2048) {
            this.drain();
        }
        this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, data);
    }

    public final void writeDouble(double data) throws IOException {
        if (this.bufcnt + 8 > 2048) {
            this.drain();
        }
        this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, data);
    }

    public final void writeUnsignedByte(int data) throws IOException {
        if (this.bufcnt + 1 > 2048) {
            this.drain();
        }
        this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, (byte)data);
    }

    public final void writeUnsignedShort(int data) throws IOException {
        if (this.bufcnt + 2 > 2048) {
            this.drain();
        }
        this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, (short)data);
    }

    public void writeChars(String data) throws IOException {
        int bufcnt;
        byte[] buf;
        int len = data.length();
        int pos = 0;
        if (this.bufcnt + 4 > 2048) {
            this.drain();
        }
        this.bufcnt = BasicIO.insert(this.buf, this.bufcnt, len);
        while (pos + 1024 <= len) {
            if (this.bufcnt + 2048 > 2048) {
                this.drain();
            }
            buf = this.buf;
            bufcnt = this.bufcnt;
            int end = pos + 1024;
            while (pos < end) {
                bufcnt = BasicIO.insert(buf, bufcnt, data.charAt(pos));
                ++pos;
            }
            this.bufcnt = bufcnt;
        }
        if (pos < len) {
            if (this.bufcnt + (len - pos) * 2 > 2048) {
                this.drain();
            }
            buf = this.buf;
            bufcnt = this.bufcnt;
            while (pos < len) {
                bufcnt = BasicIO.insert(buf, bufcnt, data.charAt(pos));
                ++pos;
            }
            this.bufcnt = bufcnt;
        }
    }

    public final byte[] getBuffer() {
        return this.buf;
    }

    public final int getPosition() {
        return this.bufcnt;
    }

    public final void reserve(int length) throws IOException {
        if (this.bufcnt + length > 2048) {
            this.drain();
        }
    }

    public final void deliver(int length) {
        this.bufcnt += length;
    }

    protected final void drain() throws IOException {
        if (this.bufcnt == 0) {
            return;
        }
        this.out.write(this.buf, 0, this.bufcnt);
        this.bufcnt = 0;
    }

    public void flush() throws IOException {
        if (this.bufcnt > 0) {
            this.out.write(this.buf, 0, this.bufcnt);
            this.bufcnt = 0;
        }
        this.out.flush();
    }
}

