/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import uka.transport.BasicIO;
import uka.transport.TransportConstants;

public class BinaryInputStream
extends InputStream
implements TransportConstants {
    protected InputStream in;
    protected int buflen = 0;
    protected int bufcnt = 0;
    protected byte[] buf;
    StringBuffer cbuffer = new StringBuffer();

    public BinaryInputStream(InputStream in) {
        this.in = in;
        this.buf = new byte[4096];
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read() throws IOException {
        if (this.requestTest(1) < 1) {
            return -1;
        }
        int data = BasicIO.extractUnsignedByte(this.buf, this.bufcnt);
        ++this.bufcnt;
        return data;
    }

    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int _offset, int length) throws IOException {
        if (length <= 0) {
            if (length == 0) {
                return 0;
            }
            throw new IndexOutOfBoundsException();
        }
        int avail = this.buflen - this.bufcnt;
        if (length <= avail) {
            System.arraycopy(this.buf, this.bufcnt, data, _offset, length);
            this.bufcnt += length;
            return length;
        }
        if (avail == 0 && length < 2048) {
            this.bufcnt = 0;
            this.buflen = 0;
            while (avail < length) {
                int DIRECT = 2048 - this.buflen;
                int cnt = this.in.read(this.buf, this.buflen, DIRECT);
                if (cnt < 0) {
                    if (avail > 0) {
                        System.arraycopy(this.buf, this.bufcnt, data, _offset, avail);
                        this.bufcnt += avail;
                        return avail;
                    }
                    return cnt;
                }
                this.buflen += cnt;
                avail += cnt;
            }
            System.arraycopy(this.buf, this.bufcnt, data, _offset, length);
            this.bufcnt += length;
            return length;
        }
        if (avail > 0) {
            System.arraycopy(this.buf, this.bufcnt, data, _offset, avail);
            this.bufcnt += avail;
            int direct = this.in.read(data, _offset + avail, length - avail);
            if (direct > 0) {
                return avail + direct;
            }
            return avail;
        }
        int direct = this.in.read(data, _offset, length);
        return direct;
    }

    public long skip(long n) throws IOException {
        int avail = this.buflen - this.bufcnt;
        if (n <= (long)avail) {
            this.bufcnt = (int)((long)this.bufcnt + n);
            return n;
        }
        this.bufcnt += avail;
        long direct = this.in.skip(n - (long)avail);
        return (long)avail + direct;
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    public void readFully(byte[] data) throws IOException {
        this.readFully(data, 0, data.length);
    }

    public final void readFully(byte[] data, int offset, int length) throws IOException {
        while (length > 0) {
            int cnt = this.read(data, offset, length);
            if (cnt < 0) {
                throw new EOFException("unexpected EOF");
            }
            offset += cnt;
            length -= cnt;
        }
    }

    public String readChars() throws IOException {
        if (this.requestTest(4) < 4) {
            throw new EOFException("request(4) failed");
        }
        int len = BasicIO.extractInt(this.buf, this.bufcnt);
        this.bufcnt += 4;
        this.cbuffer.setLength(0);
        this.cbuffer.ensureCapacity(len);
        int pos = 0;
        while (pos + 1024 <= len) {
            if (this.requestTest(2048) < 2048) {
                throw new EOFException("request(2048) failed");
            }
            byte[] buf = this.buf;
            int bufcnt = this.bufcnt;
            int end = pos + 1024;
            while (pos < end) {
                this.cbuffer.append(BasicIO.extractChar(buf, bufcnt));
                bufcnt += 2;
                ++pos;
            }
            this.bufcnt += 2048;
        }
        if (pos < len) {
            int direct = (len - pos) * 2;
            if (this.requestTest(direct) < direct) {
                throw new EOFException("request(" + direct + ") failed");
            }
            byte[] buf = this.buf;
            int bufcnt = this.bufcnt;
            while (pos < len) {
                this.cbuffer.append(BasicIO.extractChar(buf, bufcnt));
                bufcnt += 2;
                ++pos;
            }
            this.bufcnt += direct;
        }
        return this.cbuffer.toString();
    }

    protected void readHugeByteArray(byte[] array, int offset, int length) throws IOException {
        int direct = length - offset;
        int avail = this.buflen - this.bufcnt;
        if (direct > avail) {
            direct = avail;
        }
        System.arraycopy(this.buf, this.bufcnt, array, offset, direct);
        this.bufcnt += direct;
        offset += direct;
        while (offset < length) {
            direct = this.in.read(array, offset, length - offset);
            if (direct < 0) {
                throw new EOFException();
            }
            offset += direct;
        }
    }

    protected void readHugeIntArray(int[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int directBytes;
            int direct = stop - offset;
            if (direct > 512) {
                direct = 512;
            }
            if (this.requestTest(directBytes = direct * 4) < directBytes) {
                throw new EOFException("request(" + directBytes + ") failed");
            }
            this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    protected void readHugeCharArray(char[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int directBytes;
            int direct = stop - offset;
            if (direct > 1024) {
                direct = 1024;
            }
            if (this.requestTest(directBytes = direct * 2) < directBytes) {
                throw new EOFException("request(" + directBytes + ") failed");
            }
            this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    protected void readHugeFloatArray(float[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int directBytes;
            int direct = stop - offset;
            if (direct > 512) {
                direct = 512;
            }
            if (this.requestTest(directBytes = direct * 4) < directBytes) {
                throw new EOFException("request(" + directBytes + ") failed");
            }
            this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    protected void readHugeLongArray(long[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int directBytes;
            int direct = stop - offset;
            if (direct > 256) {
                direct = 256;
            }
            if (this.requestTest(directBytes = direct * 8) < directBytes) {
                throw new EOFException("request(" + directBytes + ") failed");
            }
            this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    protected void readHugeDoubleArray(double[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int directBytes;
            int direct = stop - offset;
            if (direct > 256) {
                direct = 256;
            }
            if (this.requestTest(directBytes = direct * 8) < directBytes) {
                throw new EOFException("request(" + directBytes + ") failed");
            }
            this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    protected void readHugeShortArray(short[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int directBytes;
            int direct = stop - offset;
            if (direct > 1024) {
                direct = 1024;
            }
            if (this.requestTest(directBytes = direct * 2) < directBytes) {
                throw new EOFException("request(" + directBytes + ") failed");
            }
            this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    protected void readHugeBooleanArray(boolean[] array, int offset, int length) throws IOException {
        int stop = offset + length;
        while (offset < stop) {
            int directBytes;
            int direct = stop - offset;
            if (direct > 2048) {
                direct = 2048;
            }
            if (this.requestTest(directBytes = direct * 1) < directBytes) {
                throw new EOFException("request(" + directBytes + ") failed");
            }
            this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, offset, direct);
            offset += direct;
        }
    }

    public final byte[] getBuffer() {
        return this.buf;
    }

    public final int getPosition() {
        return this.bufcnt;
    }

    public final void request(int length) throws IOException {
        if (this.requestTest(length) < length) {
            throw new EOFException("request(" + length + ") failed");
        }
    }

    public final void accept(int length) throws IOException {
        this.bufcnt += length;
    }

    protected final int requestTest(int length) throws IOException {
        if (length > 2048) {
            throw new StreamCorruptedException("invalid request length (" + length + " <= " + 2048 + ")");
        }
        int avail = this.buflen - this.bufcnt;
        if (avail < length) {
            int cnt;
            if (avail == 0) {
                this.bufcnt = 0;
                this.buflen = 0;
                while (avail < length) {
                    int DIRECT = 2048 - this.buflen;
                    int cnt2 = this.in.read(this.buf, this.buflen, DIRECT);
                    if (cnt2 < 0) {
                        return avail;
                    }
                    this.buflen += cnt2;
                    avail += cnt2;
                }
                return length;
            }
            int direct = length - avail;
            if (this.buflen + direct > this.buf.length) {
                throw new StreamCorruptedException("invalid request order (bufcnt=" + this.bufcnt + ", " + "buflen=" + this.buflen + ", " + "length=" + length + ")");
            }
            while (direct > 0 && (cnt = this.in.read(this.buf, this.buflen, direct)) >= 0) {
                this.buflen += cnt;
                direct -= cnt;
            }
            return this.buflen - this.bufcnt;
        }
        return length;
    }

    public final boolean readBoolean() throws IOException {
        if (this.requestTest(1) < 1) {
            throw new EOFException("request(1) failed");
        }
        boolean data = BasicIO.extractBoolean(this.buf, this.bufcnt);
        ++this.bufcnt;
        return data;
    }

    public final byte readByte() throws IOException {
        if (this.requestTest(1) < 1) {
            throw new EOFException("request(1) failed");
        }
        byte data = BasicIO.extractByte(this.buf, this.bufcnt);
        ++this.bufcnt;
        return data;
    }

    public final char readChar() throws IOException {
        if (this.requestTest(2) < 2) {
            throw new EOFException("request(2) failed");
        }
        char data = BasicIO.extractChar(this.buf, this.bufcnt);
        this.bufcnt += 2;
        return data;
    }

    public final short readShort() throws IOException {
        if (this.requestTest(2) < 2) {
            throw new EOFException("request(2) failed");
        }
        short data = BasicIO.extractShort(this.buf, this.bufcnt);
        this.bufcnt += 2;
        return data;
    }

    public final int readInt() throws IOException {
        if (this.requestTest(4) < 4) {
            throw new EOFException("request(4) failed");
        }
        int data = BasicIO.extractInt(this.buf, this.bufcnt);
        this.bufcnt += 4;
        return data;
    }

    public final long readLong() throws IOException {
        if (this.requestTest(8) < 8) {
            throw new EOFException("request(8) failed");
        }
        long data = BasicIO.extractLong(this.buf, this.bufcnt);
        this.bufcnt += 8;
        return data;
    }

    public final float readFloat() throws IOException {
        if (this.requestTest(4) < 4) {
            throw new EOFException("request(4) failed");
        }
        float data = BasicIO.extractFloat(this.buf, this.bufcnt);
        this.bufcnt += 4;
        return data;
    }

    public final double readDouble() throws IOException {
        if (this.requestTest(8) < 8) {
            throw new EOFException("request(8) failed");
        }
        double data = BasicIO.extractDouble(this.buf, this.bufcnt);
        this.bufcnt += 8;
        return data;
    }

    public final int readUnsignedShort() throws IOException {
        if (this.requestTest(2) < 2) {
            throw new EOFException("request(2) failed");
        }
        int data = BasicIO.extractUnsignedShort(this.buf, this.bufcnt);
        this.bufcnt += 2;
        return data;
    }

    public final int readUnsignedByte() throws IOException {
        if (this.requestTest(1) < 1) {
            throw new EOFException("request(1) failed");
        }
        int data = BasicIO.extractUnsignedByte(this.buf, this.bufcnt);
        ++this.bufcnt;
        return data;
    }
}

