/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import uka.transport.TransportConstants;

public class BasicIO
implements TransportConstants {
    public static final int insert(byte[] buffer, int pos, byte d) {
        buffer[pos++] = d;
        return pos;
    }

    public static final int insert(byte[] buffer, int pos, boolean d) {
        buffer[pos++] = d ? (byte)1 : 0;
        return pos;
    }

    public static final int insert(byte[] buffer, int pos, short d) {
        buffer[pos++] = (byte)(d >>> 8);
        buffer[pos++] = (byte)d;
        return pos;
    }

    public static final int insert(byte[] buffer, int pos, char d) {
        buffer[pos++] = (byte)(d >>> 8);
        buffer[pos++] = (byte)d;
        return pos;
    }

    public static final int insert(byte[] buffer, int pos, int d) {
        buffer[pos++] = (byte)(d >>> 24);
        buffer[pos++] = (byte)(d >>> 16);
        buffer[pos++] = (byte)(d >>> 8);
        buffer[pos++] = (byte)d;
        return pos;
    }

    public static final int insert(byte[] buffer, int pos, long d) {
        buffer[pos++] = (byte)(d >>> 56);
        buffer[pos++] = (byte)(d >>> 48);
        buffer[pos++] = (byte)(d >>> 40);
        buffer[pos++] = (byte)(d >>> 32);
        buffer[pos++] = (byte)(d >>> 24);
        buffer[pos++] = (byte)(d >>> 16);
        buffer[pos++] = (byte)(d >>> 8);
        buffer[pos++] = (byte)d;
        return pos;
    }

    public static final int insert(byte[] buffer, int pos, float f) {
        int d = Float.floatToIntBits(f);
        buffer[pos++] = (byte)(d >>> 24);
        buffer[pos++] = (byte)(d >>> 16);
        buffer[pos++] = (byte)(d >>> 8);
        buffer[pos++] = (byte)d;
        return pos;
    }

    public static final int insert(byte[] buffer, int pos, double f) {
        long d = Double.doubleToLongBits(f);
        buffer[pos++] = (byte)(d >>> 56);
        buffer[pos++] = (byte)(d >>> 48);
        buffer[pos++] = (byte)(d >>> 40);
        buffer[pos++] = (byte)(d >>> 32);
        buffer[pos++] = (byte)(d >>> 24);
        buffer[pos++] = (byte)(d >>> 16);
        buffer[pos++] = (byte)(d >>> 8);
        buffer[pos++] = (byte)d;
        return pos;
    }

    public static final boolean extractBoolean(byte[] buffer, int pos) {
        return buffer[pos] > 0;
    }

    public static final byte extractByte(byte[] buffer, int pos) {
        return buffer[pos];
    }

    public static final int extractUnsignedByte(byte[] buffer, int pos) {
        return buffer[pos] & 0xFF;
    }

    public static final short extractShort(byte[] buffer, int pos) {
        return (short)((buffer[pos] & 0xFF) << 8 | buffer[pos + 1] & 0xFF);
    }

    public static final int extractUnsignedShort(byte[] buffer, int pos) {
        return (buffer[pos] & 0xFF) << 8 | buffer[pos + 1] & 0xFF;
    }

    public static final char extractChar(byte[] buffer, int pos) {
        return (char)((buffer[pos] & 0xFF) << 8 | buffer[pos + 1] & 0xFF);
    }

    public static final int extractInt(byte[] buffer, int pos) {
        return (buffer[pos] & 0xFF) << 24 | (buffer[pos + 1] & 0xFF) << 16 | (buffer[pos + 2] & 0xFF) << 8 | buffer[pos + 3] & 0xFF;
    }

    public static final long extractLong(byte[] buffer, int pos) {
        return ((long)buffer[pos] & 0xFFL) << 56 | ((long)buffer[pos + 1] & 0xFFL) << 48 | ((long)buffer[pos + 2] & 0xFFL) << 40 | ((long)buffer[pos + 3] & 0xFFL) << 32 | ((long)buffer[pos + 4] & 0xFFL) << 24 | ((long)buffer[pos + 5] & 0xFFL) << 16 | ((long)buffer[pos + 6] & 0xFFL) << 8 | (long)buffer[pos + 7] & 0xFFL;
    }

    public static final float extractFloat(byte[] buffer, int pos) {
        int d = (buffer[pos] & 0xFF) << 24 | (buffer[pos + 1] & 0xFF) << 16 | (buffer[pos + 2] & 0xFF) << 8 | buffer[pos + 3] & 0xFF;
        return Float.intBitsToFloat(d);
    }

    public static final double extractDouble(byte[] buffer, int pos) {
        long d = ((long)buffer[pos] & 0xFFL) << 56 | ((long)buffer[pos + 1] & 0xFFL) << 48 | ((long)buffer[pos + 2] & 0xFFL) << 40 | ((long)buffer[pos + 3] & 0xFFL) << 32 | ((long)buffer[pos + 4] & 0xFFL) << 24 | ((long)buffer[pos + 5] & 0xFFL) << 16 | ((long)buffer[pos + 6] & 0xFFL) << 8 | (long)buffer[pos + 7] & 0xFFL;
        return Double.longBitsToDouble(d);
    }

    public static final int sizeof(boolean n) {
        return 1;
    }

    public static final int sizeof(boolean[] n) {
        return 1 * n.length;
    }

    public static final int insert(byte[] buffer, int pos, boolean[] fs) {
        return BasicIO.insert(buffer, pos, fs, 0, fs.length);
    }

    public static final int insert(byte[] buffer, int pos, boolean[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            pos = BasicIO.insert(buffer, pos, fs[foff]);
            ++foff;
        }
        return pos;
    }

    public static final int extract(byte[] buffer, int pos, boolean[] fs) {
        return BasicIO.extract(buffer, pos, fs, 0, fs.length);
    }

    public static final int extract(byte[] buffer, int pos, boolean[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            fs[foff] = BasicIO.extractBoolean(buffer, pos);
            ++pos;
            ++foff;
        }
        return pos;
    }

    public static final int sizeof(byte n) {
        return 1;
    }

    public static final int sizeof(byte[] n) {
        return 1 * n.length;
    }

    public static final int insert(byte[] buffer, int pos, byte[] fs) {
        return BasicIO.insert(buffer, pos, fs, 0, fs.length);
    }

    public static final int insert(byte[] buffer, int pos, byte[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            pos = BasicIO.insert(buffer, pos, fs[foff]);
            ++foff;
        }
        return pos;
    }

    public static final int extract(byte[] buffer, int pos, byte[] fs) {
        return BasicIO.extract(buffer, pos, fs, 0, fs.length);
    }

    public static final int extract(byte[] buffer, int pos, byte[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            fs[foff] = BasicIO.extractByte(buffer, pos);
            ++pos;
            ++foff;
        }
        return pos;
    }

    public static final int sizeof(char n) {
        return 2;
    }

    public static final int sizeof(char[] n) {
        return 2 * n.length;
    }

    public static final int insert(byte[] buffer, int pos, char[] fs) {
        return BasicIO.insert(buffer, pos, fs, 0, fs.length);
    }

    public static final int insert(byte[] buffer, int pos, char[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            pos = BasicIO.insert(buffer, pos, fs[foff]);
            ++foff;
        }
        return pos;
    }

    public static final int extract(byte[] buffer, int pos, char[] fs) {
        return BasicIO.extract(buffer, pos, fs, 0, fs.length);
    }

    public static final int extract(byte[] buffer, int pos, char[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            fs[foff] = BasicIO.extractChar(buffer, pos);
            pos += 2;
            ++foff;
        }
        return pos;
    }

    public static final int sizeof(short n) {
        return 2;
    }

    public static final int sizeof(short[] n) {
        return 2 * n.length;
    }

    public static final int insert(byte[] buffer, int pos, short[] fs) {
        return BasicIO.insert(buffer, pos, fs, 0, fs.length);
    }

    public static final int insert(byte[] buffer, int pos, short[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            pos = BasicIO.insert(buffer, pos, fs[foff]);
            ++foff;
        }
        return pos;
    }

    public static final int extract(byte[] buffer, int pos, short[] fs) {
        return BasicIO.extract(buffer, pos, fs, 0, fs.length);
    }

    public static final int extract(byte[] buffer, int pos, short[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            fs[foff] = BasicIO.extractShort(buffer, pos);
            pos += 2;
            ++foff;
        }
        return pos;
    }

    public static final int sizeof(int n) {
        return 4;
    }

    public static final int sizeof(int[] n) {
        return 4 * n.length;
    }

    public static final int insert(byte[] buffer, int pos, int[] fs) {
        return BasicIO.insert(buffer, pos, fs, 0, fs.length);
    }

    public static final int insert(byte[] buffer, int pos, int[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            pos = BasicIO.insert(buffer, pos, fs[foff]);
            ++foff;
        }
        return pos;
    }

    public static final int extract(byte[] buffer, int pos, int[] fs) {
        return BasicIO.extract(buffer, pos, fs, 0, fs.length);
    }

    public static final int extract(byte[] buffer, int pos, int[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            fs[foff] = BasicIO.extractInt(buffer, pos);
            pos += 4;
            ++foff;
        }
        return pos;
    }

    public static final int sizeof(long n) {
        return 8;
    }

    public static final int sizeof(long[] n) {
        return 8 * n.length;
    }

    public static final int insert(byte[] buffer, int pos, long[] fs) {
        return BasicIO.insert(buffer, pos, fs, 0, fs.length);
    }

    public static final int insert(byte[] buffer, int pos, long[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            pos = BasicIO.insert(buffer, pos, fs[foff]);
            ++foff;
        }
        return pos;
    }

    public static final int extract(byte[] buffer, int pos, long[] fs) {
        return BasicIO.extract(buffer, pos, fs, 0, fs.length);
    }

    public static final int extract(byte[] buffer, int pos, long[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            fs[foff] = BasicIO.extractLong(buffer, pos);
            pos += 8;
            ++foff;
        }
        return pos;
    }

    public static final int sizeof(float n) {
        return 4;
    }

    public static final int sizeof(float[] n) {
        return 4 * n.length;
    }

    public static final int insert(byte[] buffer, int pos, float[] fs) {
        return BasicIO.insert(buffer, pos, fs, 0, fs.length);
    }

    public static final int insert(byte[] buffer, int pos, float[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            pos = BasicIO.insert(buffer, pos, fs[foff]);
            ++foff;
        }
        return pos;
    }

    public static final int extract(byte[] buffer, int pos, float[] fs) {
        return BasicIO.extract(buffer, pos, fs, 0, fs.length);
    }

    public static final int extract(byte[] buffer, int pos, float[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            fs[foff] = BasicIO.extractFloat(buffer, pos);
            pos += 4;
            ++foff;
        }
        return pos;
    }

    public static final int sizeof(double n) {
        return 8;
    }

    public static final int sizeof(double[] n) {
        return 8 * n.length;
    }

    public static final int insert(byte[] buffer, int pos, double[] fs) {
        return BasicIO.insert(buffer, pos, fs, 0, fs.length);
    }

    public static final int insert(byte[] buffer, int pos, double[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            pos = BasicIO.insert(buffer, pos, fs[foff]);
            ++foff;
        }
        return pos;
    }

    public static final int extract(byte[] buffer, int pos, double[] fs) {
        return BasicIO.extract(buffer, pos, fs, 0, fs.length);
    }

    public static final int extract(byte[] buffer, int pos, double[] fs, int foff, int fcnt) {
        int fend = foff + fcnt;
        while (foff < fend) {
            fs[foff] = BasicIO.extractDouble(buffer, pos);
            pos += 8;
            ++foff;
        }
        return pos;
    }
}

