/*
 * Decompiled with CFR 0.152.
 */
package uka.debug;

import java.lang.reflect.Field;
import java.rmi.server.UID;
import java.util.Hashtable;
import java.util.StringTokenizer;
import uka.debug.PrintSynchronizer;

public class Debug {
    public static final long ANY = -1L;
    public static final long NONE = 0L;
    public static final long UKA_PS = 255L;
    public static final long UKA_TRANSPORT = 65280L;
    public static final long UKA_TRANSPORT_IN = 256L;
    public static final long UKA_TRANSPORT_IN_STREAM = 512L;
    public static final long UKA_TRANSPORT_OUT = 1024L;
    public static final long UKA_TRANSPORT_OUT_STREAM = 2048L;
    public static final long UKA_TRANSPORT_CONTEXT = 4096L;
    public static final long UKA_TRANSPORT_MEM = 8192L;
    public static final long UKA_KARMI = 0xFFFF0000L;
    public static final long UKA_KARMI_SERVER = 65536L;
    public static final long UKA_KARMI_SOCKET = 131072L;
    public static final long UKA_KARMI_STREAM = 262144L;
    public static final long UKA_KARMI_PS = 524288L;
    public static final long UKA_KARMI_DGC = 0x100000L;
    public static final long UKA_KARMI_LOCAL = 0x200000L;
    public static final long UKA_KARMI_NAMING = 0x400000L;
    public static final long UKA_KARMI_REF = 0x800000L;
    public static final long UKA_KARMI_TRANSPORT = 0x1000000L;
    public static final long UKA_KARMI_STUB = 0x2000000L;
    public static final long UKA_KARMI_SKEL = 0x4000000L;
    public static final long UKA_KARMI_STUB_EXCEPTION = 0x8000000L;
    public static final long UKA_KARMI_LOGIC_THREADS = 0x10000000L;
    public static final long UKA_KARMI_PHYS_THREADS = 0x20000000L;
    public static final long UKA_KARMI_THREADS = 0x40000000L;
    public static final long UKA_KARMI_CALL = 0x80000000L;
    public static final long JP = 0xFF00000000L;
    static long mask;
    static Hashtable names;
    static Hashtable flags;
    static String nodeid;
    public static final UID uid;
    private static PrintSynchronizer out;

    public static void setNodeID(String nodeid) {
        Debug.nodeid = nodeid;
    }

    public static boolean enabled(long mask) {
        return mask == -1L || (mask & Debug.mask) != 0L;
    }

    public static void log(long mask, String msg, Throwable ex) {
        if (Debug.enabled(mask)) {
            String name = (String)names.get(new Long(mask));
            out.println((nodeid != null ? nodeid + ": " : "") + uid + ": " + Thread.currentThread().getName() + ": " + name + ": " + msg + ".");
            if (ex != null) {
                ex.printStackTrace();
            }
        }
    }

    public static void log(long mask, String msg) {
        Debug.log(mask, msg, null);
    }

    public static final void fatal(String msg) {
        out.println("FATAL: " + msg + ".");
        System.exit(1);
    }

    public static String getObjectID(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + "#" + System.identityHashCode(obj);
    }

    static {
        names = new Hashtable();
        flags = new Hashtable();
        nodeid = "";
        uid = new UID();
        out = new PrintSynchronizer();
        out.setDaemon(true);
        out.start();
        Class c = Debug.class;
        int flagMod = 25;
        Field[] fields = c.getDeclaredFields();
        for (int n = 0; n < fields.length; ++n) {
            if (fields[n].getModifiers() != flagMod || fields[n].getType() != Long.TYPE) continue;
            String name = fields[n].getName();
            try {
                Long flag = new Long(fields[n].getLong(null));
                names.put(flag, name);
                flags.put(name, flag);
                continue;
            }
            catch (IllegalAccessException ex) {
                Debug.fatal("Illegal debugging flag '" + name + "'");
            }
        }
        String mskDescription = System.getProperty("uka.debug");
        if (mskDescription != null) {
            boolean negate = false;
            mask = 0L;
            if (mskDescription.startsWith("!")) {
                mskDescription = mskDescription.substring(1);
                negate = true;
            }
            StringTokenizer t = new StringTokenizer(mskDescription, ",", false);
            while (t.hasMoreTokens()) {
                String rawFlag = t.nextToken();
                String name = rawFlag.toUpperCase().replace('.', '_');
                Long flag = (Long)flags.get(name);
                if (flag == null) {
                    Debug.fatal("Unknown debugging flag '" + rawFlag + "'");
                }
                mask |= flag.longValue();
            }
            if (negate) {
                mask = 0xFFFFFFFFFFFFFFFFL ^ mask;
            }
        } else {
            mask = -1L;
        }
    }
}

