/*
 * Decompiled with CFR 0.152.
 */
package uka.bench.transport;

import java.io.IOException;
import uka.transport.BasicIO;
import uka.transport.DeepClone;
import uka.transport.MarshalStream;
import uka.transport.Transportable;
import uka.transport.UnmarshalStream;
import uka.transport.ValueIO;

public class DoubleMatrix
implements Transportable {
    private double[][] data;
    private int id;
    protected static final int _SIZE = 4;

    public DoubleMatrix() {
    }

    public DoubleMatrix(int id, double[][] data) {
        this.id = id;
        this.data = data;
    }

    public DoubleMatrix(int id, int dimx, int dimy) {
        this.id = id;
        this.data = new double[dimx][dimy];
    }

    public DoubleMatrix(UnmarshalStream _stream) throws IOException, ClassNotFoundException {
        this(_stream, 4);
        _stream.accept(4);
    }

    protected DoubleMatrix(UnmarshalStream _stream, int _size) throws IOException, ClassNotFoundException {
        _stream.request(_size);
        byte[] _buffer = _stream.getBuffer();
        int _pos = _stream.getPosition();
        this.id = BasicIO.extractInt(_buffer, _pos);
        _pos += 4;
    }

    public void unmarshalReferences(UnmarshalStream _stream) throws IOException, ClassNotFoundException {
        this.data = ValueIO.readValueArrayArrayDouble(_stream);
    }

    public void marshal(MarshalStream _stream) throws IOException {
        _stream.reserve(4);
        byte[] _buffer = _stream.getBuffer();
        int _pos = _stream.getPosition();
        this.marshalPrimitives(_buffer, _pos);
        _stream.deliver(4);
        this.marshalReferences(_stream);
    }

    protected void marshalPrimitives(byte[] _buffer, int _pos) throws IOException {
        _pos = BasicIO.insert(_buffer, _pos, this.id);
    }

    protected void marshalReferences(MarshalStream _stream) throws IOException {
        ValueIO.writeValue(_stream, this.data);
    }

    public final Object deepClone(DeepClone _helper) throws CloneNotSupportedException {
        Object _copy = this.clone();
        _helper.add(this, _copy);
        ((DoubleMatrix)_copy).deepCloneReferences(_helper);
        return _copy;
    }

    protected void deepCloneReferences(DeepClone _helper) throws CloneNotSupportedException {
        this.data = (double[][])_helper.doDeepClone((Object[])this.data);
    }
}

