/*
 * Decompiled with CFR 0.152.
 */
package uka.bench;

import java.text.DecimalFormat;
import java.util.Arrays;

public class Timer {
    final int iterationCnt;
    double benchmarkSize = 0.0;
    static DecimalFormat format = new DecimalFormat("0.000");
    int iteration;
    final long[] time;
    long loopCnt;
    int calibrations;
    boolean doCalibrate;
    int skipFastest = 0;
    int skipSlowest = 3;

    public Timer(int iterationCnt) {
        this.iterationCnt = iterationCnt;
        this.time = new long[iterationCnt];
        this.reset(0);
    }

    public void reset(int benchmarkSize) {
        this.benchmarkSize = benchmarkSize;
        this.iteration = 0;
        this.calibrations = 0;
        this.loopCnt = 100L;
        Arrays.fill(this.time, 0L);
    }

    public long start() {
        this.time[this.iteration] = -System.currentTimeMillis();
        this.doCalibrate = true;
        return this.loopCnt;
    }

    public long start(long loopCnt) {
        this.time[this.iteration] = -System.currentTimeMillis();
        this.doCalibrate = false;
        this.loopCnt = loopCnt;
        return loopCnt;
    }

    public void stop() {
        int n = this.iteration;
        this.time[n] = this.time[n] + System.currentTimeMillis();
        if (this.doCalibrate && this.iteration == 0 && this.time[0] < 500L) {
            this.loopCnt = this.time[0] < 50L ? (this.loopCnt *= 10L) : (long)((double)this.loopCnt * (550.0 / (double)this.time[0]));
            ++this.calibrations;
            if (this.calibrations > 10) {
                throw new RuntimeException("Can not calibrate benchmark, loopCnt=" + this.loopCnt);
            }
            return;
        }
        ++this.iteration;
    }

    public boolean again() {
        return this.iteration < this.iterationCnt;
    }

    public void eval(String name) {
        long[] sortedTime = new long[this.iteration];
        System.arraycopy(this.time, 0, sortedTime, 0, this.iteration);
        Arrays.sort(sortedTime, 0, this.iteration);
        long minTime = sortedTime[this.skipFastest];
        long maxTime = sortedTime[this.iteration - 1 - this.skipSlowest];
        Statistics timeStat = new Statistics();
        Statistics sizeStat = new Statistics();
        for (int n = 0; n < this.iteration; ++n) {
            if (this.time[n] < minTime || this.time[n] > maxTime) continue;
            double ms_per_loop = (double)this.time[n] / (double)this.loopCnt;
            double size_per_ms = this.benchmarkSize * (double)this.loopCnt / (double)this.time[n];
            timeStat.add(ms_per_loop);
            sizeStat.add(size_per_ms);
        }
        timeStat.finish();
        sizeStat.finish();
        String padName = "                              ";
        String padE = "         ";
        String padSigma = "       ";
        System.out.print(Timer.padLeft(padName, name));
        System.out.print(": ");
        String fmtE = format.format(timeStat.getE() * 1000.0);
        System.out.print(Timer.pad(padE, fmtE));
        System.out.print("us ");
        String fmtSigma = format.format(timeStat.getSigma() * 1000.0);
        System.out.print("+-");
        System.out.print(Timer.pad(padSigma, fmtSigma));
        System.out.print("us ");
        if (this.benchmarkSize > 0.0) {
            String fmtEMBs = format.format(sizeStat.getE() / 1024.0 / 1024.0 * 1000.0);
            System.out.print(Timer.pad(padE, fmtEMBs));
            System.out.print("MB/s ");
        }
        System.out.println("  (" + this.loopCnt + " cycles, " + timeStat.getCnt() + " iterations)");
    }

    private static String pad(String pad, String s) {
        return pad.substring(Math.min(s.length(), pad.length())) + s;
    }

    private static String padLeft(String pad, String s) {
        return s + pad.substring(Math.min(s.length(), pad.length()));
    }

    public static class Statistics {
        int cnt;
        double sum;
        double qsum;
        double e;
        double var;
        double sigma;

        public int getCnt() {
            return this.cnt;
        }

        public double getE() {
            return this.e;
        }

        public double getSigma() {
            return this.sigma;
        }

        public void reset() {
            this.cnt = 0;
            this.sum = 0.0;
            this.qsum = 0.0;
            this.e = 0.0;
            this.var = 0.0;
            this.sigma = 0.0;
        }

        public void add(double value) {
            ++this.cnt;
            this.sum += value;
            this.qsum += value * value;
        }

        public void finish() {
            this.e = this.sum / (double)this.cnt;
            this.var = this.qsum / (double)this.cnt - this.e * this.e;
            this.sigma = Math.sqrt(this.var);
        }
    }
}

