/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.scheduler;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import jp.tools.scheduler.Job;
import jp.tools.scheduler.Schedule;

public class SimpleSchedule
implements Serializable,
Schedule {
    private Hashtable job2item = new Hashtable();
    private int size = 1;
    private SimpleItem root = new SimpleItem(this);

    public Schedule.Item getRoot() {
        return this.root;
    }

    private SimpleItem findSchedulableItem(SimpleItem root) {
        if (!root.isOrphane()) {
            return null;
        }
        Schedule.Item[] requisites = root.getRequisites();
        boolean hasUnfulfilledRequisite = false;
        for (int i = 0; i < requisites.length; ++i) {
            SimpleItem requisite = (SimpleItem)requisites[i];
            if (requisite.isDone()) continue;
            SimpleItem simpleItem = this.findSchedulableItem(requisite);
            if (simpleItem != null) {
                return simpleItem;
            }
            hasUnfulfilledRequisite = true;
        }
        if (hasUnfulfilledRequisite) {
            return null;
        }
        return root;
    }

    private synchronized SimpleItem findSchedulableItem() {
        return this.findSchedulableItem(this.root);
    }

    public Schedule.Item selectItemForScheduling() {
        SimpleItem simpleItem = this.findSchedulableItem();
        if (simpleItem != null) {
            simpleItem.setScheduled();
        }
        return simpleItem;
    }

    public Schedule.Item searchItem(Job job) {
        return (Schedule.Item)this.job2item.get(job);
    }

    private synchronized void setJob(Schedule.Item item, Job job) {
        if (job == null) {
            if (item.getJob() != null) {
                this.job2item.remove(item.getJob());
            }
        } else {
            if (this.searchItem(job) != null) {
                throw new IllegalArgumentException("job already associated with different item");
            }
            this.job2item.put(item, job);
        }
    }

    public int getSize() {
        return this.size;
    }

    public static class SimpleItem
    implements Serializable,
    Schedule.Item {
        private static final int STATE_ORPHANE = 0;
        private static final int STATE_SCHEDULED = 1;
        private static final int STATE_DONE = 2;
        private static final SimpleItem[] EMPTY_ITEM_ARRAY = new SimpleItem[0];
        private SimpleSchedule schedule;
        private Vector requisites;
        private Job job;
        private int state;

        private SimpleItem() {
        }

        private SimpleItem(SimpleSchedule simpleSchedule) {
            this.schedule = simpleSchedule;
            this.requisites = new Vector();
            this.job = null;
            this.state = 0;
        }

        public Schedule.Item[] getRequisites() {
            return this.requisites.toArray(EMPTY_ITEM_ARRAY);
        }

        public void setJob(Job job) {
            this.schedule.setJob(this, job);
            this.job = job;
        }

        public Job getJob() {
            return this.job;
        }

        public Schedule.Item createRequisite() {
            SimpleItem simpleItem = new SimpleItem(this.schedule);
            this.requisites.addElement(simpleItem);
            this.schedule.size++;
            return simpleItem;
        }

        public void addRequisite(SimpleItem simpleItem) {
            this.requisites.addElement(simpleItem);
        }

        public boolean isOrphane() {
            return this.state == 0;
        }

        public synchronized void setScheduled() {
            if (this.state != 0) {
                throw new IllegalStateException(String.valueOf("state==").concat(String.valueOf(this.state)));
            }
            this.state = 1;
        }

        public boolean isScheduled() {
            return this.state == 1;
        }

        public synchronized void setDone() {
            if (this.state != 1) {
                throw new IllegalStateException(String.valueOf("state==").concat(String.valueOf(this.state)));
            }
            this.state = 2;
        }

        public boolean isDone() {
            return this.state == 2;
        }
    }
}

