/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.scheduler;

import java.io.Serializable;
import jp.tools.scheduler.Job;
import jp.tools.scheduler.ScheduleException;
import jp.tools.scheduler.Scheduler;
import jp.tools.scheduler.SimpleSchedule;

public class ScheduleExample
implements Serializable {
    public static void main(String[] argv) {
        SimpleSchedule schedule = new SimpleSchedule();
        SimpleSchedule.SimpleItem item1 = (SimpleSchedule.SimpleItem)schedule.getRoot();
        item1.setJob(new ExampleJob("1", 2000L));
        SimpleSchedule.SimpleItem item2 = (SimpleSchedule.SimpleItem)item1.createRequisite();
        item2.setJob(new ExampleJob("2", 5000L));
        SimpleSchedule.SimpleItem item3 = (SimpleSchedule.SimpleItem)item1.createRequisite();
        item3.setJob(new ExampleJob("3", 10000L));
        SimpleSchedule.SimpleItem item4 = (SimpleSchedule.SimpleItem)item2.createRequisite();
        item4.setJob(new ExampleJob("4", 5000L));
        item3.addRequisite(item4);
        Scheduler scheduler = new Scheduler(schedule, 2);
        try {
            scheduler.schedule();
        }
        catch (ScheduleException e) {
            System.err.println(String.valueOf(String.valueOf("user-level exception occurred in job ").concat(String.valueOf(e.getJob()))).concat(String.valueOf(" while scheduling:")));
            e.getCause().printStackTrace(System.err);
        }
    }

    private static class ExampleJob
    implements Job {
        private String name;
        private long sleepTime;

        private ExampleJob(String name, long l) {
            this.name = name;
            this.sleepTime = l;
        }

        private void println(Object object) {
            System.out.println(String.valueOf(String.valueOf(String.valueOf("Job '").concat(String.valueOf(this.name))).concat(String.valueOf("': "))).concat(String.valueOf(object)));
        }

        public void performWork(Job[] requisites) {
            this.println("Starting work.");
            for (int i = 0; i < requisites.length; ++i) {
                this.println(String.valueOf("  Requisite: ").concat(String.valueOf(requisites[i])));
            }
            this.println(String.valueOf(String.valueOf("Sleeping ").concat(String.valueOf(this.sleepTime))).concat(String.valueOf("ms...")));
            try {
                Thread.currentThread();
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                this.println(String.valueOf("Sleep interrupted: ").concat(String.valueOf(interruptedException.getMessage())));
            }
            this.println("Finishing work.");
        }

        public String toString() {
            return this.name;
        }
    }
}

