/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.scheduler;

import java.io.Serializable;
import jp.tools.scheduler.Schedule;

class ItemCache
implements Serializable {
    private static final int INITIAL_SIZE = 10;
    private static final String CACHE_OVERFLOW_MESSAGE = "item cache overflow\r\n(this usually happens if you add items to a schedule while it is scheduled)";
    private Schedule.Item[] items;
    private int[] holes;
    private int firstHoleIndex;
    private int nextHoleIndex;

    public ItemCache() {
        this(10);
    }

    public ItemCache(int size) {
        this.items = new Schedule.Item[size + 1];
        this.holes = new int[size + 1];
        for (int i = 0; i < this.holes.length - 1; ++i) {
            this.holes[i] = i;
        }
        this.firstHoleIndex = 0;
        this.nextHoleIndex = 0;
    }

    public synchronized int store(Schedule.Item item) {
        if ((this.firstHoleIndex - this.nextHoleIndex - this.items.length) % this.items.length == -1) {
            throw new IllegalStateException(CACHE_OVERFLOW_MESSAGE);
        }
        int n = this.firstHoleIndex;
        this.items[this.firstHoleIndex++] = item;
        this.firstHoleIndex %= this.items.length;
        return n;
    }

    public Schedule.Item getItemFor(int n) {
        return this.items[n];
    }

    public synchronized void delete(int n) {
        if (n < 0 || n >= this.items.length - 1) {
            throw new IllegalArgumentException("invalid jobID");
        }
        this.holes[this.nextHoleIndex++] = n;
        this.nextHoleIndex %= this.holes.length;
    }
}

