/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.lang.VirtualMachine;
import jp.tools.monitor.ActionHandler;
import jp.tools.monitor.JVMStatusPanel;

public class JVMSelectionPanel
extends JPanel {
    private static final String TITLE = "Registered JVMs";
    private static final String RESET_BUTTON_TITLE = "Reset All";
    private static final Dimension JVMPANE_PREFERRED_SIZE = new Dimension(200, 150);
    private ActionHandler handler;
    private JList jvmList;
    private JScrollPane jvmPane;
    private VMInfo[] vmInfo;

    private JVMSelectionPanel() {
    }

    public JVMSelectionPanel(ActionHandler handler) {
        this.handler = handler;
        this.setLayout(new BorderLayout());
        this.jvmList = new JList();
        this.vmInfo = this.getVMInfo();
        this.jvmList.setListData(this.vmInfo);
        this.jvmList.addListSelectionListener(new JVMListSelectionListener());
        this.jvmPane = new JScrollPane(this.jvmList);
        this.jvmPane.setPreferredSize(JVMPANE_PREFERRED_SIZE);
        Border etchedBorder = BorderFactory.createEtchedBorder();
        this.jvmPane.setBorder(BorderFactory.createTitledBorder(etchedBorder, TITLE, 2, 2));
        this.add((Component)this.jvmPane, "West");
        JVMStatusPanel jvmStatusPanel = new JVMStatusPanel(handler);
        this.add((Component)jvmStatusPanel, "Center");
        handler.setJVMStatusPanel(jvmStatusPanel);
        this.add((Component)new ResetButton(), "South");
    }

    private VMInfo[] getVMInfo() {
        int vmcnt = this.handler.getMachineCnt();
        VMInfo[] vmInfo = new VMInfo[vmcnt];
        for (int i = 0; i < vmcnt; ++i) {
            vmInfo[i] = new VMInfo(i, this.handler.getMachine(i));
        }
        return vmInfo;
    }

    public void updateJVMList() {
        this.vmInfo = this.getVMInfo();
        this.jvmList.setListData(this.vmInfo);
        this.validate();
    }

    private static class VMInfo {
        private int id;
        private VirtualMachine vm;

        private VMInfo(int id, VirtualMachine vm) {
            this.id = id;
            this.vm = vm;
        }

        public String toString() {
            return "id=" + this.id + "; ip=" + this.vm.host();
        }
    }

    private class JVMListSelectionListener
    implements ListSelectionListener {
        private JVMListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (JVMSelectionPanel.this.jvmList.isSelectionEmpty()) {
                JVMSelectionPanel.this.handler.selectVM(null);
            } else {
                int index = JVMSelectionPanel.this.jvmList.getSelectedIndex();
                JVMSelectionPanel.this.handler.selectVM(JVMSelectionPanel.this.vmInfo[index].vm);
            }
        }
    }

    private class ResetButton
    extends JButton
    implements ActionListener {
        public ResetButton() {
            super(JVMSelectionPanel.RESET_BUTTON_TITLE);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            JVMSelectionPanel.this.handler.resetRM();
        }
    }
}

