/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.monitor;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.lang.VirtualMachine;
import jp.tools.monitor.ActionHandler;
import jp.tools.monitor.ConstructorTablePanel;

public class ClassTablePanel
extends JPanel {
    private static final String TITLE = "Class Table";
    private static final Dimension CLASSTABLEPANE_PREFERRED_SIZE = new Dimension(200, 50);
    private static final String[] EMPTY_LIST = new String[0];
    private static final String[] PSEUDO_LIST = new String[]{"<no class registered>"};
    private ActionHandler handler;
    private VirtualMachine vm;
    private JList classTableList;
    private JScrollPane classTablePane;
    private ConstructorTablePanel constructorTablePanel;

    private ClassTablePanel() {
    }

    public ClassTablePanel(ActionHandler handler) {
        this.handler = handler;
        this.setLayout(new BoxLayout(this, 0));
        this.classTableList = new JList();
        this.classTableList.setListData(this.getClassInfo());
        this.classTableList.addListSelectionListener(new ClassTableListSelectionListener());
        this.classTablePane = new JScrollPane(this.classTableList);
        this.classTablePane.setPreferredSize(CLASSTABLEPANE_PREFERRED_SIZE);
        Border etchedBorder = BorderFactory.createEtchedBorder();
        this.classTablePane.setBorder(BorderFactory.createTitledBorder(etchedBorder, TITLE, 2, 2));
        this.add(this.classTablePane);
        this.constructorTablePanel = new ConstructorTablePanel(handler);
        this.add(this.constructorTablePanel);
    }

    private String[] getClassInfo() {
        String[] table;
        if (this.vm == null) {
            table = EMPTY_LIST;
        } else {
            table = this.vm.getClassTableNames();
            if (table == null) {
                table = PSEUDO_LIST;
            }
        }
        return table;
    }

    public void validate() {
        this.classTableList.setListData(this.getClassInfo());
        this.classTableList.getSelectionModel().setSelectionMode(0);
        super.validate();
    }

    public void selectVM(VirtualMachine vm) {
        this.vm = vm;
        this.validate();
    }

    private class ClassTableListSelectionListener
    implements ListSelectionListener {
        private ClassTableListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            String value = (String)((JList)e.getSource()).getSelectedValue();
            ClassTablePanel.this.constructorTablePanel.selectClassName(ClassTablePanel.this.vm, value);
        }
    }
}

