/*
 * Decompiled with CFR 0.152.
 */
package jp.sync;

import java.io.Serializable;
import jp.sync.Barrier;

class LocalBarrier
implements Serializable,
Barrier {
    int maxEnter;
    boolean enterMode = true;
    int entered = 0;
    int leaveCnt = 0;
    Barrier.Callback callback;
    private Object result;

    public LocalBarrier(int max, Barrier.Callback callback) {
        this.maxEnter = max;
        this.callback = callback;
    }

    public synchronized void setMax(int n) {
        this.maxEnter = n;
    }

    public synchronized int getMax() {
        return this.maxEnter;
    }

    public synchronized void setCallback(Barrier.Callback callback) {
        this.callback = callback;
    }

    protected final void waitForEnter() throws InterruptedException {
        while (!this.enterMode) {
            this.wait();
        }
    }

    protected void lastThreadEntered() {
        this.resetEnterMode();
    }

    protected void lastThreadLeft() throws InterruptedException {
        this.setEnterMode();
    }

    protected void setEnterMode() throws InterruptedException {
        this.enterMode = true;
        this.notifyAll();
    }

    protected final void resetEnterMode() {
        this.enterMode = false;
    }

    public synchronized Object sync() throws InterruptedException {
        this.waitForEnter();
        ++this.entered;
        if (this.entered == this.maxEnter) {
            this.lastThreadEntered();
            if (this.callback != null) {
                this.result = this.callback.completed();
            }
            this.leaveCnt = this.entered;
            this.entered = 0;
            this.notifyAll();
        } else {
            while (this.leaveCnt == 0) {
                this.wait();
            }
        }
        --this.leaveCnt;
        if (this.leaveCnt == 0) {
            Object object = this.result;
            this.result = null;
            this.lastThreadLeft();
            return object;
        }
        return this.result;
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("LocalBarrier(maxEnter=").concat(String.valueOf(this.maxEnter))).concat(String.valueOf(", enterMode="))).concat(String.valueOf(this.enterMode))).concat(String.valueOf(", entered="))).concat(String.valueOf(this.entered))).concat(String.valueOf(", leaveCnt="))).concat(String.valueOf(this.leaveCnt))).concat(String.valueOf(", callback="))).concat(String.valueOf(this.callback))).concat(String.valueOf(")"));
    }
}

