/*
 * Decompiled with CFR 0.152.
 */
package jp.lang;

import java.io.Serializable;
import java.util.Hashtable;
import jp.lang.ApplicationContext;
import jp.lang.Array;
import jp.lang.Distributor;
import jp.lang.RemoteExitException;
import jp.lang.RemoteObject_class_intf;
import jp.lang.RuntimeManager;
import jp.lang.VirtualMachine;

public class RuntimeEnvironment
implements Serializable {
    public static RuntimeManager rm;
    static Hashtable constrObjs;
    static Hashtable classObjs;
    public static ApplicationContext context;
    private static boolean debug;
    private static int machineID;
    private static int machineCnt;
    private static Distributor objDistr;
    static Class thisClass;

    public static void init(RuntimeManager rm, ApplicationContext context, int machineID) {
        RuntimeEnvironment.rm = rm;
        RuntimeEnvironment.context = context;
        machineCnt = context.getMachineCnt();
        objDistr = context.objDistr;
        debug = context.debug;
        RuntimeEnvironment.machineID = machineID;
        RuntimeEnvironment.reset();
    }

    public static synchronized void init(RuntimeManager rm, ApplicationContext context) {
        RuntimeEnvironment.init(rm, context, -1);
    }

    public static RemoteObject_class_intf getClassObj(String classname) {
        try {
            RemoteObject_class_intf classObj;
            Class clazz = thisClass;
            synchronized (clazz) {
                try {
                    classObj = (RemoteObject_class_intf)classObjs.get(classname);
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
            if (classObj == null) {
                classObj = rm.getClassObject(classname);
                Class clazz2 = thisClass;
                synchronized (clazz2) {
                    try {
                        classObjs.put(classname, classObj);
                        rm.notifyChangeInClassObjs(machineID);
                        Object var6_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        throw throwable;
                    }
                }
            }
            return classObj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static RemoteObject_class_intf getConstrObj(String classname) {
        return RuntimeEnvironment.getConstrObj(classname, RuntimeEnvironment.getTarget(classname));
    }

    public static int getTarget(String classname) {
        int node = objDistr.target(machineCnt, classname);
        if (debug) {
            System.err.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("VM#").concat(String.valueOf(machineID))).concat(String.valueOf(": Remote object allocation: class="))).concat(String.valueOf(classname))).concat(String.valueOf(", machineCnt="))).concat(String.valueOf(machineCnt))).concat(String.valueOf(", node="))).concat(String.valueOf(node)));
        }
        return node;
    }

    public static RemoteObject_class_intf getConstrObj(String classname, int target) {
        try {
            Serializable serializable;
            Array constructors;
            Class clazz = thisClass;
            synchronized (clazz) {
                try {
                    constructors = (Array)constrObjs.get(classname);
                    if (target < 0) {
                        target = RuntimeEnvironment.getTarget(classname);
                    }
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
            if (constructors == null || constructors.length() < (target %= machineCnt) || constructors.get(target) == null) {
                constructors = rm.getConstructorObjectTable(classname, target);
                serializable = thisClass;
                synchronized (serializable) {
                    try {
                        constrObjs.put(classname, constructors);
                        Object var7_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        throw throwable;
                    }
                }
            }
            serializable = (RemoteObject_class_intf)constructors.get(target);
            return serializable;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void setObjectDistributor(Distributor objDistr) {
        RuntimeEnvironment.objDistr = objDistr;
    }

    public static void setClassDistributor(Distributor distributor) {
        rm.setClassDistributor(distributor);
    }

    public static int getMachineCnt() {
        return machineCnt;
    }

    public static int getMachineID() {
        return machineID;
    }

    public static VirtualMachine getMachine(int id) {
        return context.getMachine(id);
    }

    public static void exit(int status) {
        throw new RemoteExitException(status);
    }

    public static void kill(int status) {
        try {
            rm.kill(status);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static final void reset() {
        objDistr.reset();
        objDistr.update();
        constrObjs = new Hashtable();
        classObjs = new Hashtable();
    }

    public static final void setPriority(int location, int priority) {
        objDistr.setPriority(location, priority);
    }

    static {
        objDistr = null;
        thisClass = Class.forName("jp.lang.RuntimeEnvironment");
    }
}

