/*
 * Decompiled with CFR 0.152.
 */
package jp.lang;

import jp.lang.ConfigurationException;
import jp.lang.Distributor;
import jp.lang.RemoteObject;
import jp.lang.RuntimeEnvironment;

public final class DistributedRuntime {
    public static final int getMachineID() {
        return RuntimeEnvironment.getMachineID();
    }

    public static final int getMachineCnt() {
        return RuntimeEnvironment.getMachineCnt();
    }

    public static final void setTarget() {
        RuntimeEnvironment.setPriority(RuntimeEnvironment.getMachineID(), Distributor.ALWAYS);
    }

    public static final void setTarget(int t) {
        RuntimeEnvironment.setPriority(t, Distributor.ALWAYS);
    }

    public static final void setTarget(RemoteObject obj) {
        if (obj != null) {
            RuntimeEnvironment.setPriority(obj._location(), Distributor.ALWAYS);
        }
    }

    public static final void resetTarget() {
        RuntimeEnvironment.reset();
    }

    public static final void setObjectDistributor(Distributor distr) {
        RuntimeEnvironment.setObjectDistributor(distr);
    }

    public static final void setClassDistributor(Distributor distr) {
        RuntimeEnvironment.setClassDistributor(distr);
    }

    public static final void exit(int status) {
        RuntimeEnvironment.exit(status);
    }

    public static final void kill(int status) {
        RuntimeEnvironment.kill(status);
    }

    public static final boolean migrate(RemoteObject obj, int id) {
        return obj._migrateTo(RuntimeEnvironment.getMachine(id));
    }

    public static final int getLocation(RemoteObject obj) {
        return obj._location();
    }

    public static final int machines() {
        return DistributedRuntime.getMachineCnt();
    }

    public static final int thisLocation() {
        return DistributedRuntime.getMachineID();
    }

    public static final void setObjectDistributor(String classname) {
        try {
            RuntimeEnvironment.setObjectDistributor(Distributor.loadDistributor(classname));
        }
        catch (ConfigurationException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

