/*
 * Decompiled with CFR 0.152.
 */
package jp.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jp.lang.ClassDistributor;
import jp.lang.ConfigJP;
import jp.lang.ConfigurationException;
import jp.lang.Distributor;
import jp.lang.Monitor;
import jp.lang.ObjectDistributor;

public class ConfigRM
extends ConfigJP {
    public boolean compatibility = true;
    public Distributor objDistr = new ObjectDistributor();
    public Distributor classDistr = new ClassDistributor();
    public Monitor monitor = null;
    public boolean passive = false;
    public ArrayList nodeNames;

    public String programName() {
        return "jprm";
    }

    public String argumentDescription() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(super.argumentDescription()).concat(String.valueOf("[-nodenames <comma separated list of node names>] "))).concat(String.valueOf("[-passive] "))).concat(String.valueOf("[-initLazy] "))).concat(String.valueOf("[-initStrict] "))).concat(String.valueOf("[-objDistr <object distributor class>] "))).concat(String.valueOf("[-classDistr <class distributor class>] "))).concat(String.valueOf("[-monitor <monitor class>] "));
    }

    public void setObjectDistributor(Distributor distributor) {
        this.objDistr = distributor;
    }

    public void setClassDistributor(Distributor distributor) {
        this.classDistr = distributor;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public int init(String[] args, int n) throws ConfigurationException {
        String arg = args[n++];
        try {
            if (arg.equals("-initLazy")) {
                this.compatibility = false;
                return n;
            }
            if (arg.equals("-initStrict")) {
                this.compatibility = true;
                return n;
            }
            if (arg.equals("-objDistr")) {
                this.setObjectDistributor((Distributor)Class.forName(args[n++]).newInstance());
                return n;
            }
            if (arg.equals("-classDistr")) {
                this.setClassDistributor((Distributor)Class.forName(args[n++]).newInstance());
                return n;
            }
            if (arg.equals("-monitor")) {
                this.setMonitor((Monitor)Class.forName(args[n++]).newInstance());
                return n;
            }
            if (arg.equals("-passive")) {
                this.passive = true;
                return n;
            }
            if (arg.equals("-nodenames")) {
                if (this.nodeNames != null) {
                    throw new ConfigurationException("only one -nodenames or -nodefile argument possible");
                }
                this.nodeNames = new ArrayList();
                if (args[n].startsWith("-")) {
                    throw new ConfigurationException("missing list of node names");
                }
                StringTokenizer tokens = new StringTokenizer(args[n++], ", ");
                while (tokens.hasMoreTokens()) {
                    this.nodeNames.add(tokens.nextToken());
                }
                return n;
            }
            if (arg.equals("-nodefile")) {
                if (this.nodeNames != null) {
                    throw new ConfigurationException("only one -nodenames or -nodefile argument possible");
                }
                this.nodeNames = new ArrayList();
                try {
                    String nodeName;
                    File nodefile = new File(args[n++]);
                    BufferedReader nodeReader = new BufferedReader(new FileReader(nodefile));
                    while ((nodeName = nodeReader.readLine()) != null) {
                        if ((nodeName = nodeName.trim()).length() == 0 || nodeName.startsWith("#")) continue;
                        this.nodeNames.add(nodeName);
                    }
                    return n;
                }
                catch (IOException ex) {
                    throw new ConfigurationException(String.valueOf("can not read nodefile: ").concat(String.valueOf(ex)));
                }
            }
            return super.init(args, n - 1);
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationException(String.valueOf(String.valueOf(String.valueOf(String.valueOf("distributor/monitor class '").concat(String.valueOf(args[n - 1]))).concat(String.valueOf("' specified in option '"))).concat(String.valueOf(arg))).concat(String.valueOf("' not found")));
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("can't access distributor/monitor class '").concat(String.valueOf(args[n - 1]))).concat(String.valueOf("' specified in option '"))).concat(String.valueOf(arg))).concat(String.valueOf("': "))).concat(String.valueOf(ex)));
        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("distributor/monitor class '").concat(String.valueOf(args[n - 1]))).concat(String.valueOf("' specified in option '"))).concat(String.valueOf(arg))).concat(String.valueOf("' could not be instantiated: "))).concat(String.valueOf(ex)));
        }
        catch (ClassCastException classCastException) {
            if (arg.equals("-objDistr") || arg.equals("-classDistr")) {
                throw new ConfigurationException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("argument specified in option '").concat(String.valueOf(arg))).concat(String.valueOf("' is not a subclass of "))).concat(String.valueOf(Class.forName("jp.lang.Distributor").getName()))).concat(String.valueOf(" ('"))).concat(String.valueOf(args[n - 1]))).concat(String.valueOf("')")));
            }
            throw new ConfigurationException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("argument specified in option '").concat(String.valueOf(arg))).concat(String.valueOf("' is not a subclass of "))).concat(String.valueOf(Class.forName("jp.lang.Monitor").getName()))).concat(String.valueOf(" ('"))).concat(String.valueOf(args[n - 1]))).concat(String.valueOf("')")));
        }
    }
}

