/*
 * Decompiled with CFR 0.152.
 */
package jp.lang;

import java.io.Serializable;
import jp.lang.ConfigurationException;

public abstract class ConfigBase
implements Serializable {
    private boolean stopped;

    public abstract String programName();

    public String argumentDescription() {
        return "[-help] ";
    }

    public void usage() {
        System.err.println(String.valueOf(String.valueOf(String.valueOf("usage: ").concat(String.valueOf(this.programName()))).concat(String.valueOf(" "))).concat(String.valueOf(this.argumentDescription())));
    }

    protected void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    protected void checkValues() throws ConfigurationException {
    }

    public int init(String[] args, int n) throws NumberFormatException, ConfigurationException {
        String string;
        if ((string = args[n++]).equals("-help")) {
            this.usage();
            this.stop();
            return n;
        }
        throw new ConfigurationException(String.valueOf(String.valueOf("unknown option '").concat(String.valueOf(string))).concat(String.valueOf("'")));
    }

    public final ConfigBase init(String[] args) throws ConfigurationException {
        this.stopped = false;
        int n = 0;
        try {
            while (n < args.length && !this.isStopped()) {
                n = this.init(args, n);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConfigurationException(String.valueOf(String.valueOf("option '").concat(String.valueOf(args[n]))).concat(String.valueOf("' expects an additional argument")));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException(String.valueOf(String.valueOf("option '").concat(String.valueOf(args[n]))).concat(String.valueOf("' requires an numerical argument")));
        }
        if (!this.isStopped()) {
            this.checkValues();
        }
        return this;
    }
}

