/*
 * Decompiled with CFR 0.152.
 */
package jp.lang;

import java.io.IOException;
import java.util.Arrays;
import uka.transport.BasicIO;
import uka.transport.DeepClone;
import uka.transport.MarshalStream;
import uka.transport.Transportable;
import uka.transport.UnmarshalStream;

public class Array
implements Transportable {
    int size;
    Object[] data;
    public static final int INITIAL_SIZE = 8;
    protected static final int _SIZE = 4;

    public Array(int n) {
        this.size = n;
        this.data = new Object[n];
    }

    public Array() {
        this.size = 0;
        this.data = new Object[8];
    }

    public final int length() {
        return this.size;
    }

    public final int size() {
        return this.size;
    }

    public final void setLength(int n) {
        if (n < this.size) {
            Arrays.fill(this.data, n, this.size - 1, null);
        } else if (n > this.size) {
            this.requireSize(n);
        }
        this.size = n;
    }

    public final void clear() {
        this.setLength(0);
    }

    public final Object set(int n, Object object) {
        this.checkAccess(n);
        this.data[n] = object;
        return object;
    }

    public final Object get(int n) {
        this.checkAccess(n);
        return this.data[n];
    }

    public final Object add(Object object) {
        this.requireSize(this.size + 1);
        this.data[this.size++] = object;
        return object;
    }

    public final void add(Array array) {
        this.add(array, 0, array.size);
    }

    public final void add(Array other, int start, int stop) {
        other.checkAccess(start, stop);
        int n = stop - start;
        this.requireSize(this.size + n);
        System.arraycopy(other.data, start, this.data, this.size, n);
    }

    public final Array subarray(int n) {
        return this.subarray(n, this.size);
    }

    public final Array subarray(int start, int stop) {
        this.checkAccess(start, stop);
        int len = stop - start;
        Array array = new Array(len);
        System.arraycopy(this.data, start, array.data, 0, len);
        return array;
    }

    public final void remove(int start) {
        int n = this.size - 1;
        if (start == n) {
            this.data[n] = null;
            --this.size;
            return;
        }
        this.remove(start, start + 1);
    }

    public final void remove(int start, int stop) {
        this.checkAccess(start, stop);
        int restlen = this.size - stop;
        if (restlen > 0) {
            System.arraycopy(this.data, stop, this.data, start, restlen);
        }
        int n = stop - start;
        this.size -= n;
        Arrays.fill(this.data, this.size, this.size + n, null);
    }

    public final void insert(Array other, int n) {
        this.insert(other, 0, other.size, n);
    }

    public final void insert(Array other, int start, int stop, int deststart) {
        other.checkAccess(start, stop);
        this.checkAccess(deststart);
        int insertlen = stop - start;
        int restlen = this.size - deststart;
        int requestsize = this.size + insertlen;
        if (this.needAlloc(requestsize)) {
            Object[] objectArray = this.alloc(requestsize);
            if (deststart > 0) {
                System.arraycopy(this.data, 0, objectArray, 0, deststart);
            }
            if (restlen > 0) {
                System.arraycopy(this.data, deststart, objectArray, deststart + insertlen, restlen);
            }
            this.data = objectArray;
        } else if (restlen > 0) {
            System.arraycopy(this.data, deststart, this.data, deststart + insertlen, restlen);
        }
        if (insertlen > 0) {
            System.arraycopy(other.data, start, this.data, deststart, insertlen);
        }
    }

    public final Object[] toArray() {
        return this.toArray(new Object[this.length()]);
    }

    public final Object[] toArray(Object[] objectArray) {
        return this.toArray(0, this.length(), objectArray, 0);
    }

    public final Object[] toArray(int start, int stop, Object[] dest, int destpos) {
        this.checkAccess(start, stop);
        int n = stop - start;
        if (n > 0) {
            System.arraycopy(this.data, start, dest, destpos, stop - start);
        }
        return dest;
    }

    private final void checkAccess(int n) {
        if (n > this.size) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(n).concat(String.valueOf(" > "))).concat(String.valueOf(this.length())));
        }
    }

    private final void checkAccess(int start, int n) {
        this.checkAccess(n);
        if (start > n) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(String.valueOf(String.valueOf("negative range [").concat(String.valueOf(start))).concat(String.valueOf(", "))).concat(String.valueOf(n))).concat(String.valueOf("]")));
        }
    }

    private final void requireSize(int requestsize) {
        if (this.needAlloc(requestsize)) {
            return;
        }
        Object[] objectArray = this.alloc(requestsize);
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        this.data = objectArray;
    }

    private final boolean needAlloc(int n) {
        return n <= this.data.length;
    }

    private final Object[] alloc(int requestsize) {
        int allocsize = Math.max(requestsize, 2 * this.size);
        Object[] objectArray = new Object[allocsize];
        return objectArray;
    }

    public Array(UnmarshalStream unmarshalStream) throws IOException, ClassNotFoundException {
        this(unmarshalStream, 4);
        unmarshalStream.accept(4);
    }

    protected Array(UnmarshalStream _stream, int _size) throws IOException, ClassNotFoundException {
        _stream.request(_size);
        byte[] _buffer = _stream.getBuffer();
        int n = _stream.getPosition();
        this.size = BasicIO.extractInt((byte[])_buffer, (int)n);
        n += 4;
    }

    public void unmarshalReferences(UnmarshalStream unmarshalStream) throws IOException, ClassNotFoundException {
        this.data = (Object[])unmarshalStream.readObject();
    }

    public void marshal(MarshalStream _stream) throws IOException {
        _stream.reserve(4);
        byte[] _buffer = _stream.getBuffer();
        int n = _stream.getPosition();
        this.marshalPrimitives(_buffer, n);
        _stream.deliver(4);
        this.marshalReferences(_stream);
    }

    protected void marshalPrimitives(byte[] _buffer, int n) throws IOException {
        n = BasicIO.insert((byte[])_buffer, (int)n, (int)this.size);
    }

    protected void marshalReferences(MarshalStream marshalStream) throws IOException {
        marshalStream.writeObject((Object)this.data);
    }

    public final Object deepClone(DeepClone _helper) throws CloneNotSupportedException {
        Object object = this.clone();
        _helper.add((Object)this, object);
        ((Array)object).deepCloneReferences(_helper);
        return object;
    }

    protected void deepCloneReferences(DeepClone deepClone) throws CloneNotSupportedException {
        this.data = deepClone.doDeepClone(this.data);
    }
}

