/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Scanner;
import java.util.StringTokenizer;

public class KlattScheduler {
    HashMap<Integer, double[]> data = new HashMap();
    HashMap<String, Integer> variableNamesToIndices = new HashMap();
    public static int[] defaultFrame = new int[40];
    String filename;
    int numChannels = 5;
    int granularity = 1;
    int timesteps = 200;
    double[][] frequencies;
    double[][] amplitudes;
    double[][] arraydata;

    public KlattScheduler() {
        this.variableNamesToIndices.put("F0", 0);
        this.variableNamesToIndices.put("AV", 1);
        this.variableNamesToIndices.put("F1", 2);
        this.variableNamesToIndices.put("B1", 3);
        this.variableNamesToIndices.put("F2", 4);
        this.variableNamesToIndices.put("B2", 5);
        this.variableNamesToIndices.put("F3", 6);
        this.variableNamesToIndices.put("B3", 7);
        this.variableNamesToIndices.put("F4", 8);
        this.variableNamesToIndices.put("B4", 9);
        this.variableNamesToIndices.put("F5", 10);
        this.variableNamesToIndices.put("B5", 11);
        this.variableNamesToIndices.put("F6", 12);
        this.variableNamesToIndices.put("B6", 13);
        this.variableNamesToIndices.put("FNZ", 14);
        this.variableNamesToIndices.put("BNZ", 15);
        this.variableNamesToIndices.put("FNP", 16);
        this.variableNamesToIndices.put("BNP", 17);
        this.variableNamesToIndices.put("ASP", 18);
        this.variableNamesToIndices.put("KOPEN", 19);
        this.variableNamesToIndices.put("ATURB", 20);
        this.variableNamesToIndices.put("TILT", 21);
        this.variableNamesToIndices.put("AF", 22);
        this.variableNamesToIndices.put("SKEW", 23);
        this.variableNamesToIndices.put("A1", 24);
        this.variableNamesToIndices.put("B1P", 25);
        this.variableNamesToIndices.put("A2", 26);
        this.variableNamesToIndices.put("B2P", 27);
        this.variableNamesToIndices.put("A3", 28);
        this.variableNamesToIndices.put("B3P", 29);
        this.variableNamesToIndices.put("A4", 30);
        this.variableNamesToIndices.put("B5P", 31);
        this.variableNamesToIndices.put("A5", 32);
        this.variableNamesToIndices.put("B5P", 33);
        this.variableNamesToIndices.put("A6", 34);
        this.variableNamesToIndices.put("B6P", 35);
        this.variableNamesToIndices.put("ANP", 36);
        this.variableNamesToIndices.put("AB", 37);
        this.variableNamesToIndices.put("AVP", 38);
        this.variableNamesToIndices.put("GAIN", 39);
    }

    public void process(String filename) throws Exception {
        this.load(filename);
        this.convertHashMapDataToArrays();
        for (int columnNumber = 0; columnNumber < 40; ++columnNumber) {
            double[] column = this.extractColumn(this.arraydata, columnNumber);
            this.interpolate(column);
            this.writeColumn(column, this.arraydata, columnNumber);
        }
        for (int t = 1; t < this.timesteps; ++t) {
            this.setDefaults(this.arraydata[t]);
        }
        this.save(filename + ".freq");
    }

    private boolean isSeparator(String s) {
        if (s.equals("|")) {
            return true;
        }
        if (s.equals(";")) {
            return true;
        }
        if (s.equals(",")) {
            return true;
        }
        return s.equals("&");
    }

    private double[] extractColumn(double[][] array, int columnNumber) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i][columnNumber];
        }
        return result;
    }

    private void writeColumn(double[] column, double[][] array, int columnNumber) {
        for (int i = 0; i < array.length; ++i) {
            array[i][columnNumber] = column[i];
        }
    }

    public void save(String filename) throws Exception {
        BufferedWriter b = new BufferedWriter(new FileWriter(filename));
        for (int t = 1; t < this.timesteps; ++t) {
            b.write(KlattScheduler.implode(this.arraydata[t]) + "\n");
        }
        b.close();
    }

    public int findNonDefault(double[] values, int startingFrom) {
        for (int i = startingFrom; i < values.length; ++i) {
            if (!(values[i] >= 0.0)) continue;
            return i;
        }
        return values.length - 1;
    }

    private void copyRowFromTo(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i];
        }
    }

    private void convertHashMapDataToArrays() {
        this.arraydata = new double[this.timesteps][40];
        for (int t = 0; t < this.timesteps; ++t) {
            if (this.data.get(t) != null) {
                this.copyRowFromTo(this.data.get(t), this.arraydata[t]);
                continue;
            }
            this.setDefaultFlags(this.arraydata[t]);
        }
    }

    private void interpolate(double[] values) {
        int startTime = 0;
        int endTime = 0;
        while (endTime < this.timesteps - 1 && (endTime = this.findNonDefault(values, (startTime = this.findNonDefault(values, endTime)) + 1)) != 0 && startTime != this.timesteps - 1 && endTime - startTime > 0) {
            this.interpolate(values, startTime, endTime);
        }
    }

    private void interpolate(double[] values, int start, int end) {
        double slope = (values[end] - values[start]) / (double)(end - start);
        int steps = 0;
        for (int i = start + 1; i <= end - 1; ++i) {
            values[i] = values[start] + slope * (double)(++steps);
        }
    }

    private void load(String filename) throws Exception {
        int currentTime = 1;
        Scanner s = new Scanner(new File(filename));
        if (s.next().equals("timesteps")) {
            this.timesteps = s.nextInt();
        }
        this.frequencies = new double[this.numChannels][this.granularity * this.timesteps];
        this.amplitudes = new double[this.numChannels][this.granularity * this.timesteps];
        while (s.hasNext()) {
            String nextToken = s.next();
            while (this.isSeparator(nextToken)) {
                nextToken = s.next();
            }
            if (nextToken.equals("t")) {
                s.next();
                currentTime = s.nextInt();
                continue;
            }
            String variableName = nextToken;
            s.next();
            int value = s.nextInt();
            this.setVariable(currentTime, variableName, value);
        }
    }

    public void setVariable(int time, String variableName, int value) {
        double[] row = null;
        if (this.data.get(time) == null) {
            row = new double[40];
            this.setDefaultFlags(row);
        } else {
            row = this.data.get(time);
        }
        if (this.variableNamesToIndices.get(variableName) == null) {
            throw new RuntimeException("\nUnknown variable " + variableName + " was used.");
        }
        row[this.variableNamesToIndices.get((Object)variableName).intValue()] = value;
        this.data.put(time, row);
    }

    private void setDefaultFlags(double[] row) {
        for (int i = 0; i < row.length; ++i) {
            row[i] = -1.0;
        }
    }

    private void setDefaults(double[] row) {
        for (int i = 0; i < row.length; ++i) {
            if (!(row[i] < 0.0)) continue;
            row[i] = defaultFrame[i];
        }
    }

    public static void main(String[] args) throws Exception {
        String dummyFrame = "1000 70 250 0 1250 0 3000 0 3500 0 4170 0 4000 0 0 0 200 40 0 40 0 20 0 0 60 44 60 70 60 95 60 56 60 80 0 80 0 0 60 0 ";
        defaultFrame = KlattScheduler.explodeToInts(dummyFrame, " ");
        if (args.length == 0) {
            System.err.println("Pass filename as first argument");
            System.exit(1);
        }
        new KlattScheduler().process(args[0]);
    }

    public static int[] explodeToInts(String s, String delim) {
        StringTokenizer t = new StringTokenizer(s, delim);
        int[] result = new int[t.countTokens()];
        Scanner sc = new Scanner(s);
        int i = 0;
        while (sc.hasNextInt()) {
            result[i] = sc.nextInt();
            ++i;
        }
        return result;
    }

    public static String implode(double[] a) {
        String result = "";
        for (int i = 0; i < a.length; ++i) {
            result = result + (int)a[i] + " ";
        }
        return result;
    }
}

