/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Scanner;
import java.util.StringTokenizer;

public class FormantScheduler {
    public static int VOICING_AMPLITUDE = 38;
    public static int FIRST_FORMANT_AMPLITUDE_PARALLEL = 24;
    public static int SECOND_FORMANT_AMPLITUDE_PARALLEL = 26;
    public static int THIRD_FORMANT_AMPLITUDE_PARALLEL = 28;
    public static int FOURTH_FORMANT_AMPLITUDE_PARALLEL = 30;
    public static int[] frame = new int[40];
    String filename;
    int numChannels = 5;
    int granularity = 1;
    int timesteps = 200;
    double[][] frequencies;
    double[][] amplitudes;

    public void process(String filename) throws Exception {
        this.load(filename);
        this.interpolate();
        this.save(filename + ".freq");
    }

    public void save(String filename) throws Exception {
        BufferedWriter b = new BufferedWriter(new FileWriter(filename));
        for (int t = 0; t < this.timesteps; ++t) {
            for (int c = 0; c < this.numChannels; ++c) {
                FormantScheduler.frame[c * 2] = (int)Math.round(this.frequencies[c][t]);
                FormantScheduler.frame[FormantScheduler.FIRST_FORMANT_AMPLITUDE_PARALLEL + c * 2] = (int)Math.round(this.amplitudes[c][t]);
            }
            FormantScheduler.frame[FormantScheduler.VOICING_AMPLITUDE] = (int)Math.round(this.amplitudes[0][t]);
            b.write(FormantScheduler.implode(frame) + "\n");
        }
        b.close();
    }

    public int findNonzero(double[] values, int startingFrom) {
        for (int i = startingFrom; i < values.length; ++i) {
            if (values[i] == 0.0) continue;
            return i;
        }
        return values.length - 1;
    }

    private void interpolate() {
        for (int c = 0; c < this.numChannels; ++c) {
            System.err.println("Channel " + c);
            int startTime = 0;
            int endTime = 0;
            while (endTime < this.timesteps - 1 && (endTime = this.findNonzero(this.frequencies[c], (startTime = this.findNonzero(this.frequencies[c], endTime)) + 1)) != 0 && startTime != this.timesteps - 1 && endTime - startTime > 0) {
                System.err.println(" " + this.frequencies[c][startTime] + "Hz @ " + startTime + "ms --> " + this.frequencies[c][endTime] + "Hz @ " + endTime + "ms");
                this.interpolate(this.frequencies[c], startTime, endTime);
                this.interpolate(this.amplitudes[c], startTime, endTime);
            }
        }
    }

    private void interpolate(double[] values, int start, int end) {
        double slope = (values[end] - values[start]) / (double)(end - start);
        int steps = 0;
        for (int i = start + 1; i <= end - 1; ++i) {
            values[i] = values[start] + slope * (double)(++steps);
        }
    }

    private void load(String filename) throws Exception {
        int lineNumber = 1;
        Scanner s = new Scanner(new File(filename));
        if (s.next().equals("timesteps")) {
            this.timesteps = s.nextInt();
        }
        this.frequencies = new double[this.numChannels][this.granularity * this.timesteps];
        this.amplitudes = new double[this.numChannels][this.granularity * this.timesteps];
        while (s.hasNext()) {
            if (!s.next().equals("channel")) {
                throw new RuntimeException("unexpected data, line " + lineNumber + ".");
            }
            int channelNumber = s.nextInt();
            if (!s.next().equals("@")) {
                throw new RuntimeException("unexpected data, line " + lineNumber + ".");
            }
            int time = s.nextInt();
            s.next();
            double freq = s.nextInt();
            s.next();
            double amplitude = 100.0;
            if (s.hasNext()) {
                amplitude = s.nextInt();
            }
            System.err.println("c=" + channelNumber + " t=" + time + " freq=" + freq + " ampl=" + amplitude);
            this.frequencies[channelNumber][time / this.granularity] = freq;
            this.amplitudes[channelNumber][time / this.granularity] = amplitude;
        }
    }

    public static void main(String[] args) throws Exception {
        String dummyFrame = "1000 70 497 0 739 0 2772 0 3364 0 4170 0 4000 0 0 0 200 40  0 40  0 20  0  0 53 44 79 70 52 95 44 56 34 80  0 80  0  0 27 0";
        frame = FormantScheduler.explodeToInts(dummyFrame, " ");
        if (args.length == 0) {
            System.err.println("Pass filename as first argument");
            System.exit(1);
        }
        new FormantScheduler().process(args[0]);
    }

    public static int[] explodeToInts(String s, String delim) {
        StringTokenizer t = new StringTokenizer(s, delim);
        int[] result = new int[t.countTokens()];
        Scanner sc = new Scanner(s);
        int i = 0;
        while (sc.hasNextInt()) {
            result[i] = sc.nextInt();
            ++i;
        }
        return result;
    }

    public static String implode(int[] a) {
        String result = "";
        for (int i = 0; i < a.length; ++i) {
            result = result + a[i] + " ";
        }
        return result;
    }
}

