/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.neuralnet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.pakl.neuralnet.Stopwatch;
import net.pakl.neuralnet.VoiceTrainer;

public class VoiceTrainerWordRecognizer
extends VoiceTrainer {
    public static String CONFIGURATION_FILE = "wordrecognizer.prop";

    public static void main(String[] args) throws Exception {
        VoiceTrainerWordRecognizer vt = new VoiceTrainerWordRecognizer();
        vt.loadProperties(CONFIGURATION_FILE);
        System.out.println("run()");
        vt.run();
        System.out.println("runProbes()");
        vt.runProbes();
    }

    public void runProbes() throws Exception {
        List soundPatternsInput = this.readSoundPatterns(this.stringToList(this.probeList), true);
        List soundPatternsOutput = this.readSoundPatterns(this.stringToList(this.probeList), false);
        this.probe(this.probeList, soundPatternsInput, soundPatternsOutput);
    }

    public void showProperties() {
        super.showProperties();
        System.out.println("outputCodeList    = " + this.outputCodeList);
    }

    private List repeatOutputForInputDuration(List inputs, List shortOutputs) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < inputs.size(); ++i) {
            List sequence = (List)inputs.get(i);
            double[] outputPattern = (double[])((List)shortOutputs.get(i)).get(0);
            Iterator j = sequence.iterator();
            ArrayList<double[]> extendedSequence = new ArrayList<double[]>();
            while (j.hasNext()) {
                j.next();
                extendedSequence.add(outputPattern);
            }
            result.add(extendedSequence);
            System.out.println("Output pattern #" + i + " extended to " + extendedSequence.size() + " timesteps.");
        }
        return result;
    }

    public void run() throws Exception {
        System.out.println("Load inputs " + this.inputList);
        List soundPatternsInput = this.readSoundPatterns(this.stringToList(this.inputList), true);
        System.out.println("Load outputs " + this.outputCodeList);
        List outputsTemp = this.readSoundPatterns(this.stringToList(this.outputCodeList), false);
        System.out.println("Temporally spread outputs");
        List outputCodeList = this.repeatOutputForInputDuration(soundPatternsInput, outputsTemp);
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.setTotalItems(this.trials);
        for (int i = 0; i < this.trials; ++i) {
            System.out.print("Training Trial " + (i + 1) + " of " + this.trials + "\n");
            stopwatch.start();
            this.train(soundPatternsInput, outputCodeList);
            stopwatch.stop();
            System.out.println(stopwatch.getResult() + " " + stopwatch.estimate());
            if (this.saveEvery > 0 && i % this.saveEvery == 0) {
                new ObjectOutputStream(new FileOutputStream(this.srnaToSave + "-" + i)).writeObject(this.srna);
            }
            if (this.receivedEndRunMessage()) break;
        }
        if (!this.srnaToSave.equals("")) {
            new ObjectOutputStream(new FileOutputStream(this.srnaToSave)).writeObject(this.srna);
        }
        this.recordInputsAndOutputs(soundPatternsInput);
    }

    private boolean receivedEndRunMessage() {
        File f = new File("endrun.msg");
        if (f.exists()) {
            System.out.println("File endrun.msg exists, stopping run.");
            return true;
        }
        return false;
    }
}

