/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.neuralnet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import net.pakl.neuralnet.SimpleRecurrentNet;
import net.pakl.neuralnet.SimpleRecurrentNetAverager;
import net.pakl.neuralnet.Stopwatch;
import net.pakl.neuralnet.VectorComparer;

public class VoiceTrainer {
    public static String CONFIGURATION_FILE = "voicetrainer.prop";
    public static final String VERSION_NUMBER = "3.3(randomSeed/dont-recenter-inputs-only-feedback/feedforward-in-drive)";
    SimpleRecurrentNetAverager srna;
    int hiddenUnitsPerInputVector = 50;
    int stutterTimeSteps = 1;
    int batchesPerTrial = 1;
    String inputList = "badra.txt";
    String outputCodeList = "";
    String probeList = "badra.txt";
    String srnaToLoad = "";
    String srnaToSave = "srna-out.obj";
    boolean enableBatchUpdate = false;
    boolean clearContextUnits = false;
    boolean normalizeInputs = true;
    boolean divideByMaxInputs = false;
    int saveEvery = 0;
    public int predictionDelay = 1;
    int inputPatternWidth;
    int outputPatternWidth = this.inputPatternWidth = 50;
    int trials = 100;
    boolean restrictedFeedforward = false;
    int numInputCopies = 3;
    double preserveFactor = 0.0;
    double learningRate = 0.01;
    double momentumTerm = 0.01;
    long randomSeed = 123L;
    double initialRandomWeightFactor = 0.01;
    boolean softClamping = false;
    double softClampingScalar = 0.5;
    double inputScaleFactor = 1.0;
    boolean clearSoftClampingFromInputs = true;
    boolean selectiveHardClamping = false;
    int hardClampStartUnit = 0;
    int hardClampCeaseUnit = 0;
    Random rng;

    public static void main(String[] args) throws Exception {
        VoiceTrainer vt = new VoiceTrainer();
        vt.loadProperties(CONFIGURATION_FILE);
        vt.run();
        vt.runProbes();
    }

    public void runProbes() throws Exception {
        System.out.println("runProbes()");
        List soundPatternsInput = this.readSoundPatterns(this.stringToList(this.probeList), true);
        List soundPatternsOutput = this.readSoundPatterns(this.stringToList(this.probeList), false);
        this.probe(this.probeList, soundPatternsInput, soundPatternsOutput);
    }

    public void run() throws Exception {
        List soundPatternsInput = this.readSoundPatterns(this.stringToList(this.inputList), true);
        List soundPatternsOutput = this.readSoundPatterns(this.stringToList(this.inputList), false);
        Stopwatch stopwatch = new Stopwatch();
        for (int i = 0; i < this.trials; ++i) {
            System.out.print("Training Trial " + (i + 1) + " of " + this.trials + "\n");
            stopwatch.start();
            this.train(soundPatternsInput, soundPatternsOutput);
            stopwatch.stop();
            System.out.println(stopwatch.getResult());
            if (this.saveEvery > 0 && i % this.saveEvery == 0) {
                new ObjectOutputStream(new FileOutputStream(this.srnaToSave + "-" + i)).writeObject(this.srna);
            }
            if (this.receivedEndRunMessage()) break;
        }
        if (!this.srnaToSave.equals("")) {
            new ObjectOutputStream(new FileOutputStream(this.srnaToSave)).writeObject(this.srna);
        }
        this.recordInputsAndOutputs(soundPatternsInput);
    }

    private boolean receivedEndRunMessage() {
        File f = new File("endrun.msg");
        if (f.exists()) {
            System.out.println("File endrun.msg exists, stopping run.");
            return true;
        }
        return false;
    }

    protected double[] replicateInputVector(double[] inputVector) {
        double[] result = new double[inputVector.length * this.numInputCopies];
        for (int i = 0; i < inputVector.length * this.numInputCopies; ++i) {
            result[i] = inputVector[i % inputVector.length];
        }
        return result;
    }

    public void train(List inputs, List outputs) {
        int i;
        this.rng = new Random(this.randomSeed);
        ArrayList<Triplet> triplets = new ArrayList<Triplet>();
        for (i = 0; i < inputs.size(); ++i) {
            triplets.add(new Triplet(new Integer(i), inputs.get(i), outputs.get(i)));
        }
        Collections.shuffle(triplets, this.rng);
        for (i = 0; i < triplets.size(); ++i) {
            System.out.print("Training sound pattern " + ((Triplet)triplets.get(i)).get1() + " ");
            List inputPattern = (List)((Triplet)triplets.get(i)).get2();
            List outputPattern = (List)((Triplet)triplets.get(i)).get3();
            int patternSize = ((double[])inputPattern.get(0)).length;
            double[] previouslyGeneratedOutput = new double[patternSize];
            for (int batchNum = 0; batchNum < this.batchesPerTrial; ++batchNum) {
                this.srna.clearSSEMeasure();
                if (this.clearContextUnits) {
                    this.srna.clearContextUnits();
                }
                if (this.clearSoftClampingFromInputs) {
                    previouslyGeneratedOutput = new double[patternSize];
                }
                this.srna.resetRunningAveragers();
                for (int j = 0; j < inputPattern.size() - this.predictionDelay; ++j) {
                    double[] forward = (double[])inputPattern.get(j);
                    double[] teacher = (double[])outputPattern.get(j + this.predictionDelay);
                    if (!this.softClamping) {
                        this.srna.feedforward(forward);
                    } else {
                        double[] clampedInput = this.vmul(this.softClampingScalar, forward);
                        double[] feedbackExcitation = this.vmul(1.0 - this.softClampingScalar, this.recenterOnZero(previouslyGeneratedOutput));
                        double[] softClampedInputPlusFeedback = this.vadd(clampedInput, feedbackExcitation);
                        double[] softClampedFeedforward = this.vmul(this.inputScaleFactor, softClampedInputPlusFeedback);
                        this.srna.feedforward(softClampedFeedforward);
                        previouslyGeneratedOutput = this.srna.getOutputLayerActivity();
                    }
                    this.srna.backpropogate(teacher);
                    this.srna.copyHiddenExcitationToContextUnits();
                }
                if (!this.enableBatchUpdate) continue;
                this.srna.batchUpdateWeights();
            }
            System.out.println("sse = " + this.srna.getSumSquaredError());
        }
    }

    protected double[] recenterOnZero(double[] pattern) {
        double[] result = this.vmul(2.0, this.vadd(-0.5, pattern));
        return result;
    }

    protected double[] scaleDown(double[] forward) {
        return this.vmul(1.0 - this.softClampingScalar, forward);
    }

    protected double[] vcomplement(double[] v) {
        double[] result = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            if (v[i] == 1.0) {
                result[i] = 0.0;
                continue;
            }
            if (v[i] == 0.0) {
                result[i] = 1.0;
                continue;
            }
            throw new RuntimeException("To use soft clamping, the original input vector must be binary.  Clearly it is not, as v[" + i + "] = " + v[i]);
        }
        return result;
    }

    protected double[] vadd(double s, double[] v) {
        double[] result = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            result[i] = s + v[i];
        }
        return result;
    }

    private int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    protected double[] vadd(double[] v1, double[] v2) {
        double[] result = new double[this.max(v1.length, v2.length)];
        int j = 0;
        int k = 0;
        for (int i = 0; i < this.max(v1.length, v2.length); ++i) {
            result[i] = v1[j] + v2[k];
            ++k;
            if (++j == v1.length) {
                j = 0;
            }
            if (k != v2.length) continue;
            k = 0;
        }
        return result;
    }

    protected double[] vmul(double scalar, double[] vector) {
        double[] result = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            result[i] = scalar * vector[i];
        }
        return result;
    }

    public void trainSequentially(List inputs, List outputs) {
        for (int i = 0; i < inputs.size(); ++i) {
            System.out.print("Training sound pattern " + i + " ");
            List inputPattern = (List)inputs.get(i);
            List outputPattern = (List)outputs.get(i);
            this.srna.clearSSEMeasure();
            if (this.clearContextUnits) {
                this.srna.clearContextUnits();
            }
            this.srna.resetRunningAveragers();
            for (int j = 0; j < inputPattern.size() - this.predictionDelay; ++j) {
                double[] forward = (double[])inputPattern.get(j);
                double[] backward = (double[])outputPattern.get(j + this.predictionDelay);
                this.srna.feedforward(forward);
                this.srna.backpropogate(backward);
                this.srna.copyHiddenExcitationToContextUnits();
            }
            System.out.println("sse = " + this.srna.getSumSquaredError());
        }
    }

    public void probe(String inputNames, List soundPatternsInput, List soundPatternsOutput) throws Exception {
        System.out.println("probe()");
        for (int i = 0; i < soundPatternsInput.size(); ++i) {
            List soundPatternInput = (List)soundPatternsInput.get(i);
            List soundPatternOutput = (List)soundPatternsOutput.get(i);
            BufferedWriter fullProbeOutputFile = new BufferedWriter(new FileWriter(this.stringToList(inputNames).get(i) + "-out-fullprobe.txt"));
            int fullProbe = soundPatternInput.size() - this.predictionDelay - 1;
            for (int driveUpTo = 0; driveUpTo < soundPatternInput.size() - this.predictionDelay; ++driveUpTo) {
                int j;
                BufferedWriter outputVectorFile = new BufferedWriter(new FileWriter(this.stringToList(inputNames).get(i) + "-out-drive-" + driveUpTo + ".txt"));
                BufferedWriter inputVectorFile = new BufferedWriter(new FileWriter(this.stringToList(inputNames).get(i) + "-in-drive-" + driveUpTo + ".txt"));
                if (this.clearContextUnits) {
                    this.srna.clearContextUnits();
                }
                this.srna.resetRunningAveragers();
                double[] previouslyGeneratedOutput = new double[((double[])soundPatternInput.get(0)).length];
                for (j = 0; j < driveUpTo; ++j) {
                    double[] forward = (double[])soundPatternInput.get(j);
                    if (!this.softClamping) {
                        this.srna.feedforward(forward);
                        inputVectorFile.write(this.vectorToText(forward));
                    } else {
                        double[] clampedInput = this.vmul(this.softClampingScalar, forward);
                        double[] feedbackExcitation = this.vmul(1.0 - this.softClampingScalar, this.recenterOnZero(previouslyGeneratedOutput));
                        double[] softClampedInputPlusFeedback = this.vadd(clampedInput, feedbackExcitation);
                        double[] softClampedFeedforward = this.vmul(this.inputScaleFactor, softClampedInputPlusFeedback);
                        inputVectorFile.write(this.vectorToText(softClampedFeedforward));
                        this.srna.feedforward(softClampedFeedforward);
                        previouslyGeneratedOutput = this.srna.getOutputLayerActivity();
                    }
                    outputVectorFile.write(this.vectorToText(this.srna.getOutputLayerActivity()));
                    if (driveUpTo == fullProbe) {
                        fullProbeOutputFile.write(this.vectorToText(this.srna.getOutputLayerActivity()));
                    }
                    this.srna.copyHiddenExcitationToContextUnits();
                }
                for (j = driveUpTo; j < soundPatternInput.size() - this.predictionDelay; ++j) {
                    this.srna.feedforward(this.replicateInputVector(this.srna.getOutputLayerActivity()));
                    inputVectorFile.write(this.vectorToText(this.replicateInputVector(this.srna.getOutputLayerActivity())));
                    outputVectorFile.write(this.vectorToText(this.srna.getOutputLayerActivity()));
                    this.srna.copyHiddenExcitationToContextUnits();
                    if (driveUpTo != fullProbe) continue;
                    fullProbeOutputFile.write(this.vectorToText(this.srna.getOutputLayerActivity()));
                }
                outputVectorFile.close();
                inputVectorFile.close();
            }
            fullProbeOutputFile.close();
        }
    }

    public void recordInputsAndOutputs(List soundPatterns) {
        System.out.println("recordInputsAndOutputs()");
        try {
            for (int i = 0; i < soundPatterns.size(); ++i) {
                System.out.print("Testing sound pattern " + i + " ");
                List soundPattern = (List)soundPatterns.get(i);
                this.srna.clearSSEMeasure();
                BufferedWriter inputVectorFile = new BufferedWriter(new FileWriter(this.stringToList(this.inputList).get(i) + "-in.txt"));
                BufferedWriter outputVectorFile = new BufferedWriter(new FileWriter(this.stringToList(this.inputList).get(i) + "-out.txt"));
                if (this.clearContextUnits) {
                    this.srna.clearContextUnits();
                }
                this.srna.resetRunningAveragers();
                double[] previouslyGeneratedOutput = new double[((double[])soundPattern.get(0)).length];
                for (int j = 0; j < soundPattern.size() - this.predictionDelay; ++j) {
                    double[] forward = (double[])soundPattern.get(j);
                    if (!this.softClamping) {
                        this.srna.feedforward(forward);
                        inputVectorFile.write(this.vectorToText(forward));
                    } else {
                        double[] clampedInput = this.vmul(this.softClampingScalar, forward);
                        double[] feedbackExcitation = this.vmul(1.0 - this.softClampingScalar, this.recenterOnZero(previouslyGeneratedOutput));
                        double[] softClampedInputPlusFeedback = this.vadd(clampedInput, feedbackExcitation);
                        double[] softClampedFeedforward = this.vmul(this.inputScaleFactor, softClampedInputPlusFeedback);
                        this.srna.feedforward(softClampedFeedforward);
                        inputVectorFile.write(this.vectorToText(softClampedFeedforward));
                        previouslyGeneratedOutput = this.srna.getOutputLayerActivity();
                    }
                    outputVectorFile.write(this.vectorToText(this.srna.getOutputLayerActivity()));
                    this.srna.copyHiddenExcitationToContextUnits();
                }
                System.out.println("sse = " + this.srna.getSumSquaredError());
                inputVectorFile.close();
                outputVectorFile.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println("Error -- could not write input and output vectors after training to disk.");
        }
    }

    protected String vectorToText(double[] a) {
        String result = "";
        for (int i = 0; i < a.length; ++i) {
            result = result + a[i] + " ";
        }
        return result + "\n";
    }

    public void loadProperties(String propertiesFile) throws Exception {
        Properties p = new Properties();
        p.load(new FileInputStream(propertiesFile));
        if (p.getProperty("numInputCopies") != null) {
            this.numInputCopies = new Integer(p.getProperty("numInputCopies"));
        }
        if (this.numInputCopies < 1) {
            throw new RuntimeException("You must have at least 1 input copy to achieve learning.");
        }
        if (p.getProperty("batchesPerTrial") != null) {
            this.batchesPerTrial = new Integer(p.getProperty("batchesPerTrial"));
        }
        if (p.getProperty("inputList") != null) {
            this.inputList = p.getProperty("inputList");
        }
        if (p.getProperty("outputCodeList") != null) {
            this.outputCodeList = p.getProperty("outputCodeList");
        }
        if (p.getProperty("clearContextUnits") != null) {
            this.clearContextUnits = p.getProperty("clearContextUnits").equalsIgnoreCase("true");
        }
        if (p.getProperty("probeList") != null) {
            this.probeList = p.getProperty("probeList");
        }
        if (p.getProperty("trials") != null) {
            this.trials = new Integer(p.getProperty("trials"));
        }
        if (p.getProperty("predictionDelay") != null) {
            this.predictionDelay = new Integer(p.getProperty("predictionDelay"));
        }
        if (p.getProperty("inputPatternWidth") != null) {
            this.outputPatternWidth = this.inputPatternWidth = new Integer(p.getProperty("inputPatternWidth")).intValue();
        }
        if (p.getProperty("stutterTimeSteps") != null) {
            this.stutterTimeSteps = new Integer(p.getProperty("stutterTimeSteps"));
        }
        if (p.getProperty("outputPatternWidth") != null) {
            if (this.getClass() == VoiceTrainer.class) {
                System.err.println("Warning -- for VoiceTrainer, outputPatternWidth should usually not be set -- it defaults to the inputPatternWidth.  Subclasses may override this, however.");
            }
            this.outputPatternWidth = new Integer(p.getProperty("outputPatternWidth"));
        }
        if (p.getProperty("hiddenPerUnit") != null) {
            this.hiddenUnitsPerInputVector = new Integer(p.getProperty("hiddenPerUnit"));
        }
        if (p.getProperty("randomSeed") != null) {
            this.randomSeed = new Integer(p.getProperty("randomSeed")).intValue();
        }
        int numNeurons = this.numInputCopies * this.inputPatternWidth + this.numInputCopies * this.hiddenUnitsPerInputVector + this.outputPatternWidth;
        int[] layerBreaks = new int[]{this.numInputCopies * this.inputPatternWidth, this.numInputCopies * this.inputPatternWidth + this.numInputCopies * this.hiddenUnitsPerInputVector, this.numInputCopies * this.inputPatternWidth + this.numInputCopies * this.hiddenUnitsPerInputVector + this.outputPatternWidth};
        if (p.getProperty("learningRate") != null) {
            this.learningRate = new Double(p.getProperty("learningRate"));
        }
        if (p.getProperty("initialRandomWeightFactor") != null) {
            this.initialRandomWeightFactor = new Double(p.getProperty("initialRandomWeightFactor"));
        }
        if (p.getProperty("momentumTerm") != null) {
            this.momentumTerm = new Double(p.getProperty("momentumTerm"));
        }
        if (p.getProperty("softClampingScalar") != null) {
            this.softClampingScalar = new Double(p.getProperty("softClampingScalar"));
        }
        if (p.getProperty("inputScaleFactor") != null) {
            this.inputScaleFactor = new Double(p.getProperty("inputScaleFactor"));
        }
        if (p.getProperty("softClamping") != null) {
            this.softClamping = !p.getProperty("softClamping").equals("false");
        }
        if (p.getProperty("normalizeInputs") != null) {
            this.normalizeInputs = p.getProperty("normalizeInputs").equalsIgnoreCase("true");
        }
        if (p.getProperty("divideByMaxInputs") != null) {
            if (p.getProperty("divideByMaxInputs").equalsIgnoreCase("true")) {
                this.divideByMaxInputs = true;
                if (this.normalizeInputs) {
                    System.out.println("NormalizeInputs was true, setting to false because divideByMaxInputs=true.");
                    this.normalizeInputs = false;
                }
            } else {
                this.divideByMaxInputs = false;
            }
        }
        if (this.softClamping && this.normalizeInputs) {
            throw new RuntimeException("To use true softclamping, the inputs must be boolean vectors.  Make normalizeInputs == false");
        }
        if (p.getProperty("clearSoftClampingFromInputs") != null) {
            this.clearSoftClampingFromInputs = !p.getProperty("clearSoftClampingFromInputs").equals("false");
        }
        if (p.getProperty("preserveFactor") != null) {
            this.preserveFactor = new Double(p.getProperty("preserveFactor"));
        }
        if (p.getProperty("enableBatchUpdate") != null) {
            this.enableBatchUpdate = p.getProperty("enableBatchUpdate").equalsIgnoreCase("true");
        }
        if (p.getProperty("restrictedFeedforward") != null) {
            this.restrictedFeedforward = p.getProperty("restrictedFeedforward").equalsIgnoreCase("true");
        }
        if (p.getProperty("srnaToLoad") != null) {
            this.srnaToLoad = p.getProperty("srnaToLoad");
        }
        if (p.getProperty("srnaToSave") != null) {
            this.srnaToSave = p.getProperty("srnaToSave");
        }
        if (p.getProperty("saveEvery") != null) {
            this.saveEvery = new Integer(p.getProperty("saveEvery"));
        }
        if (this.srnaToLoad.equals("")) {
            this.srna = new SimpleRecurrentNetAverager(this.randomSeed, numNeurons, this.learningRate, this.momentumTerm, layerBreaks, this.initialRandomWeightFactor);
            this.srna.setBatchUpdate(this.enableBatchUpdate);
        } else {
            this.srna = (SimpleRecurrentNetAverager)new ObjectInputStream(new FileInputStream(this.srnaToLoad)).readObject();
            System.out.println("Network loaded, setting parameters from current file.");
            this.srna.setLearningRate(this.learningRate);
            this.srna.setMomentumTerm(this.momentumTerm);
        }
        if (this.restrictedFeedforward) {
            this.pruneInputToHidden(this.srna);
        }
        this.configureAveragerProperties(this.srna);
        this.showProperties();
    }

    protected void pruneInputToHidden(SimpleRecurrentNet srn) {
        for (int inputGroup = 0; inputGroup < this.numInputCopies; ++inputGroup) {
            for (int hiddenGroup = 0; hiddenGroup < this.numInputCopies; ++hiddenGroup) {
                if (inputGroup == hiddenGroup) continue;
                for (int pre = inputGroup * this.inputPatternWidth; pre < (inputGroup + 1) * this.inputPatternWidth; ++pre) {
                    for (int post = hiddenGroup * this.hiddenUnitsPerInputVector; post < (hiddenGroup + 1) * this.hiddenUnitsPerInputVector; ++post) {
                        srn.disconnect(pre, post);
                    }
                }
            }
        }
    }

    protected void showProperties() {
        System.out.println("VoiceTrainer SRN Version 3.3(randomSeed/dont-recenter-inputs-only-feedback/feedforward-in-drive)");
        System.out.println("srnaToLoad        = " + this.srnaToLoad);
        System.out.println("srnaToSave        = " + this.srnaToSave);
        System.out.println("learningRate      = " + this.learningRate);
        System.out.println("momentumTerm      = " + this.momentumTerm);
        System.out.println("randomSeed        = " + this.randomSeed);
        System.out.println("predictionDelay   = " + this.predictionDelay);
        System.out.println("preserveFactor    = " + this.preserveFactor);
        System.out.println("numInputCopies    = " + this.numInputCopies);
        System.out.println("inputPatternWidth = " + this.inputPatternWidth);
        System.out.println("batchesPerTrial   = " + this.batchesPerTrial);
        System.out.println("hiddenPerUnit     = " + this.hiddenUnitsPerInputVector);
        System.out.println("restrictedFeedforward = " + this.restrictedFeedforward);
        System.out.println("trials            = " + this.trials);
        System.out.println("inputList         = " + this.inputList);
        System.out.println("probeList         = " + this.probeList);
        System.out.println("clearContextUnits = " + this.clearContextUnits);
        System.out.println("softClampingScalar = " + this.softClampingScalar);
        System.out.println("softClamping = " + this.softClamping);
        System.out.println("inputScaleFactor = " + this.inputScaleFactor);
        System.out.println("initialRandomWeightFactor = " + this.initialRandomWeightFactor);
    }

    void configureAveragerProperties(SimpleRecurrentNetAverager srna) {
        int i;
        for (i = 1; i < this.numInputCopies; ++i) {
            for (int neuron = i * this.inputPatternWidth; neuron < (i + 1) * this.inputPatternWidth; ++neuron) {
                srna.setPreserveFactor(neuron, this.getPreserveFactorForCopy(i));
                System.out.println("Neuron " + neuron + " preserve = " + this.getPreserveFactorForCopy(i));
            }
        }
        for (i = 1; i < this.numInputCopies; ++i) {
            int hiddenNeuronStart = this.inputPatternWidth * this.numInputCopies + i * this.hiddenUnitsPerInputVector;
            int hiddenNeuronCease = hiddenNeuronStart + this.hiddenUnitsPerInputVector;
            for (int neuron = hiddenNeuronStart; neuron < hiddenNeuronCease; ++neuron) {
                srna.setPreserveFactor(neuron, this.getPreserveFactorForCopy(i));
                System.out.println("Hidden neuron " + neuron + " preserve = " + this.getPreserveFactorForCopy(i));
            }
        }
    }

    protected double getPreserveFactorForCopy(int copyNumber) {
        if (copyNumber == 0) {
            return 0.0;
        }
        return Math.pow(this.preserveFactor, copyNumber);
    }

    protected List readSoundPatterns(List filenames, boolean replicateFlag) {
        ArrayList<List> result = new ArrayList<List>();
        Iterator i = filenames.iterator();
        while (i.hasNext()) {
            result.add(this.readSoundPattern((String)i.next(), replicateFlag));
        }
        return result;
    }

    protected List readSoundPattern(String filename, boolean replicateFlag) {
        try {
            ArrayList<double[]> result = new ArrayList<double[]>();
            BufferedReader f = new BufferedReader(new FileReader(filename));
            while (f.ready()) {
                try {
                    String s = f.readLine();
                    StringTokenizer t = new StringTokenizer(s, " ", false);
                    double[] timestep = this.tokenizerToDoubles(t);
                    if (this.normalizeInputs) {
                        timestep = VectorComparer.normalize(timestep);
                    }
                    if (this.divideByMaxInputs) {
                        timestep = this.divideByMaxInputs(timestep);
                    }
                    for (int stutter = 0; stutter < this.stutterTimeSteps; ++stutter) {
                        if (replicateFlag) {
                            result.add(this.replicateInputVector(timestep));
                            continue;
                        }
                        result.add(timestep);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception occured while processing file " + filename + ":\n" + e.getMessage());
                }
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not read sound pattern file " + filename + " for processing.");
        }
    }

    protected double[] divideByMaxInputs(double[] v) {
        int i;
        double[] result = new double[v.length];
        double max = v[0];
        for (i = 1; i < v.length; ++i) {
            if (!(v[i] > max)) continue;
            max = v[i];
        }
        for (i = 0; i < v.length; ++i) {
            result[i] = v[i] / max;
        }
        return result;
    }

    protected double[] tokenizerToDoubles(StringTokenizer t) {
        if (t.countTokens() != this.inputPatternWidth && t.countTokens() != this.outputPatternWidth) {
            throw new RuntimeException("Error: inputPatternWidth=" + this.inputPatternWidth + ", outputPatternWidth = " + this.outputPatternWidth + " but found " + t.countTokens() + " values in an input vector.");
        }
        double[] result = new double[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            result[i] = new Double(t.nextToken());
            ++i;
        }
        return result;
    }

    protected List stringToList(String passed) {
        ArrayList<String> result = new ArrayList<String>();
        String s = new String(passed);
        if (!s.endsWith(" ")) {
            s = s + " ";
        }
        StringTokenizer t = new StringTokenizer(s, " ", false);
        while (t.hasMoreTokens()) {
            result.add(t.nextToken());
        }
        return result;
    }

    class Triplet {
        private Object a;
        private Object b;
        private Object c;

        public Triplet(Object a, Object b, Object c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public Object get1() {
            return this.a;
        }

        public Object get2() {
            return this.b;
        }

        public Object get3() {
            return this.c;
        }
    }
}

