/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.neuralnet;

import java.util.List;

public class VectorComparer {
    public static double[] normalize(double[] a) {
        double[] result = new double[a.length];
        double vectorLength = Math.sqrt(VectorComparer.dot(a, a));
        if (vectorLength == 0.0) {
            return a;
        }
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] / vectorLength;
        }
        return result;
    }

    public static double normalizedDotProduct(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException("Vectors to compare must be the same size.");
        }
        double aSumSquared = VectorComparer.dot(VectorComparer.absVector(a), VectorComparer.absVector(a));
        double bSumSquared = VectorComparer.dot(VectorComparer.absVector(b), VectorComparer.absVector(b));
        double result = VectorComparer.dot(a, b) / Math.sqrt(aSumSquared * bSumSquared);
        return result;
    }

    private static double[] absVector(double[] a) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = Math.abs(a[i]);
        }
        return result;
    }

    private static double dot(double[] a, double[] b) {
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i] * b[i];
        }
        return result;
    }

    private static double sum(double[] a) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public static void main(String[] args) {
        double[] a1 = new double[]{0.1, 0.1, 0.1, 0.1};
        double[] a2 = new double[]{0.2, 0.2, 0.2, 0.2};
        double[] a3 = new double[]{0.1, 0.3, 0.1, 0.3};
        System.out.println(VectorComparer.normalizedDotProduct(a1, a2));
        System.out.println(VectorComparer.normalizedDotProduct(a1, a1));
        System.out.println(VectorComparer.normalizedDotProduct(a1, a3));
        System.out.println(VectorComparer.normalizedDotProduct(a2, a3));
    }

    public static void showVectorsInList(List doubleVectors) {
        for (int i = 0; i < doubleVectors.size(); ++i) {
            VectorComparer.showVector((double[])doubleVectors.get(i));
            System.out.println("");
        }
    }

    public static void showVector(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i] + " ");
        }
    }
}

