/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.neuralnet;

import java.io.Serializable;
import net.pakl.neuralnet.SimpleRecurrentNet;

public class SimpleRecurrentNetAverager
extends SimpleRecurrentNet
implements Serializable {
    double[] preserveFactor;
    double[] previousNetInput;

    public SimpleRecurrentNetAverager(long randomSeed, int numNeurons, double learningRate, double momentumTerm, int[] layerBreaks) {
        super(randomSeed, numNeurons, learningRate, momentumTerm, layerBreaks);
        this.preserveFactor = new double[this.numNeurons];
        this.previousNetInput = new double[this.numNeurons];
        System.out.println("SRN-Averager 20060929-01");
    }

    public SimpleRecurrentNetAverager(long randomSeed, int numNeurons, double learningRate, double momentumTerm, int[] layerBreaks, double initialRandomWeightFactor) {
        super(randomSeed, numNeurons, learningRate, momentumTerm, layerBreaks, initialRandomWeightFactor);
        this.preserveFactor = new double[this.numNeurons];
        this.previousNetInput = new double[this.numNeurons];
        System.out.println("SRN-Averager 20060929-01");
    }

    public void setPreserveFactor(int neuron, double newFactor) {
        this.preserveFactor[neuron] = newFactor;
    }

    public String getTextRepresentation() {
        String result = "";
        result = result + " There are " + this.numContextNeurons + " context neurons.\n";
        result = result + " There are 0 bias neurons.";
        for (int i = 0; i < this.numNeurons; ++i) {
            for (int j = 0; j < this.layerBreaks.length; ++j) {
                if (this.layerBreaks[j] != i) continue;
                result = result + "\n";
            }
            result = i < 0 ? result + "B" : (i < this.numContextNeurons + 0 ? result + "C" : result + "N");
            result = result + "(" + this.preserveFactor[i] + ") ";
        }
        return result;
    }

    public void resetRunningAveragers() {
        for (int i = 0; i < this.numNeurons; ++i) {
            this.previousNetInput[i] = 0.0;
        }
    }

    public void feedforward(double[] inputPattern) {
        int i;
        for (i = 0; i < this.numNeurons; ++i) {
            this.previousNetInput[i] = this.netInput[i];
        }
        for (i = 0; i < 0; ++i) {
            this.netInput[i] = 0.0;
        }
        int inputPatternIndex = 0;
        for (int post = 0 + this.numContextNeurons; post < this.numNeurons; ++post) {
            this.netInput[post] = 0.0;
            if (inputPatternIndex < inputPattern.length) {
                int n = post;
                this.netInput[n] = this.netInput[n] + ((1.0 - this.preserveFactor[post]) * inputPattern[inputPatternIndex] + this.preserveFactor[post] * this.previousNetInput[post]);
                this.activity[post] = this.netInput[post];
            } else {
                for (int pre = 0; pre < post; ++pre) {
                    if (!this.connected[pre][post]) continue;
                    this.netInput[post] = this.netInput[post] + this.weight[pre][post] * this.activity[pre];
                }
                this.activity[post] = this.sigmoid(this.netInput[post]);
            }
            ++inputPatternIndex;
        }
    }
}

