/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.neuralnet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import net.pakl.neuralnet.Perceptron;

public class PerceptronTrainer {
    Perceptron net;
    List inputs = new ArrayList();
    List outputs = new ArrayList();
    String inputsFileName = "inputs.txt";
    String outputsFileName = "outputs.txt";
    ArrayList items = new ArrayList();
    int trials;
    int inputLayer;
    int hiddenLayer;
    int secondHiddenLayer;
    int outputLayer;
    int numBiasNeurons = 1;
    Random rng;
    int randomSeed;

    public PerceptronTrainer() {
        try {
            this.getProperties();
            this.rng = new Random(this.randomSeed);
            this.loadPatterns();
            for (int j = 0; j < this.inputs.size(); ++j) {
                this.items.add(new Triplet(new Integer(j), this.inputs.get(j), this.outputs.get(j)));
            }
            this.run();
        }
        catch (Exception e) {
            System.out.println("An error occured, sorry. " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void loadPatterns() throws Exception {
        this.inputs = this.loadListFromFile(this.inputsFileName);
        this.outputs = this.loadListFromFile(this.outputsFileName);
    }

    public List loadListFromFile(String filename) throws Exception {
        ArrayList<double[]> result = new ArrayList<double[]>();
        BufferedReader f1 = new BufferedReader(new FileReader(filename));
        while (f1.ready()) {
            String datafilename = f1.readLine();
            BufferedReader f2 = new BufferedReader(new FileReader(datafilename));
            String data = f2.readLine();
            StringTokenizer t = new StringTokenizer(data, " ", false);
            double[] item = this.tokenizerToDoubles(t);
            result.add(item);
            f2.close();
        }
        f1.close();
        return result;
    }

    public void run() throws Exception {
        this.train();
        this.test();
        System.out.println("Writing neural network to output.obj");
        new ObjectOutputStream(new FileOutputStream("output.obj")).writeObject(this.net);
    }

    public void test() {
        this.showOutputLayerActivities();
        System.out.println("Hidden layer activities.");
        for (int i = 0; i < this.inputs.size(); ++i) {
            this.net.feedforward((double[])this.inputs.get(i));
            for (int j = this.inputLayer; j < this.inputLayer + this.hiddenLayer; ++j) {
                System.out.print(this.net.getActivity(j) + " ");
            }
            System.out.println("");
        }
        System.out.println(this.net.getGraphviz(0.1, 1.0));
    }

    public void showOutputLayerActivities() {
        int firstOutputNeuron = this.net.getNumNeurons() - this.outputLayer - 1;
        System.out.println("Output layer activities.");
        for (int i = 0; i < this.inputs.size(); ++i) {
            this.net.feedforward((double[])this.inputs.get(i));
            for (int j = 0; j < this.outputLayer; ++j) {
                System.out.print(this.net.getActivity(firstOutputNeuron + j) + "\t");
            }
            System.out.println("");
        }
    }

    public void train() {
        Collections.shuffle(this.items, this.rng);
        for (int i = 0; i < this.trials; ++i) {
            if (i % 1000 == 0) {
                System.out.print("Trial " + i + " ");
            }
            for (int j = 0; j < this.inputs.size(); ++j) {
                this.net.feedforward((double[])((Triplet)this.items.get(j)).get2());
                this.net.backpropogate((double[])((Triplet)this.items.get(j)).get3());
                if (i % 1000 != 0) continue;
                System.out.printf("%.3f ", this.net.getSumSquaredError());
            }
            if (i % 1000 != 0) continue;
            System.out.println("");
        }
    }

    public void getProperties() throws Exception {
        System.out.println("Loading properties from perceptrontrainer.prop.");
        Properties p = new Properties();
        p.load(new FileInputStream("perceptrontrainer.prop"));
        System.out.println("Loading inputLayer size...");
        this.inputLayer = new Integer(p.getProperty("inputLayer"));
        System.out.println("hiddenLayer");
        this.hiddenLayer = new Integer(p.getProperty("hiddenLayer"));
        System.out.println("outputLayer");
        this.outputLayer = new Integer(p.getProperty("outputLayer"));
        int[] layerBreaks = null;
        System.out.println("trials");
        this.trials = new Integer(p.getProperty("trials"));
        System.out.println("randomSeed");
        this.randomSeed = new Integer(p.getProperty("randomSeed"));
        System.out.println("learningRate and momentumTerm");
        if (p.getProperty("numBiasNeurons") != null) {
            this.numBiasNeurons = new Integer(p.getProperty("numBiasNeurons"));
        }
        if (p.getProperty("secondHiddenLayer") != null) {
            this.secondHiddenLayer = new Integer(p.getProperty("secondHiddenLayer"));
            layerBreaks = new int[]{this.inputLayer, this.inputLayer + this.hiddenLayer, this.inputLayer + this.hiddenLayer + this.secondHiddenLayer, this.inputLayer + this.hiddenLayer + this.secondHiddenLayer + this.outputLayer};
            this.net = new Perceptron(this.randomSeed, this.inputLayer + this.hiddenLayer + this.secondHiddenLayer + this.outputLayer, new Double(p.getProperty("learningRate")), new Double(p.getProperty("momentumTerm")), layerBreaks, this.numBiasNeurons);
        } else {
            layerBreaks = new int[]{this.inputLayer, this.inputLayer + this.hiddenLayer, this.inputLayer + this.hiddenLayer + this.outputLayer};
            this.net = new Perceptron(this.randomSeed, this.inputLayer + this.hiddenLayer + this.outputLayer, new Double(p.getProperty("learningRate")), new Double(p.getProperty("momentumTerm")), layerBreaks, this.numBiasNeurons);
        }
        System.out.print("Layer breaks: ");
        for (int i = 0; i < layerBreaks.length; ++i) {
            System.out.print(layerBreaks[i] + " ");
        }
        System.out.println("");
        if (p.getProperty("randomInitialScale") != null) {
            double initialRandomScale = new Double(p.getProperty("randomInitialScale"));
            this.net.reinitializeRandomWeightsWith(initialRandomScale);
        }
        if (new File("input.obj").exists()) {
            System.out.println("Loading perceptron from input.obj file.");
            this.net = (Perceptron)new ObjectInputStream(new FileInputStream("input.obj")).readObject();
        } else {
            System.out.println("No input.obj perceptron to load in.");
        }
    }

    protected double[] tokenizerToDoubles(StringTokenizer t) {
        double[] result = new double[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            result[i] = new Double(t.nextToken());
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        PerceptronTrainer trainer = new PerceptronTrainer();
    }

    class Triplet {
        private Object a;
        private Object b;
        private Object c;

        public Triplet(Object a, Object b, Object c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public Object get1() {
            return this.a;
        }

        public Object get2() {
            return this.b;
        }

        public Object get3() {
            return this.c;
        }
    }
}

