/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.neuralnet;

import net.pakl.neuralnet.Perceptron;
import net.pakl.neuralnet.VectorComparer;

public class PerceptronTest {
    public static void main(String[] args) {
        double[][] inputs = new double[][]{{0.1, 0.2, 0.3}, {0.3, 0.4, 0.5}, {0.6, 0.7, 0.8}};
        double[][] outputs = new double[][]{{0.1, 0.3, 0.5}, {0.2, 0.4, 0.6}, {0.4, 0.7, 0.9}};
        double learningRate = 0.05;
        double momentumTerm = 0.0;
        int[] layerBreaks = new int[]{3, 5, 8};
        Perceptron net = new Perceptron(123456L, 8, learningRate, momentumTerm, layerBreaks);
        PerceptronTest.trainNetwork(net, inputs, outputs, 55000);
        PerceptronTest.testNetwork(net, inputs, outputs);
    }

    private static void trainNetwork(Perceptron net, double[][] inputList, double[][] targetOutputList, int trials) {
        for (int i = 0; i < trials; ++i) {
            for (int j = 0; j < inputList.length; ++j) {
                net.feedforward(inputList[j]);
                net.backpropogate(targetOutputList[j]);
            }
            if (i % 1000 != 0) continue;
            System.out.println("Training trial " + i + " Total Error: " + net.getTotalError());
        }
    }

    private static void testNetwork(Perceptron net, double[][] inputList, double[][] expectedOutputList) {
        for (int j = 0; j < inputList.length; ++j) {
            net.feedforward(inputList[j]);
            System.out.print("goal : ");
            PerceptronTest.showVector(expectedOutputList[j]);
            System.out.print("net  : ");
            PerceptronTest.showOutput(net);
            System.out.println("\nNormalized Dot = " + VectorComparer.normalizedDotProduct(expectedOutputList[j], PerceptronTest.getOutput(net)));
        }
    }

    private static double[] getOutput(Perceptron net) {
        double[] result = new double[3];
        for (int i = 5; i < 8; ++i) {
            result[i - 5] = net.getActivity(i);
        }
        return result;
    }

    private static void showVector(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i] + " ");
        }
    }

    private static void showOutput(Perceptron net) {
        for (int i = 5; i < 8; ++i) {
            System.out.print(net.getActivity(i) + " ");
        }
    }
}

