/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.neuralnet;

import net.pakl.neuralnet.Perceptron;

public class PerceptronPatrykThesis
extends Perceptron {
    int numUnitsBeforeContextUnits;
    int numContextUnits;

    public PerceptronPatrykThesis(long randomSeed, int numInputUnits, int numContextUnits, int numHiddenUnits, double learningRate, double momentumTerm) {
        int[] layerBreaks = new int[]{numInputUnits + numContextUnits, numInputUnits + numContextUnits + numHiddenUnits, numInputUnits + numContextUnits + numHiddenUnits + 1};
        NUM_BIAS_NEURONS = 1;
        this.numContextUnits = numContextUnits;
        this.numUnitsBeforeContextUnits = NUM_BIAS_NEURONS + numInputUnits;
        this.constructPerceptron(randomSeed, numInputUnits + numContextUnits + numHiddenUnits + 1, learningRate, momentumTerm, layerBreaks);
    }

    protected double sigmoid(double x) {
        return 2.0 / (1.0 + Math.exp(-2.0 * x)) - 1.0;
    }

    protected double sigmoidDerivative(double x) {
        return 1.0 - Math.pow(this.sigmoid(x), 2.0);
    }

    public double[][] getOutputDerivativeAgainstWeights() {
        return this.getOutputNetInputDerivativeAgainstWeights();
    }

    public double[][] getOutputNetInputDerivativeAgainstWeights() {
        double[][] derivative = new double[this.numNeurons][this.numNeurons];
        for (int post = 0; post < this.numNeurons; ++post) {
            for (int pre = 0; pre < this.numNeurons; ++pre) {
                if (this.inLayer(1, pre)) {
                    int hidden = pre;
                    int output = post;
                    derivative[hidden][output] = this.activity[hidden];
                }
                if (!this.inLayer(0, pre)) continue;
                int input = pre;
                int hidden = post;
                int output = this.getNumNeurons() - 1;
                derivative[input][hidden] = this.weight[hidden][output] * this.sigmoidDerivative(this.netInput[hidden]) * this.activity[input];
            }
        }
        return derivative;
    }

    public void copyHiddenExcitationToContextUnits() {
        int hiddenLayerIndex = this.layerBreaks[0];
        for (int contextUnit = this.numUnitsBeforeContextUnits; contextUnit < this.numContextUnits; ++contextUnit) {
            this.activity[contextUnit] = this.activity[hiddenLayerIndex];
            ++hiddenLayerIndex;
        }
    }

    public void clearContextUnits() {
        for (int contextUnit = this.numUnitsBeforeContextUnits; contextUnit < this.numContextUnits; ++contextUnit) {
            this.activity[contextUnit] = 0.0;
        }
    }
}

