/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.neuralnet;

import java.io.Serializable;
import java.util.Random;

public class Perceptron
implements Serializable {
    Random randomNumberGenerator;
    int numNeurons;
    public double learningRate;
    double momentumTerm;
    double[] activity;
    double[] netInput;
    protected double[][] weight;
    boolean[][] connected;
    int[] layerBreaks;
    public static int NUM_BIAS_NEURONS = 1;
    public static final double BIAS_ACTIVATION = -1.0;
    double[][] previousDeltaWij;
    double randomInitialScale = 1.0;
    private double totalError;
    double sumSquaredError;

    public int getNumNeurons() {
        return this.numNeurons;
    }

    public Perceptron() {
    }

    public Perceptron(long randomSeed, int numNeurons, double learningRate, double momentumTerm, int[] layerBreaks) {
        this.constructPerceptron(randomSeed, numNeurons, learningRate, momentumTerm, layerBreaks);
    }

    public Perceptron(long randomSeed, int numNeurons, double learningRate, double momentumTerm, int[] layerBreaks, int new_NUM_BIAS_NEURONS) {
        System.out.println("Note: Number of BIAS Neurons manually changed from default of " + NUM_BIAS_NEURONS + " to " + new_NUM_BIAS_NEURONS);
        NUM_BIAS_NEURONS = new_NUM_BIAS_NEURONS;
        this.constructPerceptron(randomSeed, numNeurons, learningRate, momentumTerm, layerBreaks);
    }

    protected void constructPerceptron(long randomSeed, int numNeurons, double learningRate, double momentumTerm, int[] layerBreaks) {
        this.randomNumberGenerator = new Random(randomSeed);
        this.activity = new double[numNeurons + NUM_BIAS_NEURONS];
        this.netInput = new double[numNeurons + NUM_BIAS_NEURONS];
        this.weight = new double[numNeurons + NUM_BIAS_NEURONS][numNeurons + NUM_BIAS_NEURONS];
        this.connected = new boolean[numNeurons + NUM_BIAS_NEURONS][numNeurons + NUM_BIAS_NEURONS];
        this.previousDeltaWij = new double[numNeurons + NUM_BIAS_NEURONS][numNeurons + NUM_BIAS_NEURONS];
        this.layerBreaks = this.incrementAllBy(layerBreaks, NUM_BIAS_NEURONS);
        this.numNeurons = numNeurons + NUM_BIAS_NEURONS;
        this.learningRate = learningRate;
        this.momentumTerm = momentumTerm;
        this.setUpConnectivity();
    }

    protected double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    protected double sigmoidDerivative(double x) {
        return this.sigmoid(x) * (1.0 - this.sigmoid(x));
    }

    public void reinitializeRandomWeightsWith(double scale) {
        this.randomInitialScale = scale;
        System.out.println("Perceptron: randomInitialScale = " + this.randomInitialScale);
        this.setUpConnectivity();
    }

    private double smallRandomWeight() {
        return this.randomInitialScale * ((this.randomNumberGenerator.nextDouble() - 0.5) / 5.0);
    }

    public void setUpConnectivity() {
        int destLayer;
        for (int sourceLayer = 0; sourceLayer < this.layerBreaks.length; ++sourceLayer) {
            destLayer = sourceLayer + 1;
            for (int pre = 0 + NUM_BIAS_NEURONS; pre < this.numNeurons; ++pre) {
                for (int post = 0 + NUM_BIAS_NEURONS; post < this.numNeurons; ++post) {
                    if (!this.inLayer(sourceLayer, pre) || !this.inLayer(destLayer, post)) continue;
                    this.connected[pre][post] = true;
                    this.weight[pre][post] = this.smallRandomWeight();
                }
            }
        }
        for (int pre = 0; pre < NUM_BIAS_NEURONS; ++pre) {
            for (destLayer = 1; destLayer < this.layerBreaks.length; ++destLayer) {
                for (int post = 0 + NUM_BIAS_NEURONS; post < this.numNeurons; ++post) {
                    if (!this.inLayer(destLayer, post)) continue;
                    this.connected[pre][post] = true;
                    this.weight[pre][post] = this.smallRandomWeight();
                }
            }
        }
    }

    public void copyWeightsTo(Perceptron p) {
        for (int i = 0; i < this.numNeurons; ++i) {
            for (int j = 0; j < this.numNeurons; ++j) {
                p.setWeight(i, j, this.weight[i][j]);
            }
        }
    }

    protected boolean inLayer(int layerNumber, int neuronNumber) {
        if (layerNumber >= this.layerBreaks.length) {
            return false;
        }
        return layerNumber == 0 ? neuronNumber >= 0 && neuronNumber < this.layerBreaks[0] : neuronNumber >= this.layerBreaks[layerNumber - 1] && neuronNumber < this.layerBreaks[layerNumber];
    }

    public void feedforward(double[] inputPattern) {
        for (int i = 0; i < NUM_BIAS_NEURONS; ++i) {
            this.netInput[i] = -1.0;
            this.activity[i] = -1.0;
        }
        int inputPatternIndex = 0;
        for (int post = 0 + NUM_BIAS_NEURONS; post < this.numNeurons; ++post) {
            this.activity[post] = 0.0;
            this.netInput[post] = 0.0;
            if (inputPatternIndex < inputPattern.length) {
                this.netInput[post] = inputPattern[inputPatternIndex];
                this.activity[post] = inputPattern[inputPatternIndex];
                ++inputPatternIndex;
                continue;
            }
            for (int pre = 0; pre < post; ++pre) {
                if (!this.connected[pre][post]) continue;
                this.netInput[post] = this.netInput[post] + this.weight[pre][post] * this.activity[pre];
            }
            this.activity[post] = this.sigmoid(this.netInput[post]);
        }
    }

    public double[][] getDerivativeAgainstWeights() {
        double[][] derivative = new double[this.numNeurons][this.numNeurons];
        for (int post = 0; post < this.numNeurons; ++post) {
            for (int pre = 0; pre < this.numNeurons; ++pre) {
                if (!this.connected[pre][post]) continue;
                derivative[pre][post] = this.activity[pre] * this.sigmoidDerivative(this.netInput[post]);
            }
        }
        return derivative;
    }

    public double[][] getOutputDerivativeAgainstWeights() {
        double[][] derivative = new double[this.numNeurons][this.numNeurons];
        for (int post = 0; post < this.numNeurons; ++post) {
            for (int pre = 0; pre < this.numNeurons; ++pre) {
                if (!this.connected[pre][post]) continue;
                if (this.inLayer(1, pre)) {
                    derivative[pre][post] = this.activity[post] * (1.0 - this.activity[post]) * this.activity[pre];
                }
                if (!this.inLayer(0, pre)) continue;
                int input = pre;
                int hidden = post;
                int output = this.getNumNeurons() - 1;
                derivative[input][hidden] = this.activity[output] * (1.0 - this.activity[output]) * this.weight[hidden][output] * this.activity[hidden] * (1.0 - this.activity[hidden]);
            }
        }
        return derivative;
    }

    public double[][] getDeltaWij(double[] outputPattern) {
        int post;
        int lastNonOutputUnit;
        double[][] deltaWij = new double[this.numNeurons][this.numNeurons];
        this.totalError = 0.0;
        double[] error = new double[this.numNeurons];
        int inputIndex = outputPattern.length - 1;
        for (int outputNode = this.numNeurons - 1; outputNode >= this.numNeurons - outputPattern.length; --outputNode) {
            error[outputNode] = (outputPattern[inputIndex] - this.activity[outputNode]) * this.activity[outputNode] * (1.0 - this.activity[outputNode]);
            this.totalError += error[outputNode];
            --inputIndex;
        }
        for (int nonOutputNode = lastNonOutputUnit = outputNode; nonOutputNode >= 0; --nonOutputNode) {
            error[nonOutputNode] = 0.0;
            for (post = nonOutputNode + 1; post < this.numNeurons; ++post) {
                if (!this.connected[nonOutputNode][post]) continue;
                int n = nonOutputNode;
                error[n] = error[n] + error[post] * this.weight[nonOutputNode][post];
            }
            int n = nonOutputNode;
            error[n] = error[n] * (this.activity[nonOutputNode] * (1.0 - this.activity[nonOutputNode]));
        }
        for (int pre = 0; pre < this.numNeurons; ++pre) {
            for (post = 0; post < this.numNeurons; ++post) {
                if (!this.connected[pre][post]) continue;
                deltaWij[pre][post] = this.learningRate * this.activity[pre] * error[post];
            }
        }
        return deltaWij;
    }

    public double getSumSquaredError() {
        return this.sumSquaredError;
    }

    public void backpropogate(double[] outputPattern) {
        this.sumSquaredError = 0.0;
        int j = 0;
        for (int i = this.numNeurons - outputPattern.length; i < this.numNeurons; ++i) {
            this.sumSquaredError += (outputPattern[j] - this.activity[i]) * (outputPattern[j] - this.activity[i]);
            ++j;
        }
        double[][] deltaWij = this.getDeltaWij(outputPattern);
        for (int pre = 0; pre < this.numNeurons; ++pre) {
            for (int post = 0; post < this.numNeurons; ++post) {
                if (!this.connected[pre][post]) continue;
                deltaWij[pre][post] = deltaWij[pre][post] + this.momentumTerm * this.previousDeltaWij[pre][post];
                this.weight[pre][post] = this.weight[pre][post] + deltaWij[pre][post];
                this.previousDeltaWij[pre][post] = deltaWij[pre][post];
            }
        }
    }

    public boolean isConnected(int i, int j) {
        return this.connected[i + NUM_BIAS_NEURONS][j + NUM_BIAS_NEURONS];
    }

    public String getConnectivity() {
        String result = "";
        for (int i = 0; i < this.numNeurons; ++i) {
            result = result + i + "\t->";
            for (int j = 0; j < this.numNeurons; ++j) {
                System.out.println("connected[" + i + "][" + j + "] = " + this.connected[i][j]);
                if (!this.connected[i][j]) continue;
                result = result + " " + j + "@(" + this.weight[i][j] + ")";
            }
            result = result + "\n";
        }
        return result;
    }

    public double getTotalError() {
        return this.totalError;
    }

    public void setWeight(int i, int j, double value) {
        this.weight[i][j] = value;
    }

    public double[][] getWeights() {
        return this.weight;
    }

    public void setWeights(double[][] newWeights) {
        for (int i = 0; i < this.numNeurons; ++i) {
            for (int j = 0; j < this.numNeurons; ++j) {
                this.weight[i][j] = newWeights[i][j];
            }
        }
    }

    public double[] getWeights1D() {
        double[] result = new double[this.numNeurons * this.numNeurons];
        int z = 0;
        for (int i = 0; i < this.numNeurons; ++i) {
            for (int j = 0; j < this.numNeurons; ++j) {
                result[z] = this.weight[i][j];
                ++z;
            }
        }
        return result;
    }

    public void setWeights1D(double[] newWeights1D) {
        int z = 0;
        for (int i = 0; i < this.numNeurons; ++i) {
            for (int j = 0; j < this.numNeurons; ++j) {
                this.weight[i][j] = newWeights1D[z];
                ++z;
            }
        }
    }

    public double getActivity(int i) {
        return this.activity[i + NUM_BIAS_NEURONS];
    }

    public double[] getActivityVector() {
        double[] result = new double[this.numNeurons];
        for (int i = 0; i < this.numNeurons; ++i) {
            result[i] = this.activity[i];
        }
        return result;
    }

    public double getNetInput(int i) {
        return this.netInput[i + NUM_BIAS_NEURONS];
    }

    private int[] incrementAllBy(int[] a, int value) {
        int[] result = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = value + a[i];
        }
        return result;
    }

    public String getGraphviz(double threshold, double lineWidthScale) {
        int i;
        String result = "digraph srn {\nranksep=5;\n";
        int currentLayer = 0;
        result = result + "subgraph cluster_layer" + currentLayer + "{\n";
        for (i = 0; i < this.numNeurons; ++i) {
            if (!this.inLayer(currentLayer, i)) {
                result = result + " }\n";
                result = result + "subgraph cluster_layer" + ++currentLayer + "{\n";
            }
            result = result + i + ";";
        }
        result = result + "}\n";
        result = result.replaceAll("-> ", " ");
        result = result.replaceAll("->}", " }");
        for (i = 0; i < this.numNeurons; ++i) {
            for (int j = 0; j < this.numNeurons; ++j) {
                if (!this.connected[i][j] || !(Math.abs(this.weight[i][j]) > threshold)) continue;
                String arrowhead = this.weight[i][j] > 0.0 ? "inv" : "tee";
                result = result + i + " -> " + j + " ";
                result = result + "[style=\"setlinewidth(" + lineWidthScale * Math.abs(this.weight[i][j]) + ")\" arrowhead=\"" + arrowhead + "\"";
                result = arrowhead.equals("inv") ? result + " color=\"red\"" : result + " color=\"blue\"";
                result = result + "];\n";
            }
        }
        result = result + "}\n";
        return result;
    }
}

