/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.levy;

import java.io.FileInputStream;
import java.util.Properties;
import net.pakl.levy.Net;

public class Simulation {
    public static void main(String[] args) throws Exception {
        Net net = new Net();
        net.numNeurons = 2048;
        Properties p = new Properties();
        p.load(new FileInputStream("levy.prop"));
        net.K0 = new Double(p.getProperty("K0"));
        net.Kr = new Double(p.getProperty("Kr"));
        net.Ki = new Double(p.getProperty("Ki"));
        net.w0 = new Double(p.getProperty("w0"));
        net.desiredActivity = new Double(p.getProperty("a"));
        System.err.println("Initializing network");
        long beforeWiring = System.currentTimeMillis();
        net.initialize();
        long afterWiring = System.currentTimeMillis();
        System.err.println("  Wiring took " + (afterWiring - beforeWiring) + " ms");
        boolean[] Z0 = new boolean[net.numNeurons];
        System.err.println("Activating " + (double)net.numNeurons * net.desiredActivity + " neurons for initial Z0 vector...");
        int i = 0;
        while ((double)i < (double)net.numNeurons * net.desiredActivity) {
            Z0[i] = true;
            ++i;
        }
        net.externallyFire(Z0);
        net.feedforward();
        net.update();
        System.out.println(net.getFirings());
        for (i = 0; i < 100; ++i) {
            net.feedforward();
            net.update();
            System.out.println(net.getFirings());
        }
    }
}

