/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.levy;

import java.util.ArrayList;
import net.pakl.levy.Unit;

public class Net {
    public int numNeurons = 2048;
    ArrayList<Unit> units = new ArrayList();
    public double connectionProbability = 0.1;
    public double K0 = 0.001;
    public double Ki = 0.05;
    public double Kr = 0.055;
    public double numPreviouslyFired = 0.0;
    public double numForcedToFire = 0.0;
    public double w0 = 0.45;
    public double desiredActivity = 0.05;

    public void initialize() {
        for (int i = 0; i < this.numNeurons; ++i) {
            this.units.add(new Unit(this));
        }
        for (Unit i : this.units) {
            for (Unit j : this.units) {
                if (!(Math.random() < this.connectionProbability) || i == j) continue;
                i.projectTo(j, this.w0);
            }
        }
    }

    public void update() {
        int numCurrentlyFired = 0;
        for (Unit i : this.units) {
            i.update();
            if (!i.fired) continue;
            ++numCurrentlyFired;
        }
        this.numPreviouslyFired = numCurrentlyFired;
        System.err.println("activity = " + 100.0 * (this.numPreviouslyFired / (double)this.numNeurons) + "%");
    }

    public void feedforward() {
        for (Unit i : this.units) {
            i.feedforward();
        }
    }

    public void externallyFire(boolean[] firings) {
        int numForced = 0;
        for (int i = 0; i < this.units.size(); ++i) {
            if (!firings[i]) continue;
            this.units.get((int)i).fired = true;
            ++numForced;
        }
        this.numForcedToFire = numForced;
    }

    public String getFirings() {
        String result = "";
        for (Unit u : this.units) {
            if (u.fired) {
                result = result + "1 ";
                continue;
            }
            result = result + "0 ";
        }
        return result;
    }
}

