/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.bumps;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;

public class Test {
    int units = 50;
    int seed = 0;
    double[] activity = new double[this.units];
    double[][] weight = new double[this.units][this.units];
    Random rng = null;
    boolean running = true;
    double exciteDecayGradient = 1.0;
    double inhibitDecayGradient = 1.0;
    int localExcitatory = 4;
    int distantInhibitory = 9;
    double exciteWeightScale = 0.7;
    double inhibitWeightScale = 0.5;
    int timestepsToRun = 100;
    ArrayList<Integer> stimulusTimes = new ArrayList();
    ArrayList<Integer> stimulusUnits = new ArrayList();

    public void initialize() throws Exception {
        Properties p = new Properties();
        p.load(new FileInputStream("settings.prop"));
        System.err.println("seed");
        this.seed = new Integer(p.getProperty("seed"));
        this.rng = new Random(this.seed);
        System.err.println("localExcitatory");
        this.localExcitatory = new Integer(p.getProperty("localExcitatory"));
        System.err.println("distantInhibitory");
        this.distantInhibitory = new Integer(p.getProperty("distantInhibitory"));
        System.err.println("exciteWeightScale");
        this.exciteWeightScale = new Double(p.getProperty("exciteWeightScale"));
        System.err.println("inhibitWeightScale");
        this.inhibitWeightScale = new Double(p.getProperty("inhibitWeightScale"));
        System.err.println("exciteDecayGradient");
        this.exciteDecayGradient = new Double(p.getProperty("exciteDecayGradient"));
        System.err.println("inhibitDecayGradient");
        this.inhibitDecayGradient = new Double(p.getProperty("inhibitDecayGradient"));
        String s1 = p.getProperty("stimulusTimes");
        String s2 = p.getProperty("stimulusUnits");
        StringTokenizer t1 = new StringTokenizer(s1, " ", false);
        StringTokenizer t2 = new StringTokenizer(s2, " ", false);
        while (t1.hasMoreTokens()) {
            this.stimulusTimes.add(new Integer(t1.nextToken()));
            this.stimulusUnits.add(new Integer(t2.nextToken()));
        }
        for (int pre = 0; pre < this.units; ++pre) {
            for (int post = 0; post < this.units; ++post) {
                double distance = Math.abs(pre - post);
                if (!(distance <= (double)this.distantInhibitory)) continue;
                if (distance <= (double)this.localExcitatory) {
                    this.weight[pre][post] = 1.0 / (this.exciteDecayGradient * (distance + 1.0));
                    double[] dArray = this.weight[pre];
                    int n = post;
                    dArray[n] = dArray[n] * this.exciteWeightScale;
                    continue;
                }
                this.weight[pre][post] = -1.0 / (this.inhibitDecayGradient * (distance + 1.0));
                double[] dArray = this.weight[pre];
                int n = post;
                dArray[n] = dArray[n] * this.inhibitWeightScale;
            }
        }
    }

    public void run() throws Exception {
        this.initialize();
        int timesteps = 0;
        while (this.running) {
            ++timesteps;
            double[] newActivity = new double[this.units];
            for (int post = 0; post < this.units; ++post) {
                for (int pre = 0; pre < this.units; ++pre) {
                    int n = post;
                    newActivity[n] = newActivity[n] + this.activity[pre] * this.weight[pre][post];
                }
                if (newActivity[post] < 0.0) {
                    newActivity[post] = 0.0;
                }
                if (!(newActivity[post] > 1.0)) continue;
                newActivity[post] = 1.0;
            }
            this.activity = newActivity;
            this.displayVector(this.activity);
            if (this.stimulusTimes.contains(timesteps)) {
                this.activity[this.stimulusUnits.get((int)this.stimulusTimes.indexOf((Object)Integer.valueOf((int)timesteps))).intValue()] = 1.0;
            }
            if (timesteps <= this.timestepsToRun) continue;
            this.running = false;
        }
    }

    public void displayVector(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            System.out.printf("%.2f ", x[i]);
        }
        System.out.println("");
    }

    public static void main(String[] args) throws Exception {
        new Test().run();
    }
}

