/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class MultipleCosineComparisons {
    ArrayList meanings = new ArrayList();

    public static void main(String[] args) throws Exception {
        new MultipleCosineComparisons().run();
    }

    public void run() throws Exception {
        this.meanings.add("meaning000");
        this.meanings.add("meaning001");
        this.meanings.add("meaning002");
        this.meanings.add("meaning003");
        int numStimuli = 119;
        int counterBetweenEnters = 0;
        for (int stimulusNumber = 0; stimulusNumber <= numStimuli; ++stimulusNumber) {
            String networkOutputFileName = "stimulus" + this.makeFileNumberFrom(stimulusNumber, numStimuli) + "-out.txt";
            BufferedReader aFile = new BufferedReader(new FileReader(networkOutputFileName));
            double[] aVector = this.readVector(aFile);
            for (int meaningNumber = 0; meaningNumber < this.meanings.size(); ++meaningNumber) {
                BufferedReader bFile = new BufferedReader(new FileReader((String)this.meanings.get(meaningNumber)));
                double[] bVector = this.readVector(bFile);
                System.out.print(this.cosineComparison(aVector, bVector) + " ");
                bFile.close();
            }
            if (++counterBetweenEnters == this.meanings.size()) {
                System.out.println("");
                counterBetweenEnters = 0;
            }
            aFile.close();
        }
    }

    private double cosineComparison(double[] a, double[] b) {
        return this.vdot(a, b) / (this.vlen(a) * this.vlen(b));
    }

    protected double vlen(double[] a) {
        return Math.sqrt(this.vdot(a, a));
    }

    protected double vdot(double[] u, double[] v) {
        if (u.length != v.length) {
            throw new RuntimeException("Vectors must be of same length for dot product.");
        }
        double result = 0.0;
        for (int i = 0; i < u.length; ++i) {
            result += u[i] * v[i];
        }
        return result;
    }

    public double[] readVector(BufferedReader file) throws Exception {
        return this.convertToVector(file.readLine());
    }

    public double[] convertToVector(String line) throws Exception {
        StringTokenizer t = new StringTokenizer(line, " ", false);
        int width = 0;
        while (t.hasMoreTokens()) {
            ++width;
            t.nextToken();
        }
        double[] result = new double[width];
        t = new StringTokenizer(line, " ", false);
        int i = 0;
        while (t.hasMoreTokens()) {
            result[i] = new Double(t.nextToken());
            ++i;
        }
        return result;
    }

    private String makeFileNumberFrom(int n, int max) {
        String currentNumber = n + "";
        String maximumNumber = max + "";
        String result = currentNumber;
        int c = maximumNumber.length() - currentNumber.length();
        for (int i = 0; i < c; ++i) {
            result = "0" + result;
        }
        return result;
    }
}

