/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class GenerateNormallyDistributedStimuli {
    private PrintStream out = System.out;
    private InputStream in = System.in;
    Random random = new Random(12345L);
    private int UNIFORM_ACTIVITY = 1001;
    private int DIVIDE_BY_DISTANCE_ACTIVITY = 1002;
    int ACTIVITY_STYLE = this.UNIFORM_ACTIVITY;

    public static void main(String[] args) throws Exception {
        GenerateNormallyDistributedStimuli me = new GenerateNormallyDistributedStimuli();
        me.start();
    }

    public double findMultiplierForVariance(double desiredVariance) {
        double[] tempRand = new double[1000];
        double sum = 0.0;
        double actualVariance = 0.0;
        for (int i = 0; i < 1000; ++i) {
            tempRand[i] = this.random.nextGaussian();
            sum += tempRand[i];
        }
        double mean = sum / 1000.0;
        for (int i = 0; i < 1000; ++i) {
            actualVariance += 0.001 * (tempRand[i] - mean) * (tempRand[i] - mean);
        }
        this.out.println("Actual variance is " + actualVariance);
        double result = Math.sqrt(desiredVariance / actualVariance);
        this.out.println("Therefore, to achieve desired variance, must multiply all numbers by " + result);
        return result;
    }

    public void start() throws Exception {
        this.out.println("--------------------------------------------------------------------------------");
        this.out.println("McClelland-Laurent Research Project (Context Effects on Categorical Perception)");
        this.out.println("Stimulus Generator -- January 2005");
        this.out.println("--------------------------------------------------------------------------------");
        this.out.println("");
        BufferedReader input = new BufferedReader(new InputStreamReader(this.in));
        this.out.print("Please enter OPERATING MODE.  1 = gaussian distributions, 2 = 1/2^n distributions. [2]: ");
        int MODE = new Integer(input.readLine());
        this.out.println("1=Uniform Activity Patterns, 2 = 0.9/distFromCenter: [2]:");
        this.ACTIVITY_STYLE = new Integer(input.readLine());
        this.out.print("Duration of Context Stimulus: ");
        int contextDuration = new Integer(input.readLine());
        this.out.print("Duration of Pattern Stimulus: ");
        int patternDuration = new Integer(input.readLine());
        this.out.print("Duration of Silence after Stimulus: ");
        int silenceDuration = new Integer(input.readLine());
        this.out.print("Input layer width: ");
        int inputLayerWidth = new Integer(input.readLine());
        this.out.print("Width of context stimuli: ");
        int contextWidth = new Integer(input.readLine());
        this.out.print("Width of input stimuli (ODD NUMBER): ");
        int stimulusWidth = new Integer(input.readLine());
        this.out.print("Desired Variance of stimuli from their distributions: ");
        double desiredVariance = new Double(input.readLine());
        double multiplierForVariance = this.findMultiplierForVariance(desiredVariance);
        int stimulusDistributionsPerContext = 2;
        ArrayList<String> contextPatterns = new ArrayList<String>();
        HashMap contextPatternsToStimulusCenters = new HashMap();
        for (int context = 0; context < 3; ++context) {
            this.out.println("* Setting up context " + context + " *");
            this.out.print("  What is the center of Context input pattern? ");
            String contextPattern = new String(input.readLine());
            contextPatterns.add(contextPattern);
            this.out.println("  Now, enter the 2 stimulus center coordinates for this context.");
            ArrayList<Integer> stimulusCenters = new ArrayList<Integer>();
            for (int stimulus = 0; stimulus < 2; ++stimulus) {
                this.out.print("    Center of distribution for stimulus #" + stimulus + ": ");
                stimulusCenters.add(new Integer(input.readLine()));
            }
            contextPatternsToStimulusCenters.put(contextPattern.toString(), stimulusCenters);
        }
        this.out.print("Now -- how many stimuli to generate for EACH context? ");
        int stimuliPerContext = new Integer(input.readLine());
        this.out.println("Recap");
        for (String contextPattern : contextPatterns) {
            this.out.println("For context pattern " + contextPattern);
            List stimulusCenters = (List)contextPatternsToStimulusCenters.get(contextPattern);
            Iterator j = stimulusCenters.iterator();
            while (j.hasNext()) {
                this.out.println("  center: " + j.next());
            }
        }
        this.out.println("Generating...");
        if (MODE == 2) {
            int stimulusCounter = 0;
            int totalStimuli = stimuliPerContext * contextPatterns.size();
            for (String contextPattern : contextPatterns) {
                System.out.println("Processing context pattern " + contextPattern);
                List stimulusCenters = (List)contextPatternsToStimulusCenters.get(contextPattern);
                ArrayList<Integer> stimCentersRelativeToDistCenter = new ArrayList<Integer>();
                int tailLength = -1 + (int)(Math.log((double)stimuliPerContext / 2.0) / Math.log(2.0));
                int stimCenterRelativeToDistCenter = 0 - tailLength;
                for (int distCenter = -tailLength; distCenter <= tailLength; ++distCenter) {
                    int numPatternsInBar = Math.abs(tailLength) - Math.abs(distCenter) + 1;
                    for (int count = 0; count < numPatternsInBar; ++count) {
                        stimCentersRelativeToDistCenter.add(new Integer(stimCenterRelativeToDistCenter));
                    }
                    ++stimCenterRelativeToDistCenter;
                    System.out.println("stimCentersRelativeToDistCenter = " + stimCentersRelativeToDistCenter);
                }
                System.out.println("Writing " + stimulusDistributionsPerContext + " stimulus distributions for this context.");
                for (int stimulusDistribution = 0; stimulusDistribution < stimulusDistributionsPerContext; ++stimulusDistribution) {
                    int distCenter = (Integer)stimulusCenters.get(stimulusDistribution);
                    System.out.println("Writing " + stimuliPerContext / stimulusDistributionsPerContext + " stimuli");
                    for (int generated = 0; generated < stimuliPerContext / stimulusDistributionsPerContext; ++generated) {
                        int t;
                        BufferedWriter outputFile = new BufferedWriter(new FileWriter("stimulus" + this.makeFileNumberFrom(stimulusCounter, totalStimuli)));
                        for (int t2 = 0; t2 < contextDuration; ++t2) {
                            int contextPatternCenter = new Integer(contextPattern);
                            String actualContextPattern = this.generateStimulusPattern(contextPatternCenter, contextWidth, inputLayerWidth, 0.0, 0.0);
                            outputFile.write(actualContextPattern + "\n");
                        }
                        stimCenterRelativeToDistCenter = (Integer)stimCentersRelativeToDistCenter.get(generated);
                        String stimulusPattern = this.generateStimulusPattern(distCenter + stimCenterRelativeToDistCenter, stimulusWidth, inputLayerWidth, 0.0, 0.0);
                        for (int t3 = 0; t3 < patternDuration; ++t3) {
                            outputFile.write(stimulusPattern + "\n");
                        }
                        BufferedWriter centerFile = new BufferedWriter(new FileWriter("data" + this.makeFileNumberFrom(stimulusCounter, totalStimuli)));
                        centerFile.write("contextPatternCenter = " + contextPattern + "\n");
                        centerFile.write("distributionCenter =  " + distCenter + "\n");
                        centerFile.write("stimCenterRelativeToDistCenter = " + stimCenterRelativeToDistCenter + "\n");
                        centerFile.close();
                        String silencePattern = "";
                        for (t = 0; t < inputLayerWidth; ++t) {
                            silencePattern = silencePattern + "0 ";
                        }
                        silencePattern = silencePattern.trim();
                        for (t = 0; t < silenceDuration; ++t) {
                            outputFile.write(silencePattern + "\n");
                        }
                        outputFile.close();
                        ++stimulusCounter;
                    }
                }
            }
        }
        if (MODE == 1) {
            int stimulusCounter = 0;
            int totalStimuli = stimuliPerContext * contextPatterns.size();
            for (String contextPattern : contextPatterns) {
                for (int generated = 0; generated < stimuliPerContext; ++generated) {
                    int t;
                    BufferedWriter outputFile = new BufferedWriter(new FileWriter("stimulus" + this.makeFileNumberFrom(stimulusCounter, totalStimuli)));
                    for (int t4 = 0; t4 < contextDuration; ++t4) {
                        int contextPatternCenter = new Integer(contextPattern);
                        String actualContextPattern = this.generateStimulusPattern(contextPatternCenter, contextWidth, inputLayerWidth, 0.0, 0.0);
                        outputFile.write(actualContextPattern + "\n");
                    }
                    List stimulusCenters = (List)contextPatternsToStimulusCenters.get(contextPattern);
                    Collections.shuffle(stimulusCenters);
                    int stimulusCenter = (Integer)stimulusCenters.get(0);
                    BufferedWriter centerFile = new BufferedWriter(new FileWriter("data" + this.makeFileNumberFrom(stimulusCounter, totalStimuli)));
                    centerFile.write(stimulusCenter + "\n");
                    centerFile.close();
                    String stimulusPattern = this.generateStimulusPattern(stimulusCenter, stimulusWidth, inputLayerWidth, multiplierForVariance, desiredVariance);
                    for (int t5 = 0; t5 < patternDuration; ++t5) {
                        outputFile.write(stimulusPattern + "\n");
                    }
                    String silencePattern = "";
                    for (t = 0; t < inputLayerWidth; ++t) {
                        silencePattern = silencePattern + "0 ";
                    }
                    silencePattern = silencePattern.trim();
                    for (t = 0; t < silenceDuration; ++t) {
                        outputFile.write(silencePattern + "\n");
                    }
                    outputFile.close();
                    ++stimulusCounter;
                }
            }
        }
    }

    private String makeFileNumberFrom(int n, int max) {
        String currentNumber = n + "";
        String maximumNumber = max + "";
        String result = currentNumber;
        int c = maximumNumber.length() - currentNumber.length();
        for (int i = 0; i < c; ++i) {
            result = "0" + result;
        }
        return result;
    }

    private String generateStimulusPattern(int stimulusCenter, int stimulusWidth, int layerWidth, double multiplierForVariance, double desiredVariance) {
        String result = "";
        int actualCenter = 0;
        if (stimulusCenter != -1) {
            while (actualCenter == 0 || (double)Math.abs(actualCenter - stimulusCenter) > desiredVariance) {
                actualCenter = (int)Math.round((double)stimulusCenter + multiplierForVariance * this.random.nextGaussian());
                System.out.print(".");
            }
        }
        if (stimulusCenter == -1) {
            actualCenter = 0;
        }
        if (multiplierForVariance > 0.0) {
            this.out.println("stimcenter = " + stimulusCenter + " actual center = " + actualCenter);
        }
        for (int i = 0; i < layerWidth; ++i) {
            result = Math.abs(actualCenter - i) <= (stimulusWidth - 1) / 2 ? (stimulusCenter == -1 ? result + "0" : (this.ACTIVITY_STYLE == 1 ? result + "1" : result + "" + 0.9 / (1.0 + (double)Math.abs(actualCenter - i)))) : result + "0";
            if (i >= layerWidth - 1) continue;
            result = result + " ";
        }
        return result;
    }
}

