/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class DistributionVarianceMeasurer {
    private int numberOfStimuli = 0;
    private int timeStepToMeasure = 0;

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            throw new RuntimeException("\nUsage: java DistributionVarianceMeasurer numStimuli timestep <----\n");
        }
        Integer numberOfStimuli = new Integer(args[0]);
        Integer timestepToMeasure = new Integer(args[1]);
        DistributionVarianceMeasurer me = new DistributionVarianceMeasurer();
        me.numberOfStimuli = numberOfStimuli;
        me.timeStepToMeasure = timestepToMeasure;
        me.run();
    }

    public void setNumberOfStimuli(Integer n) {
        this.numberOfStimuli = n;
    }

    private void showShiftsForEachDistributionCenter(HashMap observedCenters, HashMap originalCenters, int timeStepToMeasure) {
        System.out.println("Shifts for each Distribution Center");
        for (Object key : observedCenters.keySet()) {
            List a = (List)originalCenters.get(key);
            List b = (List)observedCenters.get(key);
            double alreadyShown = -1.0;
            for (int i = 0; i < a.size(); ++i) {
                double originalCenter = (Double)a.get(i);
                double perceivedCenter = (Double)b.get(i);
                if (originalCenter != alreadyShown) {
                    System.out.println(key + " " + originalCenter + " " + (perceivedCenter - originalCenter) + " ");
                }
                alreadyShown = originalCenter;
            }
            System.out.println("");
        }
    }

    public void run() throws Exception {
        HashMap observedCenters = new HashMap();
        HashMap originalCenters = new HashMap();
        for (int i = 0; i < this.numberOfStimuli; ++i) {
            Properties data = new Properties();
            data.load(new FileInputStream(this.dataFilenameFor(i)));
            Integer key = new Integer(data.getProperty("center2"));
            this.addToList(observedCenters, key, this.getNetworkOutputCenterAtTime(i, this.timeStepToMeasure));
            this.addToList(originalCenters, key, this.getDesiredOutputCenterAtTime(i, this.timeStepToMeasure));
        }
        this.showShiftsForEachDistributionCenter(observedCenters, originalCenters, this.timeStepToMeasure);
        double sum1 = 0.0;
        double sum2 = 0.0;
        HashMap<Integer, Double> originalAverages = new HashMap<Integer, Double>();
        HashMap<Integer, Double> observedAverages = new HashMap<Integer, Double>();
        for (Integer key : observedCenters.keySet()) {
            sum1 = 0.0;
            sum2 = 0.0;
            List observedValues = (List)observedCenters.get(key);
            List originalValues = (List)originalCenters.get(key);
            Iterator j1 = observedValues.iterator();
            Iterator j2 = originalValues.iterator();
            while (j1.hasNext()) {
                sum1 += ((Double)j1.next()).doubleValue();
            }
            while (j2.hasNext()) {
                sum2 += ((Double)j2.next()).doubleValue();
            }
            observedAverages.put(key, new Double(sum1 / (double)observedValues.size()));
            originalAverages.put(key, new Double(sum2 / (double)originalValues.size()));
        }
        HashMap originalVariances = new HashMap();
        HashMap observedVariances = new HashMap();
        for (Object key : observedCenters.keySet()) {
            sum1 = 0.0;
            sum2 = 0.0;
            double mean1 = (Double)observedAverages.get(key);
            double mean2 = (Double)originalAverages.get(key);
            List observedValues = (List)observedCenters.get(key);
            List originalValues = (List)originalCenters.get(key);
            Iterator j1 = observedValues.iterator();
            Iterator j2 = originalValues.iterator();
            while (j1.hasNext()) {
                sum1 += Math.pow(mean1 - (Double)j1.next(), 2.0);
            }
            while (j2.hasNext()) {
                sum2 += Math.pow(mean2 - (Double)j2.next(), 2.0);
            }
            observedVariances.put(key, new Double(sum1 / (double)observedValues.size()));
            originalVariances.put(key, new Double(sum2 / (double)originalValues.size()));
        }
        System.out.println("Original Means:\n" + this.sortedPrint(originalAverages));
        System.out.println("Observed Means:\n" + this.sortedPrint(observedAverages));
        System.out.println("Original Variances:\n" + this.sortedPrint(originalVariances));
        System.out.println("Observed Variances:\n" + this.sortedPrint(observedVariances));
    }

    private void addToList(HashMap map, Integer key, Object value) {
        ArrayList<Object> list = (ArrayList<Object>)map.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
        }
        list.add(value);
        map.put(key, list);
    }

    private String sortedPrint(HashMap h) {
        String result = "";
        ArrayList keys = new ArrayList();
        keys.addAll(h.keySet());
        Collections.sort(keys);
        Collections.reverse(keys);
        for (Object key : keys) {
            result = result + "\n";
            result = result + key + "  ";
            result = result + h.get(key);
        }
        return result + "\n";
    }

    private Double getNetworkOutputCenterAtTime(int stimulusNumber, int timeStepToMeasure) throws Exception {
        return this.getValueFromLine(this.outputFilenameFor(stimulusNumber, "Output"), timeStepToMeasure);
    }

    private Double getDesiredOutputCenterAtTime(int stimulusNumber, int timeStepToMeasure) throws Exception {
        return this.getValueFromLine(this.outputFilenameFor(stimulusNumber, "Desired"), timeStepToMeasure);
    }

    private Double getValueFromLine(String filename, int lineNumber) throws Exception {
        BufferedReader f = new BufferedReader(new FileReader(filename));
        for (int i = 0; i < lineNumber; ++i) {
            f.readLine();
        }
        String line = f.readLine();
        try {
            Double result = new Double(line);
            return result;
        }
        catch (Exception e) {
            System.err.println("\nCaught error while reading file " + filename + " where the line was " + line + "\n");
            throw e;
        }
    }

    private String outputFilenameFor(int stimulusNumber, String addon) {
        return stimulusNumber + ".centers" + addon;
    }

    private String dataFilenameFor(int stimulusNumber) {
        return this.filenameFor("data", stimulusNumber, "");
    }

    private String stimulusFilenameFor(int stimulusNumber) {
        return this.filenameFor("stimulus", stimulusNumber, "");
    }

    private String filenameFor(String filePrefix, int stimulusNumber, String fileSuffix) {
        String numericalPrefix = new String();
        int maxNumDigits = ("" + this.numberOfStimuli).length();
        int numDigits = ("" + stimulusNumber).length();
        int zeroesRequired = maxNumDigits - numDigits;
        for (int i = 0; i < zeroesRequired; ++i) {
            numericalPrefix = numericalPrefix + "0";
        }
        return filePrefix + numericalPrefix + stimulusNumber + fileSuffix;
    }
}

