/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;

public class ContinuousSpeechSimulator {
    Random random;
    public int inputVectorWidth = 40;
    public int randomSeed;
    public int numToGenerate = 10;
    public int stutter = 1;
    public double denominator = 1.0;
    public int numGenerated = 0;
    ArrayList streams = new ArrayList();
    static int uniqueStimulusID;

    public static void main(String[] args) throws Exception {
        new ContinuousSpeechSimulator().run();
    }

    public void run() {
        try {
            this.readProperties();
            this.init();
            this.readSettings();
            for (int i = 0; i < this.numToGenerate; ++i) {
                this.generate();
            }
        }
        catch (Exception e) {
            System.out.println("\n\nError, can't continue: \"" + e.getMessage() + "\"");
        }
    }

    public void generate() throws Exception {
        for (List stream : this.streams) {
            Iterator ticks = stream.iterator();
            BufferedWriter writer = new BufferedWriter(new FileWriter("stimulus" + this.makeFileNumberFrom(uniqueStimulusID, this.numToGenerate * this.streams.size())));
            BufferedWriter centerWriter = new BufferedWriter(new FileWriter("data" + this.makeFileNumberFrom(uniqueStimulusID, this.numToGenerate * this.streams.size())));
            int tickCounter = 0;
            while (ticks.hasNext()) {
                Tick t = (Tick)ticks.next();
                centerWriter.write("center" + ++tickCounter + " = " + t.getMean() + "\n");
                for (int sampleNumber = 0; sampleNumber < t.getSampleCount(); ++sampleNumber) {
                    int stimulus = t.sample();
                    for (int j = 0; j < t.getDuration(); ++j) {
                        writer.write(this.centerToPattern(stimulus, t.getWidth()) + "\n");
                    }
                }
                System.out.print(".");
            }
            writer.close();
            centerWriter.close();
            ++uniqueStimulusID;
        }
    }

    public String centerToPattern(int center, int stimulusWidth) {
        String result = "";
        if (center > this.inputVectorWidth) {
            throw new RuntimeException("Widen your input vector size in continuous.prop -- center at " + center);
        }
        if (center + stimulusWidth / 2 > this.inputVectorWidth) {
            throw new RuntimeException("Pattern with center at " + center + " and width " + stimulusWidth + " extends beyond input pattern width -- widen your input vector size.");
        }
        for (int i = 0; i < this.inputVectorWidth; ++i) {
            result = Math.abs(i - center) <= stimulusWidth / 2 ? result + Math.pow(1.0 / this.denominator, Math.abs(i - center)) + " " : result + "0 ";
        }
        return result.trim();
    }

    public void init() throws Exception {
        System.out.println("Random number generator initialized with seed " + this.randomSeed);
        this.random = new Random(this.randomSeed);
    }

    public void readProperties() throws Exception {
        Properties p = new Properties();
        p.load(new FileInputStream("continuous.prop"));
        if (p.getProperty("numToGenerate") != null) {
            this.numToGenerate = new Integer(p.getProperty("numToGenerate"));
        }
        if (p.getProperty("inputVectorWidth") != null) {
            this.inputVectorWidth = new Integer(p.getProperty("inputVectorWidth"));
        }
        if (p.getProperty("denominator") != null) {
            this.denominator = new Double(p.getProperty("denominator"));
        }
        if (p.getProperty("randomSeed") != null) {
            this.randomSeed = new Integer(p.getProperty("randomSeed"));
        }
        if (p.getProperty("stutter") != null) {
            this.stutter = new Integer(p.getProperty("stutter"));
        }
    }

    public void readSettings() throws Exception {
        BufferedReader r = new BufferedReader(new FileReader("continuous.settings"));
        while (r.ready()) {
            String streamString = r.readLine();
            StringTokenizer t = new StringTokenizer(streamString, " ", false);
            ArrayList<Tick> stream = new ArrayList<Tick>();
            while (t.hasMoreTokens()) {
                stream.add(new Tick(t.nextToken()));
            }
            this.streams.add(stream);
        }
        r.close();
    }

    public double findMultiplierForVariance(double desiredVariance) {
        double[] tempRand = new double[5000];
        double sum = 0.0;
        double actualVariance = 0.0;
        for (int i = 0; i < 5000; ++i) {
            tempRand[i] = this.random.nextGaussian();
            sum += tempRand[i];
        }
        double mean = sum / 5000.0;
        for (int i = 0; i < 5000; ++i) {
            actualVariance += 2.0E-4 * (tempRand[i] - mean) * (tempRand[i] - mean);
        }
        double result = Math.sqrt(desiredVariance / actualVariance);
        return result;
    }

    private String makeFileNumberFrom(int n, int max) {
        String currentNumber = n + "";
        String maximumNumber = max + "";
        String result = currentNumber;
        int c = maximumNumber.length() - currentNumber.length();
        for (int i = 0; i < c; ++i) {
            result = "0" + result;
        }
        return result;
    }

    class Tick {
        double mean;
        double variance;
        double width;
        double duration;
        double limit = 0.0;
        double samples = 1.0;

        public Tick(String meanAndVariance) {
            String s = meanAndVariance.replaceAll("\\(", "");
            s = s.replaceAll("\\)", "");
            s = s.replaceAll("=", ",");
            StringTokenizer t = new StringTokenizer(s, ",", false);
            while (t.hasMoreTokens()) {
                String key = t.nextToken();
                if (key.equalsIgnoreCase("mean")) {
                    this.mean = new Double(t.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("variance")) {
                    this.variance = new Double(t.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("width")) {
                    this.width = new Double(t.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("duration")) {
                    this.duration = new Double(t.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("limit")) {
                    this.limit = new Double(t.nextToken());
                    continue;
                }
                if (key.equalsIgnoreCase("samples")) {
                    this.samples = new Double(t.nextToken());
                    continue;
                }
                throw new RuntimeException("Unrecognized key: " + key + ". Keys can only be: mean=, variance=, width=, duration=, samples=");
            }
        }

        public int sample() {
            if (this.variance == 0.0) {
                return (int)this.mean;
            }
            int actualCenter = (int)this.mean;
            while (!(Math.abs((double)(actualCenter = (int)this.mean + (int)Math.round(ContinuousSpeechSimulator.this.findMultiplierForVariance(this.variance) * ContinuousSpeechSimulator.this.random.nextGaussian())) - this.mean) <= this.limit)) {
            }
            return actualCenter;
        }

        public int getWidth() {
            return (int)this.width;
        }

        public int getDuration() {
            return (int)this.duration;
        }

        public int getSampleCount() {
            return (int)this.samples;
        }

        public int getMean() {
            return (int)this.mean;
        }

        public String toString() {
            return "[" + this.mean + "," + this.variance + "]";
        }
    }
}

