/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.helpers;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.util.Collection;

public abstract class WaitQueue {
    public abstract void insert(WaitNode var1);

    public abstract WaitNode extract();

    public abstract boolean hasNodes();

    public abstract int getLength();

    public abstract Collection getWaitingThreads();

    public abstract boolean isWaiting(Thread var1);

    public static class WaitNode {
        boolean waiting = true;
        WaitNode next = null;
        Thread owner = Thread.currentThread();

        public synchronized boolean signal() {
            boolean signalled = this.waiting;
            if (signalled) {
                this.waiting = false;
                this.notify();
            }
            return signalled;
        }

        public synchronized boolean doTimedWait(QueuedSync sync, long nanos) throws InterruptedException {
            if (sync.recheck(this) || !this.waiting) {
                return true;
            }
            if (nanos <= 0L) {
                this.waiting = false;
                return false;
            }
            long deadline = Utils.nanoTime() + nanos;
            try {
                do {
                    TimeUnit.NANOSECONDS.timedWait(this, nanos);
                    if (this.waiting) continue;
                    return true;
                } while ((nanos = deadline - Utils.nanoTime()) > 0L);
                this.waiting = false;
                return false;
            }
            catch (InterruptedException ex) {
                if (this.waiting) {
                    this.waiting = false;
                    throw ex;
                }
                Thread.currentThread().interrupt();
                return true;
            }
        }

        public synchronized void doWait(QueuedSync sync) throws InterruptedException {
            if (!sync.recheck(this)) {
                try {
                    while (this.waiting) {
                        this.wait();
                    }
                }
                catch (InterruptedException ex) {
                    if (this.waiting) {
                        this.waiting = false;
                        throw ex;
                    }
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    public static interface QueuedSync {
        public boolean recheck(WaitNode var1);
    }
}

