/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.helpers;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.NanoTimer;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Perf;

public final class Utils {
    private static final NanoTimer nanoTimer;
    private static final String providerProp = "edu.emory.mathcs.backport.java.util.concurrent.NanoTimerProvider";

    private Utils() {
    }

    public static long nanoTime() {
        return nanoTimer.nanoTime();
    }

    public static long awaitNanos(Condition cond, long nanosTimeout) throws InterruptedException {
        if (nanosTimeout <= 0L) {
            return nanosTimeout;
        }
        long now = Utils.nanoTime();
        cond.await(nanosTimeout, TimeUnit.NANOSECONDS);
        return nanosTimeout - (Utils.nanoTime() - now);
    }

    private static long gcd(long a, long b) {
        while (b > 0L) {
            long r = a % b;
            a = b;
            b = r;
        }
        return a;
    }

    static {
        NanoTimer timer = null;
        try {
            String nanoTimerClassName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(Utils.providerProp);
                }
            });
            if (nanoTimerClassName != null) {
                Class<?> cls = Class.forName(nanoTimerClassName);
                timer = (NanoTimer)cls.newInstance();
            }
        }
        catch (Exception e) {
            System.err.println("WARNING: unable to load Perf provider; switching to a default");
            e.printStackTrace();
        }
        if (timer == null) {
            try {
                timer = new SunPerfProvider();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (timer == null) {
            timer = new MillisProvider();
        }
        nanoTimer = timer;
    }

    private static final class MillisProvider
    implements NanoTimer {
        MillisProvider() {
        }

        public long nanoTime() {
            return System.currentTimeMillis() * 1000000L;
        }
    }

    private static final class SunPerfProvider
    implements NanoTimer {
        final Perf perf = (Perf)AccessController.doPrivileged(new PrivilegedAction(this){
            private final /* synthetic */ SunPerfProvider this$0;
            {
                this.this$0 = this$0;
            }

            public Object run() {
                return Perf.getPerf();
            }
        });
        final long multiplier;
        final long divisor;

        SunPerfProvider() {
            long numerator = 1000000000L;
            long denominator = this.perf.highResFrequency();
            long gcd = Utils.gcd(numerator, denominator);
            this.multiplier = numerator / gcd;
            this.divisor = denominator / gcd;
        }

        public long nanoTime() {
            return this.perf.highResCounter() * this.multiplier / this.divisor;
        }
    }
}

