/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import java.io.Serializable;

public class TimeUnit
implements Serializable {
    public static final TimeUnit NANOSECONDS = new TimeUnit(0, "NANOSECONDS");
    public static final TimeUnit MICROSECONDS = new TimeUnit(1, "MICROSECONDS");
    public static final TimeUnit MILLISECONDS = new TimeUnit(2, "MILLISECONDS");
    public static final TimeUnit SECONDS = new TimeUnit(3, "SECONDS");
    private final int index;
    private final String name;
    private static final int[] multipliers = new int[]{1, 1000, 1000000, 1000000000};
    private static final long[] overflows = new long[]{0L, 9223372036854775L, 9223372036854L, 9223372036L};

    TimeUnit(int index, String name) {
        this.index = index;
        this.name = name;
    }

    private static long doConvert(int delta, long duration) {
        if (delta == 0) {
            return duration;
        }
        if (delta < 0) {
            return duration / (long)multipliers[-delta];
        }
        if (duration > overflows[delta]) {
            return Long.MAX_VALUE;
        }
        if (duration < -overflows[delta]) {
            return Long.MIN_VALUE;
        }
        return duration * (long)multipliers[delta];
    }

    public long convert(long duration, TimeUnit unit) {
        return TimeUnit.doConvert(unit.index - this.index, duration);
    }

    public long toNanos(long duration) {
        return TimeUnit.doConvert(this.index, duration);
    }

    public long toMicros(long duration) {
        return TimeUnit.doConvert(this.index - TimeUnit.MICROSECONDS.index, duration);
    }

    public long toMillis(long duration) {
        return TimeUnit.doConvert(this.index - TimeUnit.MILLISECONDS.index, duration);
    }

    public long toSeconds(long duration) {
        return TimeUnit.doConvert(this.index - TimeUnit.SECONDS.index, duration);
    }

    private int excessNanos(long time, long ms) {
        if (this == NANOSECONDS) {
            return (int)(time - ms * 1000L * 1000L);
        }
        if (this == MICROSECONDS) {
            return (int)(time * 1000L - ms * 1000L * 1000L);
        }
        return 0;
    }

    public void timedWait(Object obj, long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms = this.toMillis(timeout);
            int ns = this.excessNanos(timeout, ms);
            obj.wait(ms, ns);
        }
    }

    public void timedJoin(Thread thread, long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms = this.toMillis(timeout);
            int ns = this.excessNanos(timeout, ms);
            thread.join(ms, ns);
        }
    }

    public void sleep(long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms = this.toMillis(timeout);
            int ns = this.excessNanos(timeout, ms);
            Thread.sleep(ms, ns);
        }
    }

    public String toString() {
        return this.name;
    }
}

