/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.FIFOWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WaitQueue;
import java.io.Serializable;
import java.util.Collection;

public class Semaphore
implements Serializable {
    private static final long serialVersionUID = -3222578661600680210L;
    private final Impl impl;

    public Semaphore(int permits) {
        this.impl = new NonfairImpl(permits);
    }

    public Semaphore(int permits, boolean fair) {
        this.impl = fair ? new FairImpl(permits) : new NonfairImpl(permits);
    }

    public void acquire() throws InterruptedException {
        this.impl.acquire();
    }

    public void acquireUninterruptibly() {
        boolean wasInterrupted = false;
        while (true) {
            try {
                this.impl.acquire();
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
    }

    public boolean tryAcquire() {
        return this.impl.attempt();
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.impl.attempt(unit.toNanos(timeout));
    }

    public void release() {
        this.impl.release(1);
    }

    public void release(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        this.impl.release(permits);
    }

    public int availablePermits() {
        return this.impl.getPermits();
    }

    public int drainPermits() {
        return this.impl.drain();
    }

    protected void reducePermits(int reduction) {
        if (reduction < 0) {
            throw new IllegalArgumentException();
        }
        this.impl.reduce(reduction);
    }

    public boolean isFair() {
        return this.impl instanceof FairImpl;
    }

    public final boolean hasQueuedThreads() {
        return this.impl.hasQueuedThreads();
    }

    public final int getQueueLength() {
        return this.impl.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        return this.impl.getQueuedThreads();
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.impl.getPermits() + "]";
    }

    static final class FairImpl
    extends Impl
    implements WaitQueue.QueuedSync,
    Serializable {
        WaitQueue wq_ = new FIFOWaitQueue();

        FairImpl(int initialPermits) {
            super(initialPermits);
        }

        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck()) {
                return;
            }
            WaitQueue.WaitNode w = new WaitQueue.WaitNode();
            w.doWait(this);
        }

        public boolean attempt(long nanos) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck()) {
                return true;
            }
            if (nanos <= 0L) {
                return false;
            }
            WaitQueue.WaitNode w = new WaitQueue.WaitNode();
            return w.doTimedWait(this, nanos);
        }

        protected synchronized boolean precheck() {
            boolean pass;
            boolean bl = pass = this.permits_ > 0;
            if (pass) {
                --this.permits_;
            }
            return pass;
        }

        public synchronized boolean recheck(WaitQueue.WaitNode w) {
            boolean pass;
            boolean bl = pass = this.permits_ > 0;
            if (pass) {
                --this.permits_;
            } else {
                this.wq_.insert(w);
            }
            return pass;
        }

        protected synchronized WaitQueue.WaitNode getSignallee() {
            WaitQueue.WaitNode w = this.wq_.extract();
            if (w == null) {
                ++this.permits_;
            }
            return w;
        }

        public void release() {
            WaitQueue.WaitNode w;
            do {
                if ((w = this.getSignallee()) != null) continue;
                return;
            } while (!w.signal());
        }

        public void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            for (int i = 0; i < n; ++i) {
                this.release();
            }
        }

        public synchronized boolean hasQueuedThreads() {
            return this.wq_.hasNodes();
        }

        public synchronized int getQueueLength() {
            return this.wq_.getLength();
        }

        public synchronized Collection getQueuedThreads() {
            return this.wq_.getWaitingThreads();
        }
    }

    static final class NonfairImpl
    extends Impl
    implements Serializable {
        protected NonfairImpl(int initialPermits) {
            super(initialPermits);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            NonfairImpl nonfairImpl = this;
            synchronized (nonfairImpl) {
                try {
                    while (this.permits_ <= 0) {
                        this.wait();
                    }
                    --this.permits_;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }

        public boolean attempt(long nanos) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            NonfairImpl nonfairImpl = this;
            synchronized (nonfairImpl) {
                if (this.permits_ > 0) {
                    --this.permits_;
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                try {
                    long deadline = Utils.nanoTime() + nanos;
                    do {
                        TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        if (this.permits_ <= 0) continue;
                        --this.permits_;
                        return true;
                    } while ((nanos = deadline - Utils.nanoTime()) > 0L);
                    return false;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }

        public synchronized void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            this.permits_ += n;
            for (int i = 0; i < n; ++i) {
                this.notify();
            }
        }

        public synchronized int getPermits() {
            return this.permits_;
        }

        public boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }
    }

    static abstract class Impl
    implements Serializable {
        int permits_;

        protected Impl(int permits) {
            this.permits_ = permits;
        }

        abstract void acquire() throws InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean attempt() {
            Impl impl = this;
            synchronized (impl) {
                if (this.permits_ > 0) {
                    --this.permits_;
                    return true;
                }
                return false;
            }
        }

        abstract boolean attempt(long var1) throws InterruptedException;

        abstract void release(int var1);

        public int getPermits() {
            return this.permits_;
        }

        public synchronized int drain() {
            int acquired = this.permits_;
            this.permits_ = 0;
            return acquired;
        }

        public synchronized void reduce(int reduction) {
            this.permits_ -= reduction;
        }

        abstract boolean hasQueuedThreads();

        abstract int getQueueLength();

        abstract Collection getQueuedThreads();
    }
}

