/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LinkedBlockingQueue
extends AbstractQueue
implements BlockingQueue,
Serializable {
    private static final long serialVersionUID = -6903933977591709194L;
    protected transient LinkedNode head_;
    protected transient LinkedNode last_;
    protected final Object putGuard_ = new Guard();
    protected final Object takeGuard_ = new Guard();
    protected int capacity_;
    protected transient int putSidePutPermits_;
    protected transient int takeSidePutPermits_ = 0;

    public LinkedBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity_ = capacity;
        this.putSidePutPermits_ = capacity;
        this.last_ = this.head_ = new LinkedNode(null);
    }

    public LinkedBlockingQueue(Collection c) {
        this(Integer.MAX_VALUE);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    protected final int reconcilePutPermits() {
        this.putSidePutPermits_ += this.takeSidePutPermits_;
        this.takeSidePutPermits_ = 0;
        return this.putSidePutPermits_;
    }

    public synchronized int size() {
        return this.capacity_ - (this.takeSidePutPermits_ + this.putSidePutPermits_);
    }

    public int remainingCapacity() {
        return this.capacity_ - this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void allowTake() {
        Object object = this.takeGuard_;
        synchronized (object) {
            this.takeGuard_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(Object x) {
        --this.putSidePutPermits_;
        LinkedNode p = new LinkedNode(x);
        LinkedNode linkedNode = this.last_;
        synchronized (linkedNode) {
            this.last_.next = p;
            this.last_ = p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object o) throws InterruptedException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.putGuard_;
        synchronized (object) {
            if (this.putSidePutPermits_ <= 0) {
                LinkedBlockingQueue linkedBlockingQueue = this;
                synchronized (linkedBlockingQueue) {
                    if (this.reconcilePutPermits() <= 0) {
                        try {
                            do {
                                this.wait();
                            } while (this.reconcilePutPermits() <= 0);
                        }
                        catch (InterruptedException ex) {
                            this.notify();
                            throw ex;
                        }
                    }
                }
            }
            this.insert(o);
        }
        this.allowTake();
    }

    /*
     * Exception decompiling
     */
    public boolean offer(Object o, long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 12[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Object object = this.putGuard_;
        synchronized (object) {
            if (this.putSidePutPermits_ <= 0) {
                LinkedBlockingQueue linkedBlockingQueue = this;
                synchronized (linkedBlockingQueue) {
                    if (this.reconcilePutPermits() <= 0) {
                        return false;
                    }
                }
            }
            this.insert(o);
        }
        this.allowTake();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object extract() {
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            Object x = null;
            LinkedNode first = this.head_.next;
            if (first != null) {
                x = first.value;
                first.value = null;
                this.head_ = first;
                ++this.takeSidePutPermits_;
                this.notify();
            }
            return x;
        }
    }

    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.takeGuard_;
        synchronized (object) {
            try {
                while (true) {
                    if ((x = this.extract()) != null) {
                        return x;
                    }
                    this.takeGuard_.wait();
                }
            }
            catch (InterruptedException ex) {
                this.takeGuard_.notify();
                throw ex;
            }
        }
    }

    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        long nanos = unit.toNanos(timeout);
        Object object = this.takeGuard_;
        synchronized (object) {
            try {
                long deadline = Utils.nanoTime() + nanos;
                while (true) {
                    if ((x = this.extract()) != null || nanos <= 0L) {
                        return x;
                    }
                    TimeUnit.NANOSECONDS.timedWait(this.takeGuard_, nanos);
                    nanos = deadline - Utils.nanoTime();
                }
            }
            catch (InterruptedException ex) {
                this.takeGuard_.notify();
                throw ex;
            }
        }
    }

    public Object poll() {
        return this.extract();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            LinkedNode first = this.head_.next;
            if (first != null) {
                return first.value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        boolean removed = false;
        Object object = this.putGuard_;
        synchronized (object) {
            Object object2 = this.takeGuard_;
            synchronized (object2) {
                LinkedBlockingQueue linkedBlockingQueue = this;
                synchronized (linkedBlockingQueue) {
                    LinkedNode linkedNode = this.head_;
                    synchronized (linkedNode) {
                        LinkedNode trail = this.head_;
                        LinkedNode p = this.head_.next;
                        while (p != null) {
                            if (o.equals(p.value)) {
                                removed = true;
                                break;
                            }
                            trail = p;
                            p = p.next;
                        }
                        if (removed) {
                            p.value = null;
                            trail.next = p.next;
                            ++this.takeSidePutPermits_;
                            this.notify();
                        }
                    }
                }
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object object = this.putGuard_;
        synchronized (object) {
            Object object2 = this.takeGuard_;
            synchronized (object2) {
                int size = this.size();
                Object[] a = new Object[size];
                int k = 0;
                LinkedNode p = this.head_.next;
                while (p != null) {
                    a[k++] = p.value;
                    p = p.next;
                }
                return a;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        Object object = this.putGuard_;
        synchronized (object) {
            Object object2 = this.takeGuard_;
            synchronized (object2) {
                int size = this.size();
                if (a.length < size) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                }
                int k = 0;
                LinkedNode p = this.head_.next;
                while (p != null) {
                    a[k++] = p.value;
                    p = p.next;
                }
                return a;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.putGuard_;
        synchronized (object) {
            Object object2 = this.takeGuard_;
            synchronized (object2) {
                return super.toString();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedBlockingQueue linkedBlockingQueue = this;
        synchronized (linkedBlockingQueue) {
            int count;
            int sizeBound = this.size();
            LinkedNode node = this.head_;
            for (count = 0; count < sizeBound; ++count) {
                LinkedNode linkedNode = node;
                synchronized (linkedNode) {
                    node.value = null;
                    if (node.next == null) {
                        break;
                    }
                    node = node.next;
                    continue;
                }
            }
            this.head_ = node;
            this.takeSidePutPermits_ += count;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c) {
        int count;
        LinkedNode tail;
        LinkedNode first;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        LinkedBlockingQueue linkedBlockingQueue = this;
        synchronized (linkedBlockingQueue) {
            int maxElements = this.size();
            first = this.head_;
            tail = this.head_;
            for (count = 0; count < maxElements; ++count) {
                LinkedNode linkedNode = tail;
                synchronized (linkedNode) {
                    if (tail.next == null) {
                        break;
                    }
                    tail = tail.next;
                    continue;
                }
            }
            this.head_ = tail;
            this.takeSidePutPermits_ += count;
            this.notify();
        }
        LinkedNode p = first;
        while (p != tail) {
            p = p.next;
            c.add(p.value);
            p.value = null;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c, int maxElements) {
        LinkedNode tail;
        LinkedNode first;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        int count = 0;
        LinkedBlockingQueue linkedBlockingQueue = this;
        synchronized (linkedBlockingQueue) {
            int sizeBound = this.size();
            if (maxElements > sizeBound) {
                maxElements = sizeBound;
            }
            first = this.head_;
            tail = this.head_;
            while (count < maxElements) {
                LinkedNode linkedNode = tail;
                synchronized (linkedNode) {
                    if (tail.next == null) {
                        break;
                    }
                    tail = tail.next;
                }
                ++count;
            }
            this.head_ = tail;
            this.takeSidePutPermits_ += count;
            this.notify();
        }
        LinkedNode p = first;
        while (p != tail) {
            p = p.next;
            c.add(p.value);
            p.value = null;
        }
        return count;
    }

    public Iterator iterator() {
        return new Itr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        LinkedBlockingQueue linkedBlockingQueue = this;
        synchronized (linkedBlockingQueue) {
            LinkedNode p;
            s.defaultWriteObject();
            LinkedNode linkedNode = this.head_;
            synchronized (linkedNode) {
                p = this.head_.next;
            }
            while (true) {
                if (p == null) break;
                linkedNode = p;
                synchronized (linkedNode) {
                    s.writeObject(p.value);
                    p = p.next;
                }
            }
            s.writeObject(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        LinkedBlockingQueue linkedBlockingQueue = this;
        synchronized (linkedBlockingQueue) {
            s.defaultReadObject();
            this.putSidePutPermits_ = this.capacity_;
            this.takeSidePutPermits_ = 0;
            this.last_ = this.head_ = new LinkedNode(null);
        }
        while ((item = s.readObject()) != null) {
            this.add(item);
        }
    }

    private class Itr
    implements Iterator {
        private LinkedNode current;
        private LinkedNode lastRet;
        private Object currentElement;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            LinkedBlockingQueue linkedBlockingQueue = LinkedBlockingQueue.this;
            synchronized (linkedBlockingQueue) {
                LinkedNode linkedNode = LinkedBlockingQueue.this.head_;
                synchronized (linkedNode) {
                    this.current = LinkedBlockingQueue.this.head_.next;
                    if (this.current != null) {
                        this.currentElement = this.current.value;
                    }
                }
            }
        }

        public boolean hasNext() {
            return this.current != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            LinkedBlockingQueue linkedBlockingQueue = LinkedBlockingQueue.this;
            synchronized (linkedBlockingQueue) {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                LinkedNode linkedNode = this.current;
                synchronized (linkedNode) {
                    Object x = this.currentElement;
                    this.lastRet = this.current;
                    this.current = this.current.next;
                    if (this.current != null) {
                        this.currentElement = this.current.value;
                    }
                    return x;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            LinkedBlockingQueue linkedBlockingQueue = LinkedBlockingQueue.this;
            synchronized (linkedBlockingQueue) {
                LinkedNode node = this.lastRet;
                this.lastRet = null;
                LinkedNode trail = LinkedBlockingQueue.this.head_;
                while (trail != null) {
                    LinkedNode linkedNode = trail;
                    synchronized (linkedNode) {
                        if (trail.next == node) {
                            LinkedNode linkedNode2 = node;
                            synchronized (linkedNode2) {
                                trail.next = node.next;
                                node.value = null;
                                ++LinkedBlockingQueue.this.takeSidePutPermits_;
                                LinkedBlockingQueue.this.notify();
                                break;
                            }
                        }
                        trail = trail.next;
                    }
                }
            }
        }
    }

    private static class Guard
    implements Serializable {
        private Guard() {
        }
    }

    class LinkedNode {
        Object value;
        LinkedNode next;

        LinkedNode() {
        }

        LinkedNode(Object x) {
            this.value = x;
        }

        LinkedNode(Object x, LinkedNode n) {
            this.value = x;
            this.next = n;
        }
    }
}

