/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;

public class Exchanger {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition taken = this.lock.newCondition();
    private Object item;
    private int arrivalCount;

    private Object doExchange(Object x, boolean timed, long nanos) throws InterruptedException, TimeoutException {
        this.lock.lock();
        try {
            int count;
            while (this.arrivalCount == 2) {
                if (!timed) {
                    this.taken.await();
                    continue;
                }
                if (nanos > 0L) {
                    nanos = Utils.awaitNanos(this.taken, nanos);
                    continue;
                }
                throw new TimeoutException();
            }
            if ((count = ++this.arrivalCount) == 2) {
                Object other = this.item;
                this.item = x;
                this.taken.signal();
                Object object = other;
                return object;
            }
            this.item = x;
            InterruptedException interrupted = null;
            try {
                while (this.arrivalCount != 2) {
                    if (!timed) {
                        this.taken.await();
                        continue;
                    }
                    if (nanos > 0L) {
                        nanos = Utils.awaitNanos(this.taken, nanos);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ie) {
                interrupted = ie;
            }
            Object other = this.item;
            this.item = null;
            count = this.arrivalCount;
            this.arrivalCount = 0;
            this.taken.signal();
            if (count == 2) {
                if (interrupted != null) {
                    Thread.currentThread().interrupt();
                }
                Object object = other;
                return object;
            }
            if (interrupted != null) {
                throw interrupted;
            }
            throw new TimeoutException();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Object exchange(Object x) throws InterruptedException {
        try {
            return this.doExchange(x, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            throw new Error(cannotHappen);
        }
    }

    public Object exchange(Object x, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        return this.doExchange(x, true, unit.toNanos(timeout));
    }
}

