/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.PriorityQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Delayed;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.Collection;
import java.util.Iterator;

public class DelayQueue
extends AbstractQueue
implements BlockingQueue {
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition available = this.lock.newCondition();
    private final PriorityQueue q = new PriorityQueue();
    static final /* synthetic */ boolean $assertionsDisabled;

    public DelayQueue() {
    }

    public DelayQueue(Collection c) {
        this.addAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first = this.q.peek();
            this.q.offer(o);
            if (first == null || ((Delayed)o).compareTo(first) < 0) {
                this.available.signalAll();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void put(Object o) {
        this.offer(o);
    }

    public boolean offer(Object o, long timeout, TimeUnit unit) {
        return this.offer(o);
    }

    public boolean add(Object o) {
        return this.offer(o);
    }

    public Object take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                Object first;
                if ((first = this.q.peek()) == null) {
                    this.available.await();
                    continue;
                }
                long delay = ((Delayed)first).getDelay(TimeUnit.NANOSECONDS);
                if (delay > 0L) {
                    this.available.await(delay, TimeUnit.NANOSECONDS);
                    continue;
                }
                Object x = this.q.poll();
                if (!$assertionsDisabled && x == null) {
                    throw new AssertionError();
                }
                if (this.q.size() != 0) {
                    this.available.signalAll();
                }
                Object object = x;
                return object;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        long nanos = unit.toNanos(timeout);
        try {
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                Object first;
                if ((first = this.q.peek()) == null) {
                    if (nanos <= 0L) {
                        Object var10_8 = null;
                        return var10_8;
                    }
                    this.available.await(nanos, TimeUnit.NANOSECONDS);
                    nanos = deadline - Utils.nanoTime();
                    continue;
                }
                long delay = ((Delayed)first).getDelay(TimeUnit.NANOSECONDS);
                if (delay > 0L) {
                    if (delay > nanos) {
                        delay = nanos;
                    }
                    this.available.await(delay, TimeUnit.NANOSECONDS);
                    nanos = deadline - Utils.nanoTime();
                    continue;
                }
                Object x = this.q.poll();
                if (!$assertionsDisabled && x == null) {
                    throw new AssertionError();
                }
                if (this.q.size() != 0) {
                    this.available.signalAll();
                }
                Object object = x;
                return object;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first = this.q.peek();
            if (first == null || ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) > 0L) {
                Object var3_3 = null;
                return var3_3;
            }
            Object x = this.q.poll();
            if (!$assertionsDisabled && x == null) {
                throw new AssertionError();
            }
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            Object object = x;
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object object = this.q.peek();
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.q.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first;
            int n = 0;
            while ((first = this.q.peek()) != null && ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) <= 0L) {
                c.add(this.q.poll());
                ++n;
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object first;
            int n;
            for (n = 0; n < maxElements && (first = this.q.peek()) != null && ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) <= 0L; ++n) {
                c.add(this.q.poll());
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] array) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray(array);
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.remove(o);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Itr itr = new Itr(this.q.iterator());
            return itr;
        }
        finally {
            lock.unlock();
        }
    }

    static {
        $assertionsDisabled = !DelayQueue.class.desiredAssertionStatus();
    }

    private class Itr
    implements Iterator {
        private final Iterator iter;

        Itr(Iterator i) {
            this.iter = i;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            ReentrantLock lock = DelayQueue.this.lock;
            lock.lock();
            try {
                Object e = this.iter.next();
                return e;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            ReentrantLock lock = DelayQueue.this.lock;
            lock.lock();
            try {
                this.iter.remove();
            }
            finally {
                lock.unlock();
            }
        }
    }
}

