/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.BrokenBarrierException;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;

public class CyclicBarrier {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition trip = this.lock.newCondition();
    private final int parties;
    private final Runnable barrierCommand;
    private long generation;
    private boolean broken;
    private int count;

    private void nextGeneration() {
        this.count = this.parties;
        ++this.generation;
        this.trip.signalAll();
    }

    private void breakBarrier() {
        this.broken = true;
        this.trip.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int dowait(boolean timed, long nanos) throws InterruptedException, BrokenBarrierException, TimeoutException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            long deadline;
            int index = --this.count;
            long g = this.generation;
            if (this.broken) {
                throw new BrokenBarrierException();
            }
            if (Thread.interrupted()) {
                this.breakBarrier();
                throw new InterruptedException();
            }
            if (index == 0) {
                this.nextGeneration();
                boolean ranAction = false;
                try {
                    Runnable command = this.barrierCommand;
                    if (command != null) {
                        command.run();
                    }
                    ranAction = true;
                    int n = 0;
                    return n;
                }
                finally {
                    if (!ranAction) {
                        this.breakBarrier();
                    }
                }
            }
            do {
                deadline = Utils.nanoTime() + nanos;
                try {
                    if (!timed) {
                        this.trip.await();
                    } else {
                        this.trip.await(nanos, TimeUnit.NANOSECONDS);
                    }
                }
                catch (InterruptedException ie) {
                    this.breakBarrier();
                    throw ie;
                }
                if (this.broken) throw new BrokenBarrierException();
                if (g > this.generation) {
                    throw new BrokenBarrierException();
                }
                if (g >= this.generation) continue;
                int n = index;
                return n;
            } while (!timed || (nanos = deadline - Utils.nanoTime()) > 0L);
            this.breakBarrier();
            throw new TimeoutException();
        }
        finally {
            lock.unlock();
        }
    }

    public CyclicBarrier(int parties, Runnable barrierAction) {
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties = parties;
        this.count = parties;
        this.barrierCommand = barrierAction;
    }

    public CyclicBarrier(int parties) {
        this(parties, null);
    }

    public int getParties() {
        return this.parties;
    }

    public int await() throws InterruptedException, BrokenBarrierException {
        try {
            return this.dowait(false, 0L);
        }
        catch (TimeoutException toe) {
            throw new Error(toe);
        }
    }

    public int await(long timeout, TimeUnit unit) throws InterruptedException, BrokenBarrierException, TimeoutException {
        return this.dowait(true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBroken() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.broken;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.generation -= 4L;
            this.broken = false;
            this.trip.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberWaiting() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.parties - this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }
}

