/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class CopyOnWriteArrayList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    private volatile transient Object[] array;

    private Object[] array() {
        return this.array;
    }

    public CopyOnWriteArrayList() {
        this.array = new Object[0];
    }

    public CopyOnWriteArrayList(Collection c) {
        this.array = new Object[c.size()];
        Iterator i = c.iterator();
        int size = 0;
        while (i.hasNext()) {
            this.array[size++] = i.next();
        }
    }

    public CopyOnWriteArrayList(Object[] toCopyIn) {
        this.copyIn(toCopyIn, 0, toCopyIn.length);
    }

    private synchronized void copyIn(Object[] toCopyIn, int first, int n) {
        this.array = new Object[n];
        System.arraycopy(toCopyIn, first, this.array, 0, n);
    }

    public int size() {
        return this.array().length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object elem) {
        int len;
        Object[] elementData = this.array();
        return CopyOnWriteArrayList.indexOf(elem, elementData, len = elementData.length) >= 0;
    }

    public int indexOf(Object elem) {
        Object[] elementData = this.array();
        int len = elementData.length;
        return CopyOnWriteArrayList.indexOf(elem, elementData, len);
    }

    private static int indexOf(Object elem, Object[] elementData, int len) {
        if (elem == null) {
            for (int i = 0; i < len; ++i) {
                if (elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (!elem.equals(elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(Object elem, int index) {
        Object[] elementData = this.array();
        int elementCount = elementData.length;
        if (elem == null) {
            for (int i = index; i < elementCount; ++i) {
                if (elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < elementCount; ++i) {
                if (!elem.equals(elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object elem) {
        Object[] elementData = this.array();
        int len = elementData.length;
        return CopyOnWriteArrayList.lastIndexOf(elem, elementData, len);
    }

    private static int lastIndexOf(Object elem, Object[] elementData, int len) {
        if (elem == null) {
            for (int i = len - 1; i >= 0; --i) {
                if (elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = len - 1; i >= 0; --i) {
                if (!elem.equals(elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object elem, int index) {
        Object[] elementData = this.array();
        if (elem == null) {
            for (int i = index; i >= 0; --i) {
                if (elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (!elem.equals(elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            Object[] elementData = this.array();
            CopyOnWriteArrayList v = (CopyOnWriteArrayList)super.clone();
            v.array = new Object[elementData.length];
            System.arraycopy(elementData, 0, v.array, 0, elementData.length);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object[] toArray() {
        Object[] elementData = this.array();
        Object[] result = new Object[elementData.length];
        System.arraycopy(elementData, 0, result, 0, elementData.length);
        return result;
    }

    public Object[] toArray(Object[] a) {
        Object[] elementData = this.array();
        if (a.length < elementData.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), elementData.length);
        }
        System.arraycopy(elementData, 0, a, 0, elementData.length);
        if (a.length > elementData.length) {
            a[elementData.length] = null;
        }
        return a;
    }

    public Object get(int index) {
        Object[] elementData = this.array();
        this.rangeCheck(index, elementData.length);
        return elementData[index];
    }

    public synchronized Object set(int index, Object element) {
        boolean same;
        int len = this.array.length;
        this.rangeCheck(index, len);
        Object oldValue = this.array[index];
        boolean bl = same = oldValue == element || element != null && element.equals(oldValue);
        if (!same) {
            Object[] newArray = new Object[len];
            System.arraycopy(this.array, 0, newArray, 0, len);
            newArray[index] = element;
            this.array = newArray;
        }
        return oldValue;
    }

    public synchronized boolean add(Object element) {
        int len = this.array.length;
        Object[] newArray = new Object[len + 1];
        System.arraycopy(this.array, 0, newArray, 0, len);
        newArray[len] = element;
        this.array = newArray;
        return true;
    }

    public synchronized void add(int index, Object element) {
        int len = this.array.length;
        if (index > len || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        Object[] newArray = new Object[len + 1];
        System.arraycopy(this.array, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(this.array, index, newArray, index + 1, len - index);
        this.array = newArray;
    }

    public synchronized Object remove(int index) {
        int len = this.array.length;
        this.rangeCheck(index, len);
        Object oldValue = this.array[index];
        Object[] newArray = new Object[len - 1];
        System.arraycopy(this.array, 0, newArray, 0, index);
        int numMoved = len - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.array, index + 1, newArray, index, numMoved);
        }
        this.array = newArray;
        return oldValue;
    }

    public synchronized boolean remove(Object o) {
        int len = this.array.length;
        if (len == 0) {
            return false;
        }
        int newlen = len - 1;
        Object[] newArray = new Object[newlen];
        for (int i = 0; i < newlen; ++i) {
            if (o == this.array[i] || o != null && o.equals(this.array[i])) {
                for (int k = i + 1; k < len; ++k) {
                    newArray[k - 1] = this.array[k];
                }
                this.array = newArray;
                return true;
            }
            newArray[i] = this.array[i];
        }
        if (o == this.array[newlen] || o != null && o.equals(this.array[newlen])) {
            this.array = newArray;
            return true;
        }
        return false;
    }

    private synchronized void removeRange(int fromIndex, int toIndex) {
        int len = this.array.length;
        if (fromIndex < 0 || fromIndex >= len || toIndex > len || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        int numMoved = len - toIndex;
        int newlen = len - (toIndex - fromIndex);
        Object[] newArray = new Object[newlen];
        System.arraycopy(this.array, 0, newArray, 0, fromIndex);
        System.arraycopy(this.array, toIndex, newArray, fromIndex, numMoved);
        this.array = newArray;
    }

    public synchronized boolean addIfAbsent(Object element) {
        int len = this.array.length;
        Object[] newArray = new Object[len + 1];
        for (int i = 0; i < len; ++i) {
            if (element == this.array[i] || element != null && element.equals(this.array[i])) {
                return false;
            }
            newArray[i] = this.array[i];
        }
        newArray[len] = element;
        this.array = newArray;
        return true;
    }

    public boolean containsAll(Collection c) {
        Object[] elementData = this.array();
        int len = elementData.length;
        Iterator e = c.iterator();
        while (e.hasNext()) {
            if (CopyOnWriteArrayList.indexOf(e.next(), elementData, len) >= 0) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean removeAll(Collection c) {
        Object[] elementData = this.array;
        int len = elementData.length;
        if (len == 0) {
            return false;
        }
        Object[] temp = new Object[len];
        int newlen = 0;
        for (int i = 0; i < len; ++i) {
            Object element = elementData[i];
            if (c.contains(element)) continue;
            temp[newlen++] = element;
        }
        if (newlen == len) {
            return false;
        }
        Object[] newArray = new Object[newlen];
        System.arraycopy(temp, 0, newArray, 0, newlen);
        this.array = newArray;
        return true;
    }

    public synchronized boolean retainAll(Collection c) {
        Object[] elementData = this.array;
        int len = elementData.length;
        if (len == 0) {
            return false;
        }
        Object[] temp = new Object[len];
        int newlen = 0;
        for (int i = 0; i < len; ++i) {
            Object element = elementData[i];
            if (!c.contains(element)) continue;
            temp[newlen++] = element;
        }
        if (newlen == len) {
            return false;
        }
        Object[] newArray = new Object[newlen];
        System.arraycopy(temp, 0, newArray, 0, newlen);
        this.array = newArray;
        return true;
    }

    public synchronized int addAllAbsent(Collection c) {
        int numNew = c.size();
        if (numNew == 0) {
            return 0;
        }
        Object[] elementData = this.array;
        int len = elementData.length;
        Object[] temp = new Object[numNew];
        int added = 0;
        Iterator e = c.iterator();
        while (e.hasNext()) {
            Object element = e.next();
            if (CopyOnWriteArrayList.indexOf(element, elementData, len) >= 0 || CopyOnWriteArrayList.indexOf(element, temp, added) >= 0) continue;
            temp[added++] = element;
        }
        if (added == 0) {
            return 0;
        }
        Object[] newArray = new Object[len + added];
        System.arraycopy(elementData, 0, newArray, 0, len);
        System.arraycopy(temp, 0, newArray, len, added);
        this.array = newArray;
        return added;
    }

    public synchronized void clear() {
        this.array = new Object[0];
    }

    public synchronized boolean addAll(Collection c) {
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        int len = this.array.length;
        Object[] newArray = new Object[len + numNew];
        System.arraycopy(this.array, 0, newArray, 0, len);
        Iterator e = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            newArray[len++] = e.next();
        }
        this.array = newArray;
        return true;
    }

    public synchronized boolean addAll(int index, Collection c) {
        int len = this.array.length;
        if (index > len || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        Object[] newArray = new Object[len + numNew];
        System.arraycopy(this.array, 0, newArray, 0, len);
        int numMoved = len - index;
        if (numMoved > 0) {
            System.arraycopy(this.array, index, newArray, index + numNew, numMoved);
        }
        Iterator e = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            newArray[index++] = e.next();
        }
        this.array = newArray;
        return true;
    }

    private void rangeCheck(int index, int length) {
        if (index >= length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + length);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] elementData = this.array();
        s.writeInt(elementData.length);
        for (int i = 0; i < elementData.length; ++i) {
            s.writeObject(elementData[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        Object[] elementData = new Object[arrayLength];
        for (int i = 0; i < elementData.length; ++i) {
            elementData[i] = s.readObject();
        }
        this.array = elementData;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator e = this.iterator();
        buf.append("[");
        int maxIndex = this.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(String.valueOf(e.next()));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l2 = (List)o;
        if (this.size() != l2.size()) {
            return false;
        }
        ListIterator e1 = this.listIterator();
        ListIterator e2 = l2.listIterator();
        while (e1.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public Iterator iterator() {
        return new COWIterator(this.array(), 0);
    }

    public ListIterator listIterator() {
        return new COWIterator(this.array(), 0);
    }

    public ListIterator listIterator(int index) {
        Object[] elementData = this.array();
        int len = elementData.length;
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new COWIterator(this.array(), index);
    }

    public synchronized List subList(int fromIndex, int toIndex) {
        int len = this.array.length;
        if (fromIndex < 0 || toIndex > len || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(this, fromIndex, toIndex);
    }

    private static class COWSubListIterator
    implements ListIterator {
        private final ListIterator i;
        private final int index;
        private final int offset;
        private final int size;

        private COWSubListIterator(List l, int index, int offset, int size) {
            this.index = index;
            this.offset = offset;
            this.size = size;
            this.i = l.listIterator(index + offset);
        }

        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                return this.i.next();
            }
            throw new NoSuchElementException();
        }

        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        public Object previous() {
            if (this.hasPrevious()) {
                return this.i.previous();
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this.i.nextIndex() - this.offset;
        }

        public int previousIndex() {
            return this.i.previousIndex() - this.offset;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private static class COWSubList
    extends AbstractList {
        private final CopyOnWriteArrayList l;
        private final int offset;
        private int size;
        private Object[] expectedArray;

        private COWSubList(CopyOnWriteArrayList list, int fromIndex, int toIndex) {
            this.l = list;
            this.expectedArray = this.l.array();
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        private void checkForComodification() {
            if (this.l.array != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object element) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(index);
                this.checkForComodification();
                Object x = this.l.set(index + this.offset, element);
                this.expectedArray = this.l.array;
                return x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int index) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(index);
                this.checkForComodification();
                return this.l.get(index + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, Object element) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (index < 0 || index > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(index + this.offset, element);
                this.expectedArray = this.l.array;
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                this.l.removeRange(this.offset, this.offset + this.size);
                this.expectedArray = this.l.array;
                this.size = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int index) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(index);
                this.checkForComodification();
                Object result = this.l.remove(index + this.offset);
                this.expectedArray = this.l.array;
                --this.size;
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return new COWSubListIterator(this.l, 0, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator(int index) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (index < 0 || index > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
                }
                return new COWSubListIterator(this.l, index, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int fromIndex, int toIndex) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (fromIndex < 0 || toIndex > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList(this.l, fromIndex + this.offset, toIndex + this.offset);
            }
        }
    }

    private static class COWIterator
    implements ListIterator {
        private final Object[] array;
        private int cursor;

        private COWIterator(Object[] elementArray, int initialCursor) {
            this.array = elementArray;
            this.cursor = initialCursor;
        }

        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        public Object next() {
            try {
                return this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException ex) {
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                return this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

